-- munout.m
--
-- The Munich graphics model, implemented in NeWS (and LML)
--
-- By Andrew Dwelly (C) 1988 ECRC gmbh Munich
-- Version 0.1 1.9.88
--
-- Output commands

module

#include "ps.t"

infix "^";

export ColourType,ShapeType,FontType,CursorType,^,AddVec,SubVec,
       ConsolePrint,CoordType,AnimationType,
       LoadMunich,
       OpenCanvas,OpenPopCanvas,OpenOutlineCanvas,OpenOutlinePopCanvas,
       OpenClearCanvas,TopCanvas,BottomCanvas,
       OpenWindow,OpenPopWindow,KillCanvas,
       Text,CentredText,ChangeCursor,Draw,Fill,LineDraw,Bitmap,
       Animate,RevokeAnimate,MoveCanvas,
       StartApp,MessApp,StartClock,StopClock,
       Screen,Minus,CanId;

-- Functions to manipulate the graphics model. They are all public.

rec 

type ColourType = Thistle +
		  Black +
		  White +
		  SpringGreen +
		  MediumAquamarine +
		  LightBlue +
		  Blue +
		  DarkSlateGray +
		  CornFlowerBlue +
		  NavyBlue +
		  MediumSeaGreen +
		  MediumSlateBlue +
		  DarkOrchid +
		  Khaki +
		  LightSteelBlue +
		  SkyBlue +
		  Magenta +
		  DarkSlateBlue +
		  SteelBlue +
		  OrangeRed +
		  SeaGreen +
		  LightGray +
		  Violet +
		  CadetBlue +
		  VioletRed +
		  Orange + 
		  Coral +
		  Orchid +
		  MediumTurquoise +
		  SlateBlue +
		  YellowGreen +
		  FireBrick +
		  Cyan +
		  Red +
		  Goldenrod +
		  Tan

and type CoordType = Cart Int Int +
		     DummyCoord

and type ShapeType = Rect CoordType +
		     RoundRect CoordType Int +
		     Circle Int +
		     Ngon (List CoordType) +
		     NCurve (List CoordType) +
		     Segment CoordType Int Int Int +
		     Diamond CoordType Int Int

and type FontType = Helvetica +
	            HelveticaMedium +
	            HelveticaBold +
	            HelveticaOblique +
	            TimesRoman +
	            Courier +
	            CourierBold +
	            CourierOblique

and type CursorType = Ptr +
		      Bullseye +
		      RhtPtr +
		      Crosshair +
		      XCursor +
		      Hourglass +
		      None

and type AnimationType = Ghost ShapeType +
		         RubberBand CoordType +
		         RubberBox CoordType

and x^y = Cart x y

and AddVec (Cart x1 y1) (Cart x2 y2) = Cart (x1+x2) (y1+y2)

and SubVec (Cart x1 y1) (Cart x2 y2) = Cart (x1-x2) (y1-y2)

and LoadMunich = "(MUNICH) getenv (/munich.ps) append LoadFile pop\n"

and ConsolePrint str = PsStr str @ "cslpr\n"

and OpenCanvas n (Cart x y) (Cart xo yo) a (Cart sx sy) can col shp =
	PsNums [n;x;y;xo;yo;a;sx;sy;0] @ CanId can @ Col col @ Shape shp @
	"ocn\n" @ "/" @ CanId n @ " Cns\n"

and OpenPopCanvas n (Cart x y) (Cart xo yo) a (Cart sx sy) can col shp =
	PsNums [n;x;y;xo;yo;a;sx;sy;0] @ CanId can @ Col col @ Shape shp @
	"opcn\n" @ "/" @ CanId n @ " Cns\n"

and OpenOutlineCanvas n (Cart x y) (Cart xo yo) a (Cart sx sy) w can col shp =
	PsNums [n;x;y;xo;yo;a;sx;sy;w] @ CanId can @ Col col @ Shape shp @
	"ocn\n" @ "/" @ CanId n @ " Cns\n"

and OpenOutlinePopCanvas n (Cart x y) (Cart xo yo) a (Cart sx sy) w can col shp =
	PsNums [n;x;y;xo;yo;a;sx;sy;w] @ CanId can @ Col col @ Shape shp @
	"opcn\n" @ "/" @ CanId n @ " Cns\n"

and OpenClearCanvas n (Cart x y) (Cart xo yo) a (Cart sx sy) can shp =
	PsNums [n;x;y;xo;yo;a;sx;sy] @ CanId can @ Shape shp @ "occn\n" @
	"/" @ CanId n @ " Cns\n"

and TopCanvas n = CanId n @ "tc\n"

and BottomCanvas n = CanId n @ "bc\n"

and OpenWindow n org size prnt col = 
	OpenOutlineCanvas n org (0^0) 0 (100^100) 4 prnt col (Rect size)

and OpenPopWindow n org size prnt col = 
	OpenOutlinePopCanvas n org (0^0) 0 (100^100) 4 prnt col (Rect size)

and KillCanvas n = CanId n @ "kc\n"

and Text n (Cart x y) fnt scl col str =
	PsStr str @ Col col @ PsNums [x;y] @ CanId n @ PsNum scl @
	Font fnt @ "tx\n"

and CentredText n (Cart x y) fnt scl col str =
	PsStr str @ Col col @ PsNums [x;y] @ CanId n @ PsNum scl @
	Font fnt @ "ct\n"

and Draw can (Cart x y) (Cart xo yo) a (Cart sx sy) col shp =
	PsNums [x;y;xo;yo;a;sx;sy] @ CanId can @ Col col @ Shape shp @ "pd\n"

and Fill can col =
	CanId can @ Col col @ "fl\n"

and LineDraw can (Cart x y) (Cart xo yo) a (Cart sx sy) wd col shp =
	PsNums [x;y;xo;yo;a;sx;sy;wd] @ CanId can @ Col col @ Shape shp @ "ld\n"

and ChangeCursor can cur =
	Cursor cur @ CanId can @ "csr\n"

and Bitmap can (Cart x y) (Cart sx sy) str =
	PsStr str @ PsNums [sx; sy; x; y] @ CanId can @ "bm\n"

and Animate can a (Cart sx sy) (Ghost pth) = 
	CanId can @ PsNums [a;sx;sy] @ Shape pth @ "ga\n"
||  Animate can a (Cart sx sy) (RubberBand (Cart x y)) = 
	CanId can @ PsNums [a;sx;sy;x;y] @ "rba\n"
||  Animate can a (Cart sx sy) (RubberBox (Cart x y)) = 
	CanId can @ PsNums [a;sx;sy;x;y] @ "rbx\n"

and RevokeAnimate = "ra\n"

and MoveCanvas n (Cart x y) = PsNums [x;y] @ CanId n @ "mc\n"

and StartApp str = PsStr str @ "sa\n"

and MessApp str = PsStr str @ "sm\n"

and StartClock = "sck\n"

and StopClock = "stck\n"

-- Colours

and Col Thistle = "{Ths} "
||  Col Black = "{Blk} "
||  Col White = "{Wht} "
||  Col SpringGreen = "{SpGr} "
||  Col MediumAquamarine = "{MAq} " 
||  Col LightBlue = "{LB} " 
||  Col Blue = "{B} "
||  Col DarkSlateGray = "{DSG} "
||  Col CornFlowerBlue = "{CFB} "
||  Col NavyBlue = "{NB} "
||  Col MediumSeaGreen = "{MSG} "
||  Col MediumSlateBlue = "{MSB} " 
||  Col DarkOrchid = "{DO} "
||  Col Khaki = "{Kh} "
||  Col LightSteelBlue = "{LSB} "
||  Col SkyBlue = "{SkB} "
||  Col Magenta = "{Mag} "
||  Col DarkSlateBlue = "{DSB} "
||  Col SteelBlue = "{SB} "
||  Col OrangeRed = "{OR} "
||  Col SeaGreen = "{SG} "
||  Col LightGray = "{LGr} "
||  Col Violet = "{V} "
||  Col CadetBlue = "{CdB} "
||  Col VioletRed = "{VR} "
||  Col Orange = "{O} "
||  Col Coral = "{Cr} " 
||  Col Orchid = "{Orc} "
||  Col MediumTurquoise = "{MTu} "
||  Col SlateBlue = "{SlB} "
||  Col YellowGreen = "{YG} "
||  Col FireBrick = "{Fb} "
||  Col Cyan = "{Cn} "
||  Col Red = "{Rd} "
||  Col Goldenrod = "{Gr} "
||  Col Tan = "{Tn} "

-- Shapes 

and Shape (Rect (Cart x y)) = "{ 0 0 " @ PsNums [x;y] @ "rectpath} "
||  Shape (RoundRect (Cart x y) r) = "{" @ PsNum r @ "0 0 " @ PsNums [x;y] @ "rrectpath} "
||  Shape (Circle r) = "{" @ PsNum r @ "cp} "
||  Shape (Ngon l) = "{[" @ NgonShape l @ "] ngp} "
||  Shape (NCurve l) = if length l % 4 ~= 0 
		       then fail "Needs 4 points per curve"
		       else "{[" @ NCurveShape l @ "] ncp} "
||  Shape (Segment (Cart x y) r a1 a2) = "{" @ PsNums [r;a1;a2;x;y] @ "sp}"
||  Shape (Diamond (Cart x y) l a) = "{" @ PsNums [l;a;x;y] @ "dp}"

and NgonShape [] = []
||  NgonShape (Cart x y.t) = "[" @ PsNum x @ PsNum y @ "]" @ NgonShape t

and NCurveShape [] = []
||  NCurveShape (Cart x0 y0.
                 Cart x1 y1.
		 Cart x2 y2.
		 Cart x3 y3.
		 t) = "[" @ PsNums [x1;y1;x2;y2;x3;y3;x0;y0] @ "]"


-- Fonts

and Font Helvetica = "/Helvetica "
||  Font HelveticaMedium = "/Helvetica-Medium "
||  Font HelveticaBold = "/Helvetica-Bold "
||  Font HelveticaOblique = "/Helvetica-Oblique "
||  Font TimesRoman = "/Times-Roman "
||  Font Courier = "/Courier "
||  Font CourierBold = "/Courier-Bold "
||  Font CourierOblique = "/Courier-Oblique "

-- Cursors

and Cursor Ptr = "/ptr /ptr_m "
||  Cursor Bullseye = "/beye /beye_m "
||  Cursor RhtPtr = "/rtarr /rtarr_m "
||  Cursor Crosshair = "/xhair /xhair_m "
||  Cursor XCursor = "/xcurs /xcurs_m "
||  Cursor Hourglass = "/hourg /hourg_m "
||  Cursor None = "/nouse /nouse_m "

-- Miscellaneous functions.

and CanId n = "C" @ itos n @ " "

and Screen = 0

and Minus x = x * (0-1)

end
