-- furn1.m
--
-- The Munich graphics model, implemented in NeWS
--
-- By Andrew Dwelly (C) 1988 ECRC gmbh Munich
-- Version 0.1 1.9.88
--
-- Tanagrams demo

#include "ps.t"
#include "munout.t"
#include "munin.t"
#include "gdc.t"
#include "tree.t"
#include "style.t"
#include "stylemenu.t"

-------------------------
-- Dialogue definition --
-------------------------

let rec Arrange = Seq [Initialise; Work]

and     Initialise =
	   Seq [OpenFixedWindow (800^500) White;
		OutlinePopCanvas 0 Background (50^50) (0^0) 0 (100^100) 4 White
		(Rect (152^400));
	        SInMs Lft Rel Background;
		SBitmap Panel (4^250) (142^142) "oak.im8";
		SDrawButton (10^160) (130^60) Panel White "Objects";
		SInMs Lft Dep Panel;
		DoOn Background (DrawGrid 0 800 25 0 500 25)]

and     Work = TreeCase [OCons 0 (SIsMs Lft Dep Panel) ControlMenu;
			 OCons 0 (SIsMs Lft Dep FurnButton) FurnMenu]

and     ControlMenu =
	   PopUpMenuAt Lft (Vert Helvetica 18) Background 2
	      ["Move" ~> MoveCard (800^500) Background;
	       "Top" ~> Obj [DoOn Background TopCanvas];
	       "Bottom" ~> Obj [DoOn Background BottomCanvas];
	       "Quit" ~> ConfirmedExit Background] 

and     FurnMenu = PopUpMenuAt Lft (LJVert TimesRoman 18) Background 3
	    ["Desk" ~> PlaceFurn Desk;
	     "Chair" ~> PlaceFurn Chair;
	     "Table" ~> PlaceFurn Table;
	     "Screen" ~> PlaceFurn Screen;
	     "BookShelf" ~> PlaceFurn Shelf]

and     ObjMenu num shp cl ((n,t),s) = 
            PopUpMenu Rht (Horiz Helvetica 18) Background (PosOf num s)
	   ["Group" ~> Obj [Do (Engroup num) NullDialogue];
	    "Degroup" ~> Obj [Do (Degroup num) NullDialogue];
	    "Rotate Rht" ~> RotRightTan num shp] cl ((n,t),s)

and PlaceFurn shape cl =
    Seq [OutlinePopCanvas 0 Background (350^50) (0^0) 0 (200^200) 8 
	 Cyan (Ngon shape);
	 SInMs Lft Dep (Child o Background); SInMs Mid Dep (Child o Background);
	 SInMs Rht Dep (Child o Background); AddFurn shape cl] 

and AddFurn shp cl ((n,ds),s) = 
    Do (StateFurn shp)
    (TreeCase ((OCons 0 (IsMs Lft Dep (n-1))(MoveTan (n-1) shp)).
    (OCons 0 (IsMs Mid Dep (n-1)) (RotLeftTan (n-1) shp)).
    (OCons 0 (IsMs Rht Dep (n-1)) (ObjMenu (n-1) shp)).cl)) ((n,ds),s)

and MoveTan tan shp cl (DS,s) = 
    Seq [RejectInput;
         SAnimate Background (AngOf tan s) (200^200) (Ghost (Ngon shp));
         WaitForRelease Background; Send (RevokeAnimate);
	 Cond (InGroup tan) (Seq [MoveGroupRelState tan; MoveGroupRel])
	      (Seq [Send (KillCanvas tan); MoveCanState tan;
		    DrawBigTan tan shp]);
	 TreeCase cl] (DS,s)

and WaitForRelease b = Cond (SIsMs Lft Rel b) NullDialogue
		       (Join RejectInput (WaitForRelease b))

and RotLeftTan tan shp = RotTan (RotLeftState tan) tan shp

and RotRightTan tan shp = RotTan (RotRightState tan) tan shp

and RotTan sf tan shp =
    Obj [Send (KillCanvas tan); Do sf (DrawBigTan tan shp)] 

and DrawBigTan tan shp ((next,ds),s) =
    let rec Pos = PosOf tan s
    in Seq [Send (OpenOutlinePopCanvas tan Pos Pos (AngOf tan s)(200^200) 8 
	    (NodeNum (Background ds)) Cyan (Ngon shp));
	    MsInterest Lft Dep tan; MsInterest Mid Dep tan;
	    MsInterest Rht Dep tan]
	    ((next,ds),s)

and MoveCanState tan (DS,s) (Ms Lft Rel c (Cart x y.crds).t) =
    let rec MvState x y (can,pos,a,shp,grp) = (can,(x^y),a,shp,grp)
    in DC [] (DS,CanMap (MvState x y) tan s) t

and MoveGroupRel (DS,s) =
    let rec MvGrp [] = NullDialogue
    ||      MvGrp ((can,pos,a,shp,grp).t) =
           if grp then Seq [Send(KillCanvas can); DrawBigTan can shp; MvGrp t]
	   else MvGrp t
    in MvGrp s (DS,s)

and MoveGroupRelState furn (DS,s) (Ms Lft Rel c (Cart x y.crds).tll) =
    let rec MvState mv [] = []
    ||      MvState mv ((can,pos,a,shp,grp).t) =
	      if grp then (can,AddVec mv pos,a,shp,grp). MvState mv t
	      else (can,pos,a,shp,grp).MvState mv t
    in DC [] (DS,MvState (SubVec (x^y) (PosOf furn s)) s) tll

and RotLeftState n (DS,s) =
    let rec RLS (can,pos,a,shp,grp) = (can,pos,a+45,shp,grp)
    in (DS,CanMap RLS n s)

and     RotRightState n (DS,s) =
	let rec RLS (can,pos,a,shp,grp) = (can,pos,a-45,shp,grp)
	in (DS,CanMap RLS n s)

--------------------
-- Cond Functions --
--------------------

and InGroup furn (DS,[]) l = false
||  InGroup furn (DS,((can,pos,a,shp,grp).t)) l = 
      if furn = can then grp else InGroup furn (DS,t) l

----------------------------------
-- State manipulation functions --
----------------------------------

and StateFurn shp ((n,ds),s) = ((n,ds),((n-1,(350^50),0,shp,false).s))

and AngOf c ((can,pos,a,shp,grp).t) = if c = can then a else AngOf c t

and PosOf c ((can,pos,a,shp,grp).t) = if c = can then pos else PosOf c t

and Substitute v (can,pos,a,shp,grp) = (can,pos,a,shp,v)

and Engroup num (DS,s) = (DS,CanMap (Substitute true) num s)

and Degroup num (DS,s) = (DS,CanMap (Substitute false) num s)

and CanMap f n [] = []
||  CanMap f n ((can,pos,a,shp,grp).t) =
       if n = can then f (can,pos,a,shp,grp) . CanMap f n t
       else (can,pos,a,shp,grp) . CanMap f n t
-------------------------
-- Graphic definitions --
-------------------------

and DrawGrid fx tx sx fy ty sy can =
    let rec SX y = LineDraw can (fx^y) (0^0) 0 (100^100) 2 Black 
		   (Rect ((tx - fx)^sy))
    and SY x     = LineDraw can (x^fy) (0^0) 0 (100^100) 2 Black
	           (Rect (sx^(ty - fy)))
    in CMap SX (FromToStep fy ty sy) @ CMap SY (FromToStep fx tx sx) 

and Background = EldestChild

and Panel = EldestChild o EldestChild

and FurnButton = EldestChild o Panel

--------------------------
-- The Furniture Shapes --
--------------------------

and Desk = [0^0; 0^25; 50^25; 50^0]

and Table = [0^0; 0^30; 70^30; 70^0]

and Shelf = [0^0; 0^12; 70^12; 70^0]

and Chair = [0^0; 0^15; 15^15; 15^0]

and Screen = [0^0; 0^5; 70^5; 70^0]


-----------------------
-- The Main Equation --
-----------------------

and     Start = []

in Dialogue Arrange (InitDS,Start) input
