-- Copyright (C) 1987, 1988 G|ran Uddeborg
--
-- This file is part of FPG.
--
-- FPG is distributed in the hope that it will be useful, but WITHOUT ANY
-- WARRANTY.  No author or distributor accepts responsibility to anyone for
-- the consequences of using it or for whether it serves any particular
-- purpose or works at all, unless he says so in writing.  Refer to the FPG
-- General Public License for full details.
--
-- Everyone is granted permission to copy, modify and redistribute FPG, but
-- only under the conditions described in the FPG General Public License.
-- A copy of this license is supposed to have been given to you along with
-- FPG so you can know your rights and responsibilities.  It should be in a
-- file named COPYING.  Among other things, the copyright notice and this
-- notice must be preserved on all copies.

module

#include "assoctype.t"
#include "assoc_sym.t"
#include "concrete.t"
#include "errortype.t"
#include "isittype.t"
#include "symtab.t"

export cvtdecl, checknont, nodecs, sympri, rulepri;

-- cvtdecl decl prev : Take a declararation "decl" and incorporate it into
--		       the previous "environment" "prev".

-- checknont nont symtab rhs : Check that all nonterminals in rhs also are in
--  	    	    	       nont.

-- mksym term sym : If symbol "sym" is in the list of terminals "term", return
--		    "Term sym" else return "Nont sym"

-- lastterm syms : Find the last terminal in a list of symbols.

-- nodecs : A tuple representing no declarations done.

    rcsid = " $Header: /usr/src/local/lml/contrib/fpg/RCS/syntaxfuncs.m,v 1.1 88/04/19 17:05:15 pelle Exp $"
and
    cvtdecl (Function f) (t,s,i,r,f',p,e) =
    	t,s,i,r,Is f,p,if f' = Isn't then e else MultipleFunction.e
||  cvtdecl (Include is) (t,s,i,r,f,p,e) = t,s,is@i,r,f,p,e
||  cvtdecl (Leftassoc ids) (t,s,i,r,f,(p,pno),e) =
    	t,s,i,r,f,(map (\id.id,Pri Left pno) ids@p,pno+1),e
||  cvtdecl (Nonassoc ids) (t,s,i,r,f,(p,pno),e) =
    	t,s,i,r,f,(map (\id.id,Pri None pno) ids@p,pno+1),e
||  cvtdecl (Return r) (t,s,i,r',f,p,e) =
	t,s,i,Is r,f,p,if r' = Isn't then e else MultipleReturn.e
||  cvtdecl (Rightassoc ids) (t,s,i,r,f,(p,pno),e) =
    	t,s,i,r,f,(map (\id.id,Pri Right pno) ids@p,pno+1),e
||  cvtdecl (Start s) (t,s',i,r,f,p,e) =
    	t,Is s,i,r,f,p,if s' = Isn't then e else MultipleStart.e
||  cvtdecl (Tokens ts) (t,s,i,r,f,p,e) = ts@t,s,i,r,f,p,e
and
    checknont nonts terms symtab =
    	(map (UndefinedSymbol o lookup symtab) o mkset o filter notdef
    	where
	    notdef sym = ~ mem sym (nonts@terms))
and
    nodecs = [],Isn't,[],Isn't,Isn't,([],0),[]
and rec
    sympri pri sym = assocdef_sym sym pri NoPri
and
    rulepri terms pri syms =
	case filter (\s.mem s terms) syms in
	    []: NoPri
	||  (l as $.$): sympri pri (last l)
	end

end
