-- Copyright (C) 1987, 1988 G|ran Uddeborg
--
-- This file is part of FPG.
--
-- FPG is distributed in the hope that it will be useful, but WITHOUT ANY
-- WARRANTY.  No author or distributor accepts responsibility to anyone for
-- the consequences of using it or for whether it serves any particular
-- purpose or works at all, unless he says so in writing.  Refer to the FPG
-- General Public License for full details.
--
-- Everyone is granted permission to copy, modify and redistribute FPG, but
-- only under the conditions described in the FPG General Public License.
-- A copy of this license is supposed to have been given to you along with
-- FPG so you can know your rights and responsibilities.  It should be in a
-- file named COPYING.  Among other things, the copyright notice and this
-- notice must be preserved on all copies.

module

#include "actions.t"
#include "assoc_sym.t"
#include "progtype.t"

export statecode;

-- statecode g n actlist : generate code (text) for a single state
--  	g   	    	 : the grammar
--  	actlist	    	 : a state consisting of
--  	    n  	    	 : the number of this state
--  	    symbol     	 : the symbol when this actions is to be used
--  	    action       : the action, Reduce or Shift, to do when the
 --		    	   the symbol is seen

    rcsid = " $Header: /usr/src/local/lml/contrib/fpg/RCS/statecode.m,v 1.1 88/04/19 17:05:13 pelle Exp $"
and
    statecode (prods,$,$,$,endid,fun,lookup,$,sattr,$,$) (n,nontact,termact)=
    	Local
    	    (Rec
	    	(Funb
	    	    (
	  	    App [Aexp "goto"; Aexp "sym"; Aexp "S"; Aexp "tail"],
		    Case
		    	(Aexp "sym")
		    	(map (actcode false) nontact @
		    	    [Aexp "$", Aexp (fun "bottom")])
		    )))
	    (Funb
	    	(
	    	App [Aexp (fun ('s'.itos n)); Aexp "S"; Aexp "I"],
	    	Case
	    	    (Aexp "I")
		    (map (actcode true) termact @
		    	[Aexp "$", App [Aexp "No"; Aexp "I"]])
	    	))
    	where
    	    actcode term (s, Shift nnew) =
	    	(let
    	    	    inp =
		    	if null (assoc_sym s sattr)
    	    	    	    then [Aexp (fun "C" @ lookup s)]
    	    	    	    else [Aexp (fun "C" @ lookup s); Aexp "$"]
	    	in
		    if term
		    	then
		    	    App [Aexp "(.)";
			    	App ([Aexp "sym"; Aexp "as"] @ inp);
			    	Aexp "tail"]
		    	else App inp),
	    	App
		    [
		    Aexp (fun ('s'.itos nnew));
		    App
		    	([Aexp (fun "Stack")] @
	    	    	(let
		    	    inp = Aexp "sym"
	    	    	in
			    if term
			    	then [Aexp (fun "bottom"); inp]
			    	else [inp; Aexp (fun "bottom")]) @
		        [Aexp "goto"; Aexp "S"]);
		    Aexp "tail"
		    ]
    	||  actcode $ (s, Reduce n) =
    	    	(if s = endid
	    	    then
		    	Aexp "[]"
		    else
		    	App [
		    	    Aexp "(.)";
		    	    if null (assoc_sym s sattr)
    	    	    	    	then Aexp (fun "C" @ lookup s)
    	    	    	    	else App [Aexp (fun "C" @ lookup s); Aexp "$"];
			    Aexp "$"]),
	    	App 
		    (Aexp (fun ('r'.itos n)).
		    (if nullprod n then [Aexp "goto"] else []
		    where
		    	nullprod pno =
			    let
			    	$,rhs,$,$,$ =
				    hd (filter (\ ($,$,$,$,n).n=pno) prods)
			    in
			    	null rhs) @
		    [Aexp "S"; Aexp "I"])

end
