-- Copyright (C) 1987 G|ran Uddeborg
--
-- This file is part of FPG.
--
-- FPG is distributed in the hope that it will be useful, but WITHOUT ANY
-- WARRANTY.  No author or distributor accepts responsibility to anyone for
-- the consequences of using it or for whether it serves any particular
-- purpose or works at all, unless he says so in writing.  Refer to the FPG
-- General Public License for full details.
--
-- Everyone is granted permission to copy, modify and redistribute FPG, but
-- only under the conditions described in the FPG General Public License.
-- A copy of this license is supposed to have been given to you along with
-- FPG so you can know your rights and responsibilities.  It should be in a
-- file named COPYING.  Among other things, the copyright notice and this
-- notice must be preserved on all copies.

module

export scc;

--  scc	G : Find strongly connected components of a graph.
--	G : The graph is represented as a list of nodes, each
--	    node is a pair; the node name and an adjecency list
--	    consisting of node names.  It returns a list of
--	    strongly connected components.

rec
    searchc G n low (vv as (v,es)) =
	let n = n+1
	in let low = (v,n).low
	in let
	    (n,low,nstack,min),cs = mapstate f (n,low,[vv],n) es
    	    where
	    	f (n,low,stack,min) w =
    	    	    let (n,low,stack',m),cs =
	    	    	let vm = assocdef w low 0
			in  if vm = 0
		    	    	then searchc G n low (w, assoc w G)
				else (n,low,[],vm),[]
	    	    in
	    	    	(n,low,stack'@stack,if m<min then m else min), cs
	in let cs = conc cs
	in  if assoc v low = min
	    	then (n,map (\(x,$). x,maxint) nstack @ low,[],min),cs@[nstack]
	    	else (n,low,nstack,min), cs
and
    scc G =
	let low, cs = mapstate g [] G
	    where g low (vv as v, $) =
		if assocdef v low 0 = 0
		    then
		    	let (n,low,stack,min), cs = searchc G 1 low vv
			in  low, cs
		    else
			low, []
	in  conc cs

end
