-- Copyright (C) 1987 G|ran Uddeborg
--
-- This file is part of FPG.
--
-- FPG is distributed in the hope that it will be useful, but WITHOUT ANY
-- WARRANTY.  No author or distributor accepts responsibility to anyone for
-- the consequences of using it or for whether it serves any particular
-- purpose or works at all, unless he says so in writing.  Refer to the FPG
-- General Public License for full details.
--
-- Everyone is granted permission to copy, modify and redistribute FPG, but
-- only under the conditions described in the FPG General Public License.
-- A copy of this license is supposed to have been given to you along with
-- FPG so you can know your rights and responsibilities.  It should be in a
-- file named COPYING.  Among other things, the copyright notice and this
-- notice must be preserved on all copies.

module

#include "conflicttype.t"
#include "errortype.t"

export printerror, printwarning;

-- printerror error : Return a readable string describing an error.

-- printwarning warn : Return a readable string about conflicts in the grammar.

    rcsid = " $Header: /usr/src/local/lml/contrib/fpg/RCS/printerror.m,v 1.1 88/04/19 17:05:09 pelle Exp $"
and
    printerror error = "Error: " @ (prerr error @ "\n" where
    	    prerr (ExpectedChar c l) = "expected '" @ c . "' at \"" @ l @ "\""
    	||  prerr (ExpectedName p) = "expected name at \"" @ p @ "\""
    	||  prerr (ExpectedNumber p) = "expected name at \"" @ p @ "\""
	||  prerr (MalformedDefinition d) =
		"malformed definition \"" @ d @ "\" (no `=' sign)"
    	||  prerr (MissingAttribute pno sno att) =
    	    	"attribute \"$" @ itos sno @ '.'.att @
		"\" undefined in rule " @ itos pno
    	||  prerr MissingFFSuffix = "file name doesn't end in \".ff\""
    	||  prerr MissingFile = "missing file name"
    	||  prerr MissingFunction = "no %function definition"
    	||  prerr MissingReturn = "no %return definition"
    	||  prerr MissingStart = "no %start definition"
	||  prerr MissingStartProduction = "no production for the start symbol"
    	||  prerr MultipleFile = "multiple file names"
    	||  prerr MultipleFunction = "multiple %function definitions"
    	||  prerr MultipleReturn = "multiple %return definitions"
    	||  prerr MultipleStart = "multiple %start definitions"
    	||  prerr (MultipleTermIAttr (sym,attrl)) =
    	    	"multiple inherited attributes of terminal \"" @ sym @ "\":" @
	    	mix (map ((" \"" @) o (@ "\"")) attrl) " and"
    	||  prerr (MultipleTermSAttr (sym,attrl)) =
    	    	"multiple synthesized attributes of terminal \"" @ sym @
		"\":" @ mix (map ((" \"" @) o (@ "\"")) attrl) " and"
    	||  prerr (MultiplyTokenDeclared id) =
    	    	"\"" @ id @ "\" multiply declared as %token"
	||  prerr (StartIAttr attr) =
		"\"" @ attr @ "\" inherited attribute of start symbol"
    	||  prerr (TooHighNumber n p) =
    	    	"number " @ itos n @ " at \"" @ p @ "\" too high"
    	||  prerr (TooManyFlags c) = "too many '" @ c . "'-flags"
	||  prerr (UndefinedSymbol s) = "nonterminal " @ s @ " never defined"
    	||  prerr (UnknownFlag c) = "unknown flag: '" @ c . "'")
and
    printwarning warn =
    	"conflicts: " @
    	(if shre > 0 then itos shre @ " shift/reduce" else "") @
	(if shre > 0 & rere > 0 then ", " else "") @
	(if rere > 0 then itos rere @ " reduce/reduce" else "") @
	"\n"
	where
	    shre,rere = reduce cnt (0,0) warn
	    where
	    	cnt (ShiftReduce $ $ $) (shre,rere) = shre+1, rere
	    ||	cnt (ReduceReduce $ $ $) (shre,rere) = shre, rere+1

end
