-- Copyright (C) 1987 G|ran Uddeborg
--
-- This file is part of FPG.
--
-- FPG is distributed in the hope that it will be useful, but WITHOUT ANY
-- WARRANTY.  No author or distributor accepts responsibility to anyone for
-- the consequences of using it or for whether it serves any particular
-- purpose or works at all, unless he says so in writing.  Refer to the FPG
-- General Public License for full details.
--
-- Everyone is granted permission to copy, modify and redistribute FPG, but
-- only under the conditions described in the FPG General Public License.
-- A copy of this license is supposed to have been given to you along with
-- FPG so you can know your rights and responsibilities.  It should be in a
-- file named COPYING.  Among other things, the copyright notice and this
-- notice must be preserved on all copies.

module

#include <OK>
#include "attrtype.t"
#include "errortype.t"

export parseattr;

-- parseattr : Parse an attribute describing string.
--    string : The string to parse
--    isterm : A function telling if symbol "n" is a terminal.
--       len : Total number of symbols on the righthandside of the production.

    rcsid = " $Header: /usr/src/local/lml/contrib/fpg/RCS/lexfuncs.m,v 1.1 88/04/19 17:05:07 pelle Exp $"
and
    parseattr string len = (lhs,rhs), string, l_errs@r_errs@isdef_err
        where rec
	    lhs,l_errs = parse pat
        and
            rhs,r_errs = parse exp
        and
	    isdef_err = if null exp then [MalformedDefinition string] else []
        and
	    pat,exp = splitat '=' string
        and
	    rec parse "" = [],[]
	    ||  parse ('$'.tail) =
		    (case getattr tail in
		        Yes att,tl :
			    (att.attrs, errs where attrs,errs = parse tl)
		    ||  No err,tl :
			    attrs, err.errs where attrs,errs = parse tl
		    end
	    	    where
	    	        getattr "" = No (ExpectedNumber ""), ""
	    	    ||  getattr (s as n.$) =
	    	    	    if ~ isdigit n then No (ExpectedNumber s), s
	    	    	    else let n,tl = takeword s in let num = stoi n in
			    if num > len then No (TooHighNumber num s), tl
			    else if null tl then No (ExpectedChar '.' tl), tl
			    else let dot.tl2 = tl in
			    if dot ~= '.' then No (ExpectedChar '.' tl), tl
			    else let a,tl3 = takeword tl2 in
			    if null a | ~ isalpha (hd a) then
			        No (ExpectedName tl2), tl2
			    else Yes (Attribute num a), tl3)
    	    ||  parse str /* hd str ~= '$' */ =
	    	    (let txt,tl = gettxt str in
		    let attrs,errs = parse tl in
		    Text txt . attrs, errs)
		    where rec
		        gettxt "" = "",[]
		    ||  gettxt ('\\'.x.tail) =
			    (x.txt,tl where txt,tl=gettxt tail)
		    ||  gettxt (str as '$'.$) = "",str
		    ||  gettxt (x.tail) = x.txt,tl where txt,tl = gettxt tail

end
