-- Copyright (C) 1987, 1988 G|ran Uddeborg
--
-- This file is part of FPG.
--
-- FPG is distributed in the hope that it will be useful, but WITHOUT ANY
-- WARRANTY.  No author or distributor accepts responsibility to anyone for
-- the consequences of using it or for whether it serves any particular
-- purpose or works at all, unless he says so in writing.  Refer to the FPG
-- General Public License for full details.
--
-- Everyone is granted permission to copy, modify and redistribute FPG, but
-- only under the conditions described in the FPG General Public License.
-- A copy of this license is supposed to have been given to you along with
-- FPG so you can know your rights and responsibilities.  It should be in a
-- file named COPYING.  Among other things, the copyright notice and this
-- notice must be preserved on all copies.

module

#include "assoc_sym.t"
#include "isittype.t"
#include "itemsetfuncs.t"		
#include "mergestate.t"
#include "next.t"

export itemset;

-- itemset grammar : Create itemsets, sets of marked productions.
--		   : A list of fourtuples is returned, where the first
--		   : component is the list of marked productions, the
--		   : second this itemset's number, the third and
--		   : fourth shift actions for nonterminals and
--		   : terminals respectively.
--  	   grammar : The grammar for which the itemsets are computed.

    rcsid = " $Header: /usr/src/local/lml/contrib/fpg/RCS/itemset.m,v 1.1 88/04/19 17:05:04 pelle Exp $"
and
    itemset (grammar as prods,terminals,nonterms,$,endid,$,$,$,$,$,$) =
        let
	    next = nextfunc grammar
	and
	    lhs,rhs,$,$,num = hd prods
	in let
	    [endid,(nucl0,rhs0)],[] =
		next ([num,2],[NSlisttoset [endid]]) [endid.rhs]
        in (let rec
	    ($,nontstates,termstates),acts = nits startstates nucl0 rhs0
	    where startstates = 1, map (,[]) nonterms, map (,[]) terminals
        in
	    (nucl0,0,acts) . concmap snd nontstates @ concmap snd termstates)
        where rec
	    nits states fromstate fromrhs =
	        (((newstates,(nontacts,termacts,redact)
	        where rec
		    newstates,termacts =
			reduce (checkgoto true) (ns,[]) terminals
	        and
		    ns,nontacts =
			reduce (checkgoto false) (states,[]) nonterms)
	        where
	            checkgoto
		        isterminal
		        sym
		        (sofar as
			    (states as nextnum,nontstates,termstates),acts)
			    =
		        let nucleus,rhs =
				assocdef_sym sym nextstates (([],[]),[])
		        in  if rhs = [] then sofar
			    else
				case find sym isterminal states nucleus in
				    Is st : states,((sym,st).acts)
			        ||  Isn't : nstates,((sym,nst).acts)
			        end
			        where rec
				    nstates,newacts =
					nits statesplus nucleus rhs
				and
				    nst,statesplus =
					insert
					    sym
					    isterminal
					    nucleus
					    newacts
					    states)
		where
		    nextstates,redact = next fromstate fromrhs)
        and
	    insert
		sym
		isterminal
		(nucleus as core,context)
		(act as nact,tact,redact)
		(num,nontstates,termstates)
		    =
		let
		    slist = if isterminal then termstates else nontstates
		and rec
		    trymerge [] = num,num+1,[nucleus,num,act]
		||  trymerge
			((hd as (nucleus' as $,context'),n,($,$,redact')).tl) =
			if compatible nucleus nucleus'
			    then
				let
				    newcontext = map2 NSunion context context'
				and
				    newact = nact,tact,mergered redact redact'
				in
				    n, num, ((core,newcontext),n,newact).tl
			    else
				let
				    num,nextnum,newtl = trymerge tl
				in
				    num,nextnum,hd.newtl
		in let
		    num,nextnum,newlist = trymerge (assoc_sym sym slist)
		in
		    num,
		    if isterminal
			then
			    nextnum,
			    nontstates,
			    ((sym,newlist).filter ((sym ~=) o fst) slist)
			else
			    nextnum,
			    ((sym,newlist).filter ((sym ~=) o fst) slist),
			    termstates

end
