-- Copyright (C) 1987, 1988 G|ran Uddeborg
--
-- This file is part of FPG.
--
-- FPG is distributed in the hope that it will be useful, but WITHOUT ANY
-- WARRANTY.  No author or distributor accepts responsibility to anyone for
-- the consequences of using it or for whether it serves any particular
-- purpose or works at all, unless he says so in writing.  Refer to the FPG
-- General Public License for full details.
--
-- Everyone is granted permission to copy, modify and redistribute FPG, but
-- only under the conditions described in the FPG General Public License.
-- A copy of this license is supposed to have been given to you along with
-- FPG so you can know your rights and responsibilities.  It should be in a
-- file named COPYING.  Among other things, the copyright notice and this
-- notice must be preserved on all copies.

module

#include "assoc_sym.t"

export firstf;

-- firstf grammar
--	A function that, given a grammar, gives two new function.  The
--	first of these functions takes a list of symbols, and returns
--	the possible first terminal symbols in the strings derivable
--	from this list.  The second takes a list of symbols and
--	returns an indication whether the empty string can be derived
--	from it.

    rcsid = " $Header: /usr/src/local/lml/contrib/fpg/RCS/first.m,v 1.1 88/04/19 17:04:55 pelle Exp $"
and
    firstf (grammar as prod,term,nont,$,$,$,$,$,$,$,$) =
	let
	    prodl =
		((map extract o group eq o sort less) prod
		    where
			less (nt1,$,$,$,$) (nt2,$,$,$,$) = nt1 < nt2
		    and
			eq (nt1,$,$,$,$) (nt2,$,$,$,$) = nt1 = nt2
		    and
			extract (l as (nt,$,$,$,$).$) =
			    nt, map (\($,m,$,$,$).m) l)
	in let
	    (rec fixpt (s1.(t as s2.$)) = if s1 = s2 then s1 else fixpt t)
	and
	    rec nullap =
		[] . map step nullap
		where
		    step appr = filter nullsymb nont
		    where
			nullsymb nont =
			    mem nont appr |
			    Or (map
				    (And o map (\s.mem s appr))
				    (assoc_sym nont prodl))
	in let
-- TEMP FIX	    nullable s = NSmem s (NSlisttoset (fixpt nullap))
	    X = NSlisttoset (fixpt nullap)	-- TEMP FIX
	in let					-- TEMP FIX
	    nullable s = NSmem s (snd (X,X))	-- TEMP FIX
	in let
	    leads = mapsnd leadsymb prodl
	    where
		leadsymb sll =
		    reduce NSunion NSempty (map (reduce leadlist NSempty) sll)
		    where
			leadlist sym rest =
			    if nullable sym
				then NSadd sym rest
				else NSlisttoset [sym]
	in let
	    dependents = mapsnd (NSintsect (NSlisttoset nont)) leads
	and
	    approximation = mapsnd (NSintsect (NSlisttoset term)) leads
	in let
	    firstof symbfirst symb follow =
		let this = assoc_sym symb symbfirst
		in  if nullable symb then NSunion this follow else this
	and
	    termfirst = map (\t.t,NSlisttoset [t]) term
	and rec
	    firstap =
		approximation . map step firstap
		where
		    step app = map symbstep app
		    where
			symbstep (nont,thisapp) =
			    nont,
			    reduce
				NSunion
				thisapp
				(map
				    (\dpd.assoc_sym dpd app)
				    (NSsettolist (assoc_sym nont dependents)))
	in let					-- TEMP FIX
	    Y = termfirst @ fixpt firstap	-- TEMP FIX
	in
-- TEMP FIX	    reduce (firstof (termfirst @ fixpt firstap)) NSempty,
	    reduce (firstof (snd (Y,Y))) NSempty,	-- TEMP FIX
	    And o map nullable

end
