\begin{caml_primitive}
sys_ratio_of_string : int * string * int * int -> ratio
ratio_of_string : string -> ratio
\end{caml_primitive}
\conceptindex{coercion between types \verb"string" and \verb"ratio"}

CAML is able to read numbers of type \verb"ratio" entered directly, according 
to the following lexical convention:

\begin{small}
\begin{verbatim}
Separator ::= ' ' | '\f' | '\n' | |\r' | '\t' | '\\'
Pseudodigit ::= Digit | Separator
Decimal ::= {'-'| '+'} Separator* Digit Pseudodigit* 
            {'.' Separator* Digit Pseudodigit*} {'e' {'-' | '+'} INT}
RATIO ::= '#[' Decimal {'/' Decimal} ']'
\end{verbatim}
\end{small}

\exple
\begin{small}
\begin{verbatim}
##[12];;
#[12/1] : ratio

##[12.0];;
#[12/1] : ratio

##[1.2e1];;
#[12/1] : ratio

##[120e-1];;
#[12/1] : ratio

##[12/1];;
#[12/1] : ratio

##[60/5];;
#[12/1] : ratio

##[1.2/1e-1];;
#[12/1] : ratio

##[120/10];;
#[12/1] : ratio
\end{verbatim}
\end{small}

\verb"sys_ratio_of_string (base, s, off, len)" maps the substring 
$s_{off, len}$ in base \verb"base" onto a element of type \verb"ratio".

\verb"ratio_of_string s" is equivalent to:
\begin{small}
\begin{verbatim}
let ratio_of_string s = 
  sys_ratio_of_string (#10, s, #0, length_string s)
;;
\end{verbatim}
\end{small}

\exple
\begin{small}
\begin{verbatim}
#sys_ratio_of_string (#16, "FF", #0, #2);;
#[255/1] : ratio

#ratio_of_string "1.2e3/5e1";;
#[24/1] : ratio
\end{verbatim}
\end{small}
