\begin{caml_primitive}
sqrt_nat : nat * int * int -> nat
power_base_int : int * int -> nat
power_base_nat : int * nat * int * int -> nat
\end{caml_primitive}
\verb"sqrt_nat (nat, off, len)" computes the integer part of the square root 
of subnat $nat_{off, len}$.

\verb"power_base_int (i, p)" computes $i^p$, where $p$ is a positive
\verb"int", and the resulting value is exact and a natural number.

\verb"power_base_nat (base, nat, off, len)" computes \verb"base" to 
$nat_{off, len}$ power.

\exple
\begin{small}
\begin{verbatim}
#let nat = nat_of_int #1729;;
Value nat is #<1729> : nat

#sqrt_nat (nat, #0, #1);;
#<41> : nat

#power_base_int (#10, #24);;
#<1000000000000000000000000> : nat

#power_base_nat (#10, nat_of_int #24, #0, #1);;
#<2003764205206896640> : nat
\end{verbatim}
\end{small}
