\begin{caml_primitive}
eq_big_int : big_int * big_int -> bool
compare_big_int : big_int * big_int -> int
lt_big_int : big_int * big_int -> bool
le_big_int : big_int * big_int -> bool
gt_big_int : big_int * big_int -> bool
ge_big_int : big_int * big_int -> bool
sign_big_int : big_int -> int
abs_big_int : big_int -> big_int
max_big_int : big_int * big_int -> big_int
min_big_int : big_int * big_int -> big_int
zero_big_int : big_int
\end{caml_primitive}
\conceptindex{\verb"<="}
\conceptindex{\verb"="}
\conceptindex{\verb">="}
\conceptindex{\verb"<"}
\conceptindex{\verb">"}
\conceptindex{\verb"max"}
\conceptindex{\verb"min"}
\conceptindex{\verb"abs"}
\conceptindex{\verb"monster_int"}

\verb"eq_big_int", \verb"lt_big_int", \verb"le_big_int", \verb"gt_big_int", 
\verb"ge_big_int" are arithmetic comparisons corresponding respectively to 
\verb"=", \verb"<", \verb"<=", \verb">", \verb">=".

The primitive function for these functions is \verb"compare_big_int", that is 
semantically equivalent to:
\begin{small}
\begin{verbatim}
let compare_big_int (bigint1, bigint2) =
 when (bigint1 = bigint2) -> #0
    | (bigint1 < bigint2) -> #-1
    |          _          -> #1;;
\end{verbatim}
\end{small}

\verb"sign_big_int" is completely equivalent to:
\begin{small}
\begin{verbatim}
let sign_big_int bi = bi.Sign
;;
\end{verbatim}
\end{small}

\verb"abs_big_int bi" is the absolute value of the \verb"big_int" \verb"bi". 

\verb"max_big_int (bi1, bi2)" and \verb"min_big_int (bi1, bi2)" are
respectively the greater and the smaller of the \verb"big_int"s
\verb"bi1" and \verb"bi2".

\verb"zero_big_int" is the null \verb"big_int".

\exple
\begin{small}
\begin{verbatim}
#eq_big_int (succ_big_int (big_int_of_int biggest_int),
#            big_int_of_int monster_int);;
false : bool

#gt_big_int (succ_big_int (big_int_of_int biggest_int),
#            big_int_of_int biggest_int);;
true : bool

#sign_big_int (succ_big_int (big_int_of_int biggest_int));;
1 : int

#sign_big_int (big_int_of_int monster_int);;
-1 : int

#abs_big_int (big_int_of_int monster_int);;
#(32768) : big_int
\end{verbatim}
\end{small}
