\conceptindex{coercion between types \verb"int" and \verb"float"}
\begin{caml_primitive}
int_of_float : float -> int
float_of_int : int -> float
\end{caml_primitive}
\conceptindex{float}

\verb"int_of_float f" is the truncation of \verb"f" to a number of
type \protect\verb"int", closest to its floating point representation. 

\exple
\begin{small}
\begin{verbatim}
#int_of_float #1.2;;
1 : int

#int_of_float #1.0;;
1 : int

#int_of_float #0.9999999;;
0 : int

#int_of_float #0.99999999;;
1 : int
\end{verbatim}
\end{small}
 
\verb"float_of_int i" is the floating representation of the number of
type \protect\verb"int" \verb"i".

\exple
\begin{small}
\begin{verbatim}
#float_of_int #0;;
0.0 : float

#float_of_int #1;;
1.0 : float

#float_of_int #-1;;
-1.0 : float
\end{verbatim}
\end{small}
