\begin{caml_primitive}
nat_of_num : num -> nat
num_of_nat : nat -> num
\end{caml_primitive}
\conceptindex{coercion between types \verb"nat" and \verb"num"}

\verb"nat_of_num n" maps rational number \verb"n" onto the corresponding 
\verb"nat" if \verb"n" is an integer and positive.

\verb"num_of_nat" maps a \verb"nat" onto the corresponding rational number.

\exple
\begin{small}
\begin{verbatim}
#nat_of_num #{1.2e3};;
#<1200> : nat

#nat_of_num #{-1.2e3};;

Evaluation Failed: failure "nat_of_int"

#nat_of_num #{1.2};;

Evaluation Failed: failure "nat_of_ratio"

#nat_of_num #{1/2};;

Evaluation Failed: failure "nat_of_ratio"
\end{verbatim}
\end{small}
