\begin{caml_primitive}
big_int_of_nat : nat -> big_int
nat_of_big_int : big_int -> nat
\end{caml_primitive}

\verb"big_int_of_nat" maps naturally a \verb"nat" onto the
corresponding \verb"big_int". 

\verb"nat_of_big_int bi" maps \verb"big_int" \verb"bi"
onto the corresponding \verb"nat" if \verb"bi" is positive.

\verb"is_big_int_nat" can be written as :
\begin{small}
\begin{verbatim}
#let is_big_int_nat bi = ge_int (sign_big_int bi, #0);;
Value is_big_int_nat is <fun> : big_int -> bool
\end{verbatim}
\end{small}

\exple
\begin{small}
\begin{verbatim}
#big_int_of_nat (nat_of_string "123456789");;
#(123456789) : big_int

#nat_of_big_int #(1.2e3);;
#<1200> : nat

#nat_of_big_int #(-1.2e3);;

Evaluation Failed: failure "nat_of_big_int"

#is_big_int_nat #(1.2e3);;
true : bool

#is_big_int_nat #(-1.2e3);;
false : bool
\end{verbatim}
\end{small}
