(* $Id: top_gram.ml,v 1.5 91/07/06 20:16:06 weis Exp $ *)
(*************************************************************************)
(*                                                                       *)
(*                     Projet      Formel                                *)
(*                                                                       *)
(*                            CAML                                       *)
(*                                                                       *)
(*************************************************************************)
(*                                                                       *)
(*                            Inria                                      *)
(*                      Domaine de Voluceau                              *)
(*                      78150  Rocquencourt                              *)
(*                            France                                     *)
(*                                                                       *)
(*************************************************************************)

(* top_gram The grammar of the CAML toplevel                             *)
(*          Michel Mauny                                                *)

(*          (Last edit date : Thu Oct 19 10:03:12 1989)                 *)

system module Top_gram;;

#standard arith true;;
#fast arith true;;

(*
   Warning: the parser of this grammar must be able to decide which rule to
   reduce by consulting only the first token!
*)

grammar for values Top = 
rule entry top = 
    parse EOF _ -> (raise io_failure "eof")
        | top_caml t -> t
        
and top_caml = 
    parse Literal "#" -> parse_directive ()
        | Literal "#+" -> parse_plus_dir ()
        | Literal "#-" -> parse_minus_dir ()
        | Literal "module" -> parse_import ()
        | Literal "end" -> parse_export ()
        | Literal "system" -> parse_system_import ()
        | Literal "autoload" -> parse_autoload ()
        | Literal "grammar" -> parse_grammar_decl ()
        | Literal "printer" -> parse_printer_decl ()
        | Literal "forward" -> parse_forward_decl ()
        | Literal "overload" -> parse_overload_decl ()
        | INT n -> (lex_reread_token (mlint n);parse_caml ())
        | FLOAT n -> (lex_reread_token (mlfloat n);parse_caml ())
        | NUM n -> (lex_reread_token (mlnum n);parse_caml ())
        | RATIO n -> (lex_reread_token (mlratio n);parse_caml ())
        | BIGINT n -> (lex_reread_token (mlbig_int n);parse_caml ())
        | -> (lex_reread_last_token ();parse_caml ())
        
;;

let parse_gen parse_top () =
 match sys_eval_syntax (parse_top ()) with
    (dynamic (s:MLsyntax)) -> s | _ -> system_error "Ill built syntax";;

let parse_gen_arg parse_top arg =
 match sys_eval_syntax (parse_top arg) with
    (dynamic (s:MLsyntax)) -> s | _ -> system_error "Ill built syntax";;

let parse_caml_syntax = parse_gen (Top "top").Parse
and parse_raw_caml_syntax = parse_gen (Top "top").Parse_raw;;

let parse_string = parse_gen_arg (Top "top").Parse_string
and parse_caml_syntax_in_channel =
 parse_gen_arg (Top "top").Parse_channel;;

end module with
 value parse_caml_syntax
 and parse_string
 and parse_caml_syntax_in_channel
 and parse_raw_caml_syntax;;
