(*************************************************************************)
(*                                                                       *)
(*                     Projet      Formel                                *)
(*                                                                       *)
(*                            CAML                                       *)
(*                                                                       *)
(*************************************************************************)
(*                                                                       *)
(*                            Inria                                      *)
(*                      Domaine de Voluceau                              *)
(*                      78150  Rocquencourt                              *)
(*                            France                                     *)
(*                                                                       *)
(*************************************************************************)

(* printf.ml	Formatting with printf                                   *)
(*		Xavier Leroy                                             *)

system module printf;;

#standard arith true;;
#fast arith true;;

let make_printf_statement (form, expr_list) =
  let current_exprs = ref expr_list in
  let get_expr () =
    match !current_exprs with
      e::rest -> current_exprs := rest; e
    |    _    -> failwith "printf grammar: not enough arguments" in
  let rec string_state (start, (i:int)) =
    if i >= string_length form then <:CAML:Expr<
      display_string
        #(MLconst(mlstring(sub_string form start (i - start)))) >>
    else match nth_char(i, form) with
      `%` -> if i > start then <:CAML:Expr<
               display_string
                 #(MLconst(mlstring(sub_string form start (i - start))));
               #(command_state (i+1)) >>
             else command_state (i+1)
     | x  -> string_state (start, i+1)
  and command_state i =
    if i >= string_length form
       then failwith "printf grammar: bad format" else
    let print_command =
      match nth_char(i, form) with
        `%` -> <:CAML:Expr< display_char `%` >>
      | `d` -> <:CAML:Expr< display_int #(get_expr ()) >>
      | `n` -> <:CAML:Expr< display_num #(get_expr ()) >>
      | `s` -> <:CAML:Expr< display_string #(get_expr ()) >>
      | `f` -> <:CAML:Expr< display_float #(get_expr ()) >>
      | `c` -> <:CAML:Expr< display_char #(get_expr ()) >>
      | `x` -> <:CAML:Expr< display_int_hexa #(get_expr ()) >>
      |  x  -> failwith ("printf grammar: `%" ^ string_of_char x ^
                         "' unimplemented") in
    if i+1 >= string_length form
    then print_command
    else <:CAML:Expr< #print_command; #(string_state (i+1, i+1)) >>
  in
    let result = string_state(0,0) in
      match !current_exprs with
        [] -> result
      | l  -> failwith ("printf grammar: " ^ string_of_int(length l) ^
                        " unused argument(s)")
;;

grammar for values printf =
  rule entry main =
    parse aux a accept a
  and aux =
    parse STRING s; ( * (parse ","; Caml_expr0 e -> e)) elist ->
      make_printf_statement (s, elist)
  and Caml_expr0 =
    parse {parse_caml_expr0 ()} e -> e
;;

let string_of_int_hexa n =
  let s = raw_make_string 4 ` ` in
  let rec fill_string (nbr, idx) =
    let digit = land(nbr, 15)
    and rest  = land(lshift(nbr, -4), 4095) in (* pas de pb. de signe! *)
      set_nth_char(idx, s, char_of_int(if digit < 10 then 48 + digit
                                                     else 87 + digit));
      if rest == 0 then idx else fill_string(rest, idx-1) in
  sub_string s (fill_string(n, 3)) 4
;;

let display_int_hexa i = display_string (string_of_int_hexa i);;

let parse_printf = (printf "main").Parse_raw;;

end module with value parse_printf and string_of_int_hexa and display_int_hexa
;;

export_from_sys_to_usr
 <:Caml:Export_list<value string_of_int_hexa and display_int_hexa>>;;
