(* $Id: makefile.ml,v 8.1 91/06/20 14:49:29 ddr Exp $
 *
 * Makefile de "rt" (test)
 *
 * $Log:	makefile.ml,v $
 * Revision 8.1  91/06/20  14:49:29  ddr
 * - distrib
 * 
 * Revision 7.8  91/06/07  20:14:46  ddr
 * - redistrib
 * 
 * Revision 7.7  91/06/04  17:19:06  ddr
 * - sauvegarde version intermediaire
 * 
 * Revision 7.6  91/05/31  17:20:24  ddr
 * - sauvegarde version
 * 
 * Revision 7.5  91/05/30  17:34:47  ddr
 * - attribut filler
 * 
 * Revision 7.4  91/05/22  19:48:00  ddr
 * - sauvegarde version intermediaire qui marche
 * 
 * Revision 7.3  91/05/21  20:46:04  ddr
 * - sauvegarde version qui marche
 * 
 * Revision 7.2  91/05/21  18:42:27  ddr
 * - sauvegarde avant changement sur attr
 * 
 * Revision 7.1  91/05/11  14:28:57  ddr
 * - distrib
 *)

let rt_sdir = "../X/"
and rt_odir = "../X/"
and pr_sdir = "../X/"
and pr_odir = "../X/"
and do_loadc d f =
  display_string "--- loadc "; display_string d; display_string f;
  display_newline();
  if !doit then (loadc (d^f); record_loaded f);
  ()
and do_loads d f =
  display_string "--- loads "; display_string d; display_string f;
  display_newline();
  if !doit then (loads (d^f); record_loaded f);
  ()
and do_compil sd od f =
  let comp, end_comm =
    if caml_version = "V2-6.1" then "compil", "" else "compilf", ";;"
  in
  make_actions [
(*
    "comline \"touch " ^ od ^ f ^ ".lo\"" ^ end_comm
*)
    comp ^ " \"" ^ sd ^ f ^ "\"" ^ end_comm;
    "comline \"/bin/mv " ^ sd ^ f ^ ".lo " ^ od ^ "\"" ^ end_comm
  ]
in

make
  'Core "test" : [
    'Core "c_pack"; 'Core "c_button"; 'Core "c_scroll"; 'Core "c_text";
    'Core "misc"; 'Core "c_title"; 'Core "c_select";
    'Core "c_raw"; 'Core "color"; 'Core "image"; 'Core "pattern"; 'Core "draw";
    'Core "uinfo";
    'Object(pr_odir, "test")
  ] ->
    do_loadc pr_odir "test"
| 'Object(d, ("test" as s)) : ['Source(pr_sdir, s)] ->
    do_compil pr_sdir d s


| 'Core("rt" as s) : ['Object(rt_odir, s)] ->
    do_loadc rt_odir s
| 'Object(d, ("rt" as s)) : ['Source(rt_sdir, s)] ->
    do_compil rt_sdir d s

| 'Core s : ['Core "rt"; 'Object(rt_odir, s)] ->
    do_loadc rt_odir s
| 'Object(d, s) : [ 'Object(d, "rt"); 'Source(rt_sdir, s)] ->
    do_compil rt_sdir d s
;;
