(* $Id: c_raw.ml,v 8.3 91/06/19 19:34:57 ddr Exp $
 *
 * Rogloglo Toolkit: raw widget class
 *
 * $Log:	c_raw.ml,v $
 * Revision 8.3  91/06/19  19:34:57  ddr
 * - merge avec zinc 1.4
 * 
 * Revision 8.2  91/06/15  15:45:59  ddr
 * - evolution
 * 
 * Revision 8.1  91/06/15  09:59:38  ddr
 * - merge avec zinc
 * 
 * Revision 7.6  91/06/07  20:14:33  ddr
 * - redistrib
 *)

#standard arith false;;
#fast arith false;;

type property =
  C'ExposePr of (widget * num * num * num * num -> tparam)
| C'KeyPr of (widget * string -> tparam)
| C'ButtonPressedPr of (widget * num * num * num -> tparam)
| C'ButtonReleasedPr of (widget -> tparam)
| C'ButtonMotionPr of (widget * num * num -> tparam)
| C'EnterWindowPr of (widget -> tparam)
| C'LeaveWindowPr of (widget -> tparam)
;;

let ExposePr f = C'ExposePr f
and KeyPr f = C'KeyPr f
and ButtonPressedPr f = C'ButtonPressedPr f
and ButtonReleasedPr f = C'ButtonReleasedPr f
and ButtonMotionPr f = C'ButtonMotionPr f
and EnterWindowPr f = C'EnterWindowPr f
and LeaveWindowPr f = C'LeaveWindowPr f
;;

let RawA attr (w, h, b, pl) =

  let (exp_cb, key_cb, bp_cb, br_cb, bm_cb, ew_cb, lw_cb) =
  it_list (fun(exp,key,bp,br,bm,ew,lw) -> function
    C'ExposePr exp -> (exp,key,bp,br,bm,ew,lw)
  | C'KeyPr key -> (exp,key,bp,br,bm,ew,lw)
  | C'ButtonPressedPr bp -> (exp,key,bp,br,bm,ew,lw)
  | C'ButtonReleasedPr br -> (exp,key,bp,br,bm,ew,lw)
  | C'ButtonMotionPr bm -> (exp,key,bp,br,bm,ew,lw)
  | C'EnterWindowPr ew -> (exp,key,bp,br,bm,ew,lw)
  | C'LeaveWindowPr lw -> (exp,key,bp,br,bm,ew,lw)
  ) (ffail,ffail,ffail,ffail,ffail,ffail,ffail) pl
  and szh = it_list (fun(w,h,b as szh) -> function
    C'WidthAtt v -> (Some v,h,b)
  | C'HeightAtt v -> (w,Some v,b)
  | C'BorderAtt v -> (w,h,Some v)
  | _ -> szh) (None,None,None) attr in

{
  wsize = (function xdm ->
    let w = max (match szh with (Some v,_,_) -> v | _ -> 1) w
    and h = max (match szh with (_,Some v,_) -> v | _ -> 1) h
    and b = match szh with (_,_,Some v) -> v | _ -> b
    in (w, h, b)
  )
;
  wcreate = (function (xd, pwin, wdesc, x, y, width, height, border) ->
    let smask = it_list (fun m ->
    function
      C'ExposePr _ -> Long_OR(m, ExposureMask)
    | C'KeyPr _ -> Long_OR(m, KeyPressMask)
    | C'ButtonPressedPr _ -> Long_OR(m,
        (*Long_OR(ButtonPressMask, OwnerGrabButtonMask)*)
        ButtonPressMask)
    | C'ButtonReleasedPr _ -> Long_OR(m, ButtonReleaseMask)
    | C'ButtonMotionPr _ -> Long_OR(m, ButtonMotionMask)
    | C'EnterWindowPr _ -> Long_OR(m, EnterWindowMask)
    | C'LeaveWindowPr _ -> Long_OR(m, LeaveWindowMask)
    ) StructureNotifyMask pl in
    let xdm = xd.xdm in
    let win = create_window(
      xdm, pwin, x, y, width, height, border, attr, smask
    ) in
    add_widget attr win {
      wid_xd = xd; win = win;
      x = x; y = y; width = width; height = height; border = border;
      wdesc = wdesc; is_mapped = false;
      info = no_info; user_info = no_info;
      children = []
    }
  )
;
  wdestroy = (function wid ->
    remove_widget attr wid.win wid
  )
;
  wdispatch = (function (wid, xev, param) ->
    let xdm = wid.wid_xd.xdm
    and t = XEvent_type xev in
    if t = Expose then (
      let xev = XEvent_xexpose xev in
      exp_cb(wid,
        num_of_C_Int (XExposeEvent_x xev),
        num_of_C_Int (XExposeEvent_y xev),
        num_of_C_Int (XExposeEvent_width xev),
        num_of_C_Int (XExposeEvent_height xev)
      ); param
    ) else if t = KeyPress then (
      let xev = XEvent_xkey xev in
      let c = XKeycodeToKeysym(xdm.dpy, XKeyEvent_keycode xev, Zero_Int) in
      let cc = num_of_C_Long c in
      let a =
        match cc with
          65361 -> "Left" | 65362 -> "Up"  | 65363 -> "Right"
        | 65364 -> "Down" | 65379 -> "Ins"
        | 65456 -> "K0" | 65457 -> "K1" | 65458 -> "K2" | 65459 -> "K3"
        | 65460 -> "K4" | 65461 -> "K5" | 65462 -> "K6" | 65463 -> "K7"
        | 65464 -> "K8" | 65465 -> "K9"
        | 65496 -> "R7"  | 65498 -> "R9"  | 65500 -> "R11"
        | 65502 -> "R13" | 65504 -> "R15"
        | _ -> try ascii cc with _ -> string_of_num cc
        in
      key_cb(wid, a)
    ) else if t = ButtonPress then (
      let xev = XEvent_xbutton xev in
      bp_cb(wid,
        num_of_C_Int(XButtonEvent_button xev),
        num_of_C_Int(XButtonEvent_x xev),
        num_of_C_Int(XButtonEvent_y xev)
      )
    ) else if t = ButtonRelease then (
      if xdm.win_but <> C'WB_None then param
      else br_cb wid
    ) else if t = MotionNotify then (
      let args = (xdm.dpy, ButtonMotionMask, xev) in
      while not is_null(XCheckMaskEvent args) do
        ()
      done;
      let xev = XEvent_xmotion xev in
      bm_cb(wid,
        num_of_C_Int (XMotionEvent_x xev),
        num_of_C_Int (XMotionEvent_y xev)
      )
    ) else if t = EnterNotify then (
      ew_cb wid
    ) else if t = LeaveNotify then (
      lw_cb wid
    ) else if t = ConfigureNotify then (
      let xev = XEvent_xconfigure xev in
      wid.width <- num_of_C_Int(XConfigureEvent_width xev);
      wid.height <- num_of_C_Int(XConfigureEvent_height xev);
      param
    ) else param
  )
;
  filler = mem C'FillerAtt attr
}
;;

let RawD = RawA []
;;
