/* $Id: Xlib_runtime.c,v 7.1 91/05/28 20:48:11 ddr Exp $
 *
 */

#include <stdio.h>
#include <X11/Xlib.h>
#if 0
#include <X11/Xutil.h>
#endif
#include <sys/errno.h>
#if 0

unsigned long /*XID*/ ML_XAllocID(Display *dpy)
{
  return XAllocID(dpy);
}

char *ML_C_String(char *mlchars)
{
  char *cchars;
  int nchars = strlen(mlchars);

  cchars = (char *)malloc(nchars + 1);
  bcopy(mlchars, cchars, nchars);
  cchars[nchars] = '\0';

  return cchars;
}

ML_XDestroyImage(ximage)
XImage *ximage;
{
  XDestroyImage(ximage);
}

unsigned long ML_XGetPixel(ximage, x, y)
XImage *ximage;
int x;
int y;
{
  return XGetPixel(ximage, x, y);
}

ML_XPutPixel(ximage, x, y, pixel)
XImage *ximage;
int x;
int y;
unsigned long pixel;
{
  XPutPixel(ximage, x, y, pixel);
}

ML_XSubImage(ximage, x, y, width, height) 
XImage *ximage;
int x;
int y;
int width;
int height;
{
  XSubImage(ximage, x, y, width, height) ;
}

ML_XAddPixel(ximage, value)
XImage *ximage;
unsigned long value;
{
  XAddPixel(ximage, value);
}
#endif
/*
 * This is just like the default X error handler, except it doesn't
 * cause CAML to exit.
 */
int ML_XPrintError (dpy, event, fp)
    Display *dpy;
    XErrorEvent *event;
    FILE *fp;
{
    char buffer[BUFSIZ];
    char mesg[BUFSIZ];
    char number[32];
    char *mtype = "XlibMessage";
#if 0
    register _XExtension *ext = (_XExtension *)NULL;
#endif
    XGetErrorText(dpy, event->error_code, buffer, BUFSIZ);
    XGetErrorDatabaseText(dpy, mtype, "XError", "X Error", mesg, BUFSIZ);
    (void) fprintf(fp, "%s:  %s\r\n  ", mesg, buffer);
    XGetErrorDatabaseText(dpy, mtype, "MajorCode", "Request Major code %d", 
	mesg, BUFSIZ);
    (void) fprintf(fp, mesg, event->request_code);
    if (event->request_code < 128) {
	sprintf(number, "%d", event->request_code);
	XGetErrorDatabaseText(dpy, "XRequest", number, "", buffer, BUFSIZ);
    } else {
        strcpy(buffer, "<extension>");
#if 0
	for (ext = dpy->ext_procs;
	     ext && (ext->codes.major_opcode != event->request_code);
	     ext = ext->next)
	  ;
	if (ext)
	    strcpy(buffer, ext->name);
	else
	    buffer[0] = '\0';
#endif
    }
    (void) fprintf(fp, " (%s)\r\n  ", buffer);
    XGetErrorDatabaseText(dpy, mtype, "MinorCode", "Request Minor code %d",
	mesg, BUFSIZ);
    (void) fprintf(fp, mesg, event->minor_code);
#if 0
    if (ext) {
	sprintf(mesg, "%s.%d", ext->name, event->minor_code);
	XGetErrorDatabaseText(dpy, "XRequest", mesg, "", buffer, BUFSIZ);
	(void) fprintf(fp, " (%s)", buffer);
    }
#endif
    fputs("\r\n  ", fp);
    XGetErrorDatabaseText(dpy, mtype, "ResourceID", "ResourceID 0x%x",
	mesg, BUFSIZ);
    (void) fprintf(fp, mesg, event->resourceid);
    fputs("\r\n  ", fp);
    XGetErrorDatabaseText(dpy, mtype, "ErrorSerial", "Error Serial #%d", 
	mesg, BUFSIZ);
    (void) fprintf(fp, mesg, event->serial);
    fputs("\r\n  ", fp);
    XGetErrorDatabaseText(dpy, mtype, "CurrentSerial", "Current Serial #%d",
	mesg, BUFSIZ);
    (void) fprintf(fp, mesg, dpy->request);
    fputs("\r\n", fp);
    if (event->error_code == BadImplementation) return 0;
    return 1;
}

int ML_XError(dpy, event)
	Display *dpy;
	XErrorEvent *event;
{
    fprintf(stderr, "MLX Error\r\n");
    if (ML_XPrintError (dpy, event, stderr) == 0) return 0;
    failwith("X Error");
}

static char *ML_SysErrorMsg (n)
    int n;
{
    extern char *sys_errlist[];
    extern int sys_nerr;
    char *s = ((n >= 0 && n < sys_nerr) ? sys_errlist[n] : "unknown error");

    return (s ? s : "no such error");
}

ML_XIOError (dpy)
	Display *dpy;
{
	extern int errno;

	(void) fprintf (stderr, 
	 "XML XIO:  fatal IO error %d (%s) on X server \"%s\"\r\n",
			errno, ML_SysErrorMsg (errno), DisplayString (dpy));
	(void) fprintf (stderr, 
	 "      after %lu requests (%lu known processed) with %d events remaining.\r\n",
			NextRequest(dpy) - 1, LastKnownRequestProcessed(dpy),
			QLength(dpy));

	if (errno == EPIPE) {
	    (void) fprintf (stderr,
	 "      The connection was probably broken by a server shutdown or KillClient.\r\n");
	}
	failwith("XIO Error");
}

ML_XInitialize()
{
  XSetErrorHandler(ML_XError);
  XSetIOErrorHandler(ML_XIOError);
}

/* code for handling integer pointers in V2.6 */

int *ML_alloc_IntRef()
{
  return (int *)malloc(sizeof(int));
}

ML_set_IntRef_value(val, ir)
int val;
int *ir;
{
  *ir = val;
}

int ML_IntRef_value(ir)
int *ir;
{
  return *ir;
}
#if 0
short *ML_alloc_ShortRef()
{
  return (short *)malloc(sizeof(short));
}

ML_set_ShortRef_value(val, ir)
short val;
short *ir;
{
  *ir = val;
}

short ML_ShortRef_value(ir)
short *ir;
{
  return *ir;
}

#endif
long *ML_alloc_LongRef()
{
  return (long *)malloc(sizeof(long));
}

ML_set_LongRef_value(val, ir)
long val;
long *ir;
{
  *ir = val;
}

long ML_LongRef_value(ir)
long *ir;
{
  return *ir;
}

