(* Syntaxe superficielle des lambda-expressions *)
type Slambda =
     SVar of string
   | SApply of Slambda * Slambda
   | SLambda of (string * string list) * Slambda
;;


(* Grammaire des lambda-expressions *)
grammar for programs lambda =

 rule

exp0 = parse
    Ident s -> SVar s
  | [ "("; exp e; ")" ] -> e

and app = parse
          [<hov 1> app e ; \-; exp0 e0 ] -> SApply (e,e0)
        | exp0 e -> e

and entry exp = parse
      [<hov 1> "\\"; Ident s; ( * (parse \-; Ident s -> s)) sl;
                     "."; \- ; exp e ] ->
        SLambda ((s,sl),e)
    | app e -> e
;;

