(* Due to Xavier Leroy *)
let f s =
  display_string s; display_string "\"";
  display_string (string_for_read s); display_string "\";;";
  display_newline()
in f "let f s =
  display_string s; display_string \"\\\"\";
  display_string (string_for_read s); display_string \"\\\";;\";
  display_newline()
in f ";;

(*
let f s =
 <:CAML:Expr<let f s = #s in f #(MLquote(dynamic s))>> in
 f <:Caml:Expr< <:CAML:Expr<let f s = #s in f #(MLquote(dynamic s)) >> >>
;;
*)

let f s =
 MLin
 (MLlet
  (MLvarpat "f",
   MLmatch
    (MLmatching (MLnolabel,[MLvarpat "s",MLaction s]))),
  MLapply (MLvar "f",MLquote (dynamic s),[])) in
 f
  <:Caml:Expr<MLin
              (MLlet
               (MLvarpat "f",
                MLmatch
                 (MLmatching
                  (MLnolabel,[MLvarpat "s",MLaction s]))),
               MLapply (MLvar "f",MLquote (dynamic s),[]))>>
;;
