(defvar #:sys-package:colon 'ldsparc)

(unless (boundp ':mlconstants) (defvar :mlconstants ()))
(unless (boundp ':fntname) (defvar :fntname ()))
(unless (boundp ':entry-list) (defvar :entry-list ()))
(unless (boundp ':llabels) (defvar :llabels ()))
(unless (boundp ':code-bias) (defvar :code-bias ()))
(unless (boundp ':PCcurrent) (defvar :PCcurrent()))
(unless (boundp '#:ex:regret) (defvar #:ex:regret ()))
(unless (boundp '#:ld:cons-llitt) (defvar #:ld:cons-llitt ()))
(unless (boundp '#:ld:ml-cons-llitt) (defvar #:ld:ml-cons-llitt ()))
(unless (boundp ':local-cons-llitt) (defvar :local-cons-llitt ()))
(unless (boundp '#:ld:ml-local-cons-llitt) (defvar #:ld:ml-local-cons-llitt ()))

(de #:loader:new_error (f a)
    ; erreur dans la fonction f arguments defectueux a
    (with ((outchan ()))
	  (terpri)
          (setq f (selectq f
               ("MLEXC" "undefined exception")
               ("MLVAL" "undefined value")
               ("MLSYS" "undefined system value")
               (t f)))
	  (print "**** "
		 (get-message '#:loader:ERRLOADER)
		 f
		 ": "
                 a
       (exit #:system:error-tag))

))

(de get_global_value (ident) ())
(de get_global_sysvalue (ident) ())
(de get_global_exc (ident) ())
(de get_global_sysexc (ident) ())
(de get_global_type (ident) ())
(de get_global_systype (ident) ())

(de mlval (arg)
           ; la valeur ml ordinaire.
	    (let ((:val (get_global_value arg)))
		     (if :val
			 (cons 'quote :val)
			 (#:loader:new_error "MLVAL" arg))))



(de mlsys (arg)    
 ; la valeur ml du systeme
 (let ((:val (get_global_sysvalue arg)))
		     (if :val 
			 (cons 'quote :val)
			 (#:loader:new_error "MLSYS" arg))))
		


(de mlexc (arg)
	  ; CAML exception
          ; (mlexc <string>)
	   (let ((:val (get_global_exc arg)))
		       (if :val (cons 'quote :val)
			   (#:loader:new_error "MLEXC" arg))))



(de sysexc (arg)
	  ; CAML system exception
          ; (sysexc <string>)
	   (let ((:val (get_global_sysexc arg)))
		       (if :val (cons 'quote :val)
			   (#:loader:new_error "SYSEXC" arg))))


(de mltyp (arg)
          ; CAML type constructor
          ; (mltyp <string>)
	  (let ((:val (get_global_type arg)))
		       (if :val (cons 'quote :val)
			   (#:loader:new_error "MLTYP" arg))))

(de systyp (arg)
          ; CAML type constructor
          ; (mltyp <string>)
	  (let ((:val (get_global_systype arg)))
		       (if :val (cons 'quote :val)
			   (#:loader:new_error "SYSTYP" arg))))

(de mlquote (arg1 arg2)
           ; (mlquote lab constant)
           `(quote ,(cdr (or (assq arg1 :mlconstants)
                          (car (setq :mlconstants
                                     (acons arg1 arg2
                                            :mlconstants)))))))

(defmacro :biased-code (addr)
  ;; returns the code address decremented by 8 as is required by the
  ;; sparc return.
  `(:sa ,addr :code-bias))

(de mlentry () 
    ; MLENTRY   = (fentry mleval subr0) (entry mleval subr0)
    ; MODIF : pour enlever les cons-llitt en trop
    (setq #:ld:ml-local-cons-llitt :local-cons-llitt)
    (setq #:ld:ml-cons-llitt #:ld:cons-llitt)
    ;                (#:ldsparc:alignd)
    (remprop 'mleval '#:system:loaded-from-file)
    (remprop 'mleval '#:llcp:ftype)
    (remprop 'mleval '#:llcp:fval)
    ;; LL on the SPARC has an offset in the valfn (to be consistent
    ;; with the call instruction which records the calling address
    ;; instead of the return address.  Merci, Sun.)
    (setfn 'mleval 'subr0 (#:ldsparc:biased-code #:ldsparc:PCcurrent))
    (newl :llabels (cons 'mleval (copylist #:ldsparc:PCcurrent)))
    (setq :fntname 'mleval)
    (putprop 'mleval (copylist :PCcurrent) ':fval)
    (newl :entry-list '(mleval subr0 ())))
