; .EnTete "Le-Lisp version 15.21" " " "Le chargeur memoire Mips"
; .SuperTitre "Le Chargeur Memoire MIPS"
; .Auteur "Francis Dupont"

; Assemble et charge pour un Mips une liste d'instructions LLM3

(ifn (typefn 'icacheflush) (de icacheflush (x y) ()))

(unless (>= (version) 15.2)
        (error 'load 'erricf 'lapmips))

(defvar #:sys-package:colon 'ldmips)

(add-feature 'loader)

; .Section "Strate'gie de la re'solution des e'tiquettes"

;  1 - les e'tiquettes locales a` une fonction
;  2 - les e'tiquettes locales a` un module
;  3 - les e'tiquettes globales a` tout le syste`me Le_Lisp

; .SSection "Les e'tiquettes locales a` une fonction (LOCAL)"

; Une e'tiquette nume'rique est toujours de type LOCAL. Ce trait est
; utilise' par le compilateur pour engendrer des e'tiquettes a` peu de frais.
; Une e'tiquette symbolique locale doit e^tre de'clare'e avant sa premie`re
; utilisation au moyen de la pseudo LOCAL. Cette de'claration permet
; d'e'viter des conflits de noms, mais le compilateur n'utilise jamais
; ce trait.

; Toute re'fe'rence a` ce type d'e'tiquette engendre un de'placement
; par rapport au PC.
; Ces e'tiquettes doivent e^tre re'solues a` la fin
; de la liste des instructions ou a` l'apparition de la pseudo ENDL.
; Si elles ne le sont pas, le chargeur de'clenche une erreur.

; .SSection "Les e'tiquettes locales a` un module"

; Les e'tiquettes de ce type, toujours symboliques, ne sont pas de'clare'es.
; Elles sont de'finies au moyen de la pseudo ENTRY.
; Elles peuvent ne pas e^tre re'solues entre deux appels du chargeur mais
; doivent l'e^tre a` l'apparition de la pseudo END.
; Si elles ne le sont pas, le chargeur de'clenche une erreur.
;  Ces e'tiquettes sont dans un des 2 e'tats suivants :
;  1 - elles ne sont pas de'finies : leur nom est dans la A-liste
; :entries-not-resolved qui contient en valeur la liste des adresses
; ou` il faudra charger la ve'ritable adresse quand elle apparaitra.
;  2 - elles viennent d'apparai^tre (ENTRY). Il n'y a plus qu'un seul
; indicateur :fval qui contient la ve'ritable adresse.
; De plus le symbole est enleve' de :entries-not-resolved et est ajoute'
; dans la liste :entry-list.
;  3 - le END survient, toutes ces e'tiquettes sont de'truites
; de la liste :entry-list, les indicateurs :fval sont de'truits.
; S'il reste des noms dans :entries-not-resolved une erreur est
; de'clenche'e. Rien ne reste donc de propre au chargeur, ces
; e'tiquettes sont des candidats de choix pour le prochain GC.

; .SSection "Les e'tiquettes globales"
; Les e'tiquettes de ce type, toujours symboliques, ne sont utilise'es
; qu'avec les instructions JCALL et JMP.
; Elles sont de'finies au moyen de la pseudo FENTRY qui charge, de`s
; cette de'finition, la FVAL/FTYPE de cette fonction.
; Elles peuvent ne pas e^tre re'solues entre deux appels du chargeur
; qui ne s'en appercoit jamais car il engendre toujours un acce`s
; correspondant a` (FVAL 'symb), ce qui permet en plus de les rede'finir
; et de les recompiler (i.e. si je recharge le module pretty avec pprint
; comme externe, tous les autres modules continueront a` fonctionner
; avec ce nouveau module).
; Les noms des fonctions standard sont des e'tiquettes globales.

; .bp
;.Section "Les variables globales du chargeur"

; .SSection "Les indicateurs conditionnels du chargeur"

(defvar :31BITFLOATS (eq 0. 0.))	; les nbs flottants sur 31 bits
			; (utile pour rendre les floats non litteraux)

(defvar #:ld:special-case-loader ())  ; cas special pour charger le chargeur

(defvar #:ld:shared-strings ())       ; rend les constantes de chaine EQ

(defvar #:ld:bigendian (eq (memory (loc ())) (car (loc ()))))

; .SSection "Les autres variables globales"

(defvar :Ecode (subadr (#:system:ecode) 64))    ; fin de la zone code.

(defvar :locnil (loc ()))		; adresse du symbole ()

(defvar :entry-list ())                 ; liste des points d'entre'e locaux

(defvar :entries-not-resolved ())       ; A-liste des ENTRIES non re'solus

(unless (boundp ':module)               ; Le nom du module en cours de charg.
        (defvar :module ()))

(unless (boundp ':saved-by-loader)      ; liste des litte'raux entre 2 ENDs.
        (defvar :saved-by-loader ()))

(unless (boundp ':global-saved-by-loader) ; liste de vecteurs de litte'raux.
        (defvar :global-saved-by-loader '(
          ; Ces variables ne sont pas sauve'es par :clean-litt (dynamique).
          #[:lobj :talkp :PCcurrent :llabels :llabels-nr :fntname
            :codop :arg1 :arg2 :arg3 :valaux :f :nwl obj])))

(defvar :lobj)
(defvar :talkp)
(defvar :PCcurrent)
(defvar :llabels)
(defvar :llabels-nr)
(defvar :fntname)
(defvar :codop)
(defvar :arg1)
(defvar :arg2)
(defvar :arg3)
(defvar :valaux)
(defvar :f)
(defvar :nwl)
;; il faut package' celui-la!
(defvar obj)

;  CAML (****
(unless (boundp '#:ld:cons-llitt) (defvar #:ld:cons-llitt ()))
(unless (boundp ':local-cons-llitt) (defvar :local-cons-llitt ()))
(defvar #:ld:ml-cons-llitt ())    ; pour ml-run
(defvar #:ld:ml-local-cons-llitt ())
(defvar :mlconstants ())          ;  pour mlquote
;  CAML ****)

; .Section "De'finitions des constantes machines"

; les registres

(defvar :rgZ 0)     ; zero
(defvar :rgAT 1)    ; assembly temporary
(defvar :rgV0 2)    ; value 0
(defvar :rgV1 3)    ; value 1
(defvar :rgA0 4)    ; argument 0
(defvar :rgA1 5)    ; argument 1
(defvar :rgA2 6)    ; argument 2
(defvar :rgA3 7)    ; argument 3
(defvar :rgT0 8)    ; temporary 0 (AUX0)
(defvar :rgT1 9)    ; temporary 1 (AUX1)
(defvar :rgT2 10)   ; temporary 2 (AUX2)
(defvar :rgT3 11)   ; temporary 3 (AUX3)
(defvar :rgT4 12)   ; temporary 4 (AUX4)
(defvar :rgT5 13)   ; temporary 5 (AUX5)
(defvar :rgT6 14)   ; temporary 6 (AUX6)
(defvar :rgT7 15)   ; temporary 7 (AUX7)
(defvar :rgS0 16)   ; saved 0 (A1)
(defvar :rgS1 17)   ; saved 1 (A2)
(defvar :rgS2 18)   ; saved 2 (A3)
(defvar :rgS3 19)   ; saved 3 (A4)
(defvar :rgS4 20)   ; saved 4 (BNUMB / BFLOAT)
(defvar :rgS5 21)   ; saved 5 (BVECT)
(defvar :rgS6 22)   ; saved 6 (BSTRG)
(defvar :rgS7 23)   ; saved 7 (BSYMB / NIL)
(defvar :rgT8 24)   ; temporary 8 (BVAR)
(defvar :rgT9 25)   ; temporary 9 (BCONS)
(defvar :rgK0 26)   ; kernel 0
(defvar :rgK1 27)   ; kernel 1
(defvar :rgGP 28)   ; global pointer
(defvar :rgSP 29)   ; stack pointer (SP)
(defvar :rgS8 30)   ; saved 8
(defvar :rgRA 31)   ; return address

(defvar :rgAUX0 8)
(defvar :rgAUX1 9)
(defvar :rgAUX2 10)
(defvar :rgAUX3 11)
(defvar :rgAUX4 12)
(defvar :rgAUX5 13)
(defvar :rgAUX6 14)
(defvar :rgAUX7 15)

(defvar :rgBNUMB 20)
(defvar :rgBFLOAT 20)
(defvar :rgBVECT 21)
(defvar :rgBSTRG 22)
(defvar :rgBSYMB 23)
(defvar :rgNIL 23)
(defvar :rgBVAR 24)
(defvar :rgBCONS 25)

(dmd :a2r (Ax)
  `(selectq ,Ax
    (A1 :rgS0) (A2 :rgS1) (A3 :rgS2) (A4 :rgS3) (t (:error "A2R" ,Ax))))

; .Section "Instructions"

; Format I (immediate) ooooooSSSSSTTTTTiiiiiiiiiiiiiiii
; Format J (jump)      ooooootttttttttttttttttttttttttt
; Format R (register)  ooooooSSSSSTTTTTDDDDDsssssffffff
;
; o(6) = codop
; S(5),T(5),D(5) = registers (source, target, destination)
; i(16) = immediate
; t(26) = target
; s(5) = shift amount
; f(6) = function

(dmd :ins-I-gen (codop rs rt immediate)
#+ #:ld:bigendian
 `(progn (:1half (logor ,(logshift codop 10)
			(logor (logshift ,rs 5) ,rt)))
	 (:1half ,immediate))
#- #:ld:bigendian
 `(progn (:1half ,immediate)
         (:1half (logor ,(logshift codop 10)
			(logor (logshift ,rs 5) ,rt)))))
	 
(dmd :ins-R-gen (codop rs rt rd shamt funct)
#+ #:ld:bigendian
 `(progn (:1half (logor ,(logshift codop 10)
			(logor (logshift ,rs 5) ,rt)))
	 (:1half (logor (logshift ,rd 11)
			(logor (logshift ,shamt 6) ,funct))))
#- #:ld:bigendian
 `(progn (:1half (logor (logshift ,rd 11)
			(logor (logshift ,shamt 6) ,funct)))
	 (:1half (logor ,(logshift codop 10)
			(logor (logshift ,rs 5) ,rt)))))

(de :ADD (rd rs rt) (:ins-R-gen 0 rs rt rd 0 #8r40))
(de :ADDI (rt rs imm) (:ins-I-gen #8r10 rs rt imm))
(de :ADDIU (rt rs imm) (:ins-I-gen #8r11 rs rt imm))
(de :ADDU (rd rs rt) (:ins-R-gen 0 rs rt rd 0 #8r41))
(de :AND (rd rs rt) (:ins-R-gen 0 rs rt rd 0 #8r44))
(de :ANDI (rt rs imm) (:ins-I-gen #8r14 rs rt imm))
(de :BC1F (imm) (:ins-I-gen #8r21 #8r20 0 imm))
(de :BC1T (imm) (:ins-I-gen #8r21 #8r20 1 imm))
(de :BEQ (rs rt off) (:ins-I-gen #8r04 rs rt off))
(de :BGEZ (rs off) (:ins-I-gen 1 rs #8r01 off))
(de :BGEZAL (rs off) (:ins-I-gen 1 rs #8r21 off))
(de :BGTZ (rs off) (:ins-I-gen #8r07 rs 0 off))
(de :BLEZ (rs off) (:ins-I-gen #8r06 rs 0 off))
(de :BLTZ (rs off) (:ins-I-gen 1 rs #8r00 off))
(de :BLTZAL (rs off) (:ins-I-gen 1 rs #8r20 off))
(de :BNE (rs rt off) (:ins-I-gen #8r05 rs rt off))
(de :BREAK () (:1word #8r15))
(de :CFC1 (rt rd) (:ins-I-gen #8r21 #8r2 rt rd 0))
(de :CTC1 (rt rd) (:ins-I-gen #8r21 #8r6 rt rd 0))
(de :DIV (rs rt) (:ins-R-gen 0 rs rt 0 0 #8r32))
(de :DIVU (rs rt) (:ins-R-gen 0 rs rt 0 0 #8r33))
(defvar :J (logshift 2 10))
(defvar :JAL (logshift 3 10))
(de :JALR (rd rs) (:ins-R-gen 0 rs 0 rd 0 #8r11))
(de :JR (rs) (:ins-R-gen 0 rs 0 0 0 #8r10))
(de :LB (rt off base) (:ins-I-gen #8r40 base rt off))
(de :LBU (rt off base) (:ins-I-gen #8r44 base rt off))
(de :LH (rt off base) (:ins-I-gen #8r41 base rt off))
(de :LHU (rt off base) (:ins-I-gen #8r45 base rt off))
(de :LUI (rt imm) (:ins-I-gen #8r17 0 rt imm))
(de :LW (rt off base) (:ins-I-gen #8r43 base rt off))
(de :LWC1 (rt off base) (:ins-I-gen #8r61 base rt off))
(de :LWL (rt off base) (:ins-I-gen #8r42 base rt off))
(de :LWR (rt off base) (:ins-I-gen #8r46 base rt off))
(de :MFC1 (rt rd) (:ins-R-gen #8r21 #8r0 rt rd 0 0))
(de :MFHI (rd) (:ins-R-gen 0 0 0 rd 0 #8r20))
(de :MFLO (rd) (:ins-R-gen 0 0 0 rd 0 #8r22))
(de :MTC1 (rt rd) (:ins-R-gen #8r21 #8r4 rt rd 0 0))
(de :MTHI (rs) (:ins-R-gen 0 rs 0 0 0 #8r21))
(de :MTLO (rs) (:ins-R-gen 0 rs 0 0 0 #8r23))
(de :MULT (rs rt) (:ins-R-gen 0 rs rt 0 0 #8r30))
(de :MULTU (rs rt) (:ins-R-gen 0 rs rt 0 0 #8r31))
(de :NOR (rd rs rt) (:ins-R-gen 0 rs rt rd 0 #8r47))
(de :OR (rd rs rt) (:ins-R-gen 0 rs rt rd 0 #8r45))
(de :ORI (rt rs imm) (:ins-I-gen #8r15 rs rt imm))
(de :SB (rt off base) (:ins-I-gen #8r50 base rt off))
(de :SH (rt off base) (:ins-I-gen #8r51 base rt off))
(de :SLL (rd rt shamt) (:ins-R-gen 0 0 rt rd shamt #8r00))
(de :SLLV (rd rt rs) (:ins-R-gen 0 rs rt rd 0 #8r04))
(de :SLT (rd rs rt) (:ins-R-gen 0 rs rt rd 0 #8r52))
(de :SLTI (rt rs imm) (:ins-I-gen #8r12 rs rt imm))
(de :SLTIU (rt rs imm) (:ins-I-gen #8r13 rs rt imm))
(de :SLTU (rd rs rt) (:ins-R-gen 0 rs rt rd 0 #8r53))
(de :SRA (rd rt shamt) (:ins-R-gen 0 0 rt rd shamt #8r03))
(de :SRAV (rd rt rs) (:ins-R-gen 0 rs rt rd 0 #8r07))
(de :SRL (rd rt shamt) (:ins-R-gen 0 0 rt rd shamt #8r02))
(de :SRLV (rd rt rs) (:ins-R-gen 0 rs rt rd 0 #8r06))
(de :SUB (rd rs rt) (:ins-R-gen 0 rs rt rd 0 #8r42))
(de :SUBU (rd rs rt) (:ins-R-gen 0 rs rt rd 0 #8r43))
(de :SW (rt off base) (:ins-I-gen #8r53 base rt off))
(de :SWC1 (rt off base) (:ins-I-gen #8r71 base rt off))
(de :SWL (rt off base) (:ins-I-gen #8r52 base rt off))
(de :SWR (rt off base) (:ins-I-gen #8r56 base rt off))
(de :SYSCALL () (:1word #8r14))
(de :XOR (rd rs rt) (:ins-R-gen 0 rs rt rd 0 #8r46))
(de :XORI (rt rs imm) (:ins-I-gen #8r16 rs rt imm))

(de :ADD.D (fd fs ft) (:ins-R-gen #8r21 #8r41 ft fs fd 0))
(de :SUB.D (fd fs ft) (:ins-R-gen #8r21 #8r41 ft fs fd 1))
(de :MUL.D (fd fs ft) (:ins-R-gen #8r21 #8r41 ft fs fd 2))
(de :DIV.D (fd fs ft) (:ins-R-gen #8r21 #8r41 ft fs fd 3))

; .Section "Macro-instructions"

(de :B (lab) (:BEQ :rgZ :rgZ (:op-depl lab)))

(de :BAL (lab) (:BGEZAL :rgZ (:op-depl lab)))

(de :BGE (a b lab) (:SLT :rgAT a b) (:BEQ :rgAT :rgZ (:op-depl lab)))
(de :BGEU (a b lab) (:SLTU :rgAT a b) (:BEQ :rgAT :rgZ (:op-depl lab)))
(de :BGT (a b lab) (:SLT :rgAT b a) (:BNE :rgAT :rgZ (:op-depl lab)))
(de :BGTU (a b lab) (:SLTU :rgAT b a) (:BNE :rgAT :rgZ (:op-depl lab)))
(de :BLE (a b lab) (:SLT :rgAT b a) (:BEQ :rgAT :rgZ (:op-depl lab)))
(de :BLEU (a b lab) (:SLTU :rgAT b a) (:BEQ :rgAT :rgZ (:op-depl lab)))
(de :BLT (a b lab) (:SLT :rgAT a b) (:BNE :rgAT :rgZ (:op-depl lab)))
(de :BLTU (a b lab) (:SLTU :rgAT a b) (:BNE :rgAT :rgZ (:op-depl lab)))

(de :LI (dest imm)
    (if (ge imm 0) (:ADDIU dest :rgZ imm) (:ORI dest :rgZ imm)))

(de :MOVE (dest src) (:ADDU dest src :rgZ))

(de :NOP () (:1word 0)) ; (:SLL :rgZ :rgZ 0)

; ajustement (attention a la modification physique !)
(de :adjust (adr)
   (ifn (consp adr)
	(:error "ADJUST" adr)
	(if (neq (logand #$8000 (cdr adr)) 0)
	    (rplaca adr (add (car adr) 1)))))

; .Section "Interpre'tation d'un objet"

(de :ins (obj)
    ; charge un objet (instruction ou pseudo) en me'moire
    (when :talkp
          (if (consp obj) (outpos 4))
          (prin obj)
          (when (>= (outpos) 30) (terpri))
          (outpos 30)
          (:prinhex :PCcurrent)
          (prin "  "))
    (cond
       ((null obj) ())
       ((atom obj)
            ; une e'tiquette locale (symbole ou nb) :
            ; on la rajoute dans :llabels
            (newl :llabels (cons obj (copylist :PCcurrent)))
            ; re'solution des re'fe'rences avants (relatives)
            (mapc (lambda (l)
		     (selectq (car l)
			(0    ; c'est une r.n.r absolue sur 32 bits
			      (:1word-PC (cdr l)))
			(18   ; c'est une r.n.r relative sur 16 bits
			      (:1half-relPC (cdr l)))
			(2    ; c'est une r.n.r absolue sur 2*16 bits
			      (:2half-PC (cdr l)))
			(t    ; c'est une erreur
			      (:error "resolv" obj))))
                  (cassq obj :llabels-nr))
            (setq :llabels-nr
                  (delete (assq obj :llabels-nr) :llabels-nr)))
       (t  (setq :codop (car obj)
                 :arg1  (cadr obj)
                 :arg2  (caddr obj)
                 :arg3  (cadddr obj))
           (selectq :codop
            ;
            ; les pseudos-instructions  (par ordre alphabe'tique)
            ;
            (ABORT ; Pour re'cupe'rer de la me'moire en cas craschhhh.
              )
            (ENTRY   ; (ENTRY <name> <ftype> <lparam>)
                ; charge les indicateurs
                (newl :entry-list
                      (list :arg1
                            (if (memq :arg2
                                      '(SUBR0 SUBR1 SUBR2 SUBR3
                                        NSUBR FSUBR MSUBR DMSUBR ))
                                :arg2
                                (:error "ENTRY" obj))
                            :arg3))
                ; re'solution des re'fe'rences avants.
                (mapc (lambda (l)
			 (selectq (car l)
			    (0    ; c'est une r.n.r absolue sur 32 bits
			          (:1word-PC (cdr l)))
			    (18   ; c'est une r.n.r relative sur 16 bits
			          (:1half-relPC (cdr l)))
			    (2    ; c'est une r.n.r absolue sur 2*16 bits
			          (:2half-PC (cdr l)))
			    (t    ; c'est une erreur
			          (:error "resolv" obj))))
                       (cassq :arg1 :entries-not-resolved))
                (setq :entries-not-resolved
                      (delete (assq :arg1 :entries-not-resolved)
                              :entries-not-resolved))
                (putprop :arg1 (copylist :PCcurrent) ':fval)
                (setq :fntname :arg1))
            (ENDL ; fin d'une fonction locale
               (when :talkp (terpri))
               (when :llabels-nr
                     (:error "Il reste des references locales non resolues "
                             :llabels-nr)))
            (END  ; fin d'un module
                  ; ve'rification de l'entry-list
               (:ins '(ENDL))
               (when :entries-not-resolved
                     (:error "Il reste des ENTRY non resolus "
                             :entries-not-resolved))
               (while :entry-list
                      (remprop (caar :entry-list) ':fval)
                      (remprop (caar :entry-list) '#:llcp:fval)
                      (remprop (caar :entry-list) '#:llcp:ftype)
                      (remprop (caar :entry-list) '#:system:loaded-from-file)
                      (nextl :entry-list))
               (when #:ld:special-case-loader
                     (while (and (consp #:ld:special-case-loader)
                                 (consp (car #:ld:special-case-loader)))
                            (apply 'setfn (nextl #:ld:special-case-loader))))
               (:clean-llitt))
            (EVAL     ; (EVAL s)  e'valuation a` LOAD-TIME
                (catcherror t (eval :arg1)))
            (FENTRY   ; (FENTRY <name> <ftype> <lparam>)
                ;  CAML (****
                ; MODIF : pour enlever les cons-llitt en trop
                (setq #:ld:ml-local-cons-llitt :local-cons-llitt)
                (setq #:ld:ml-cons-llitt #:ld:cons-llitt)
                ; CAML ****)
                ; enle`ve les indicateurs (a` ve'rifier ?!?!?)
                (remprop :arg1 '#:system:loaded-from-file)
                (if #:ld:special-case-loader
                    (newl #:ld:special-case-loader
                          (list :arg1 :arg2 (copylist :PCcurrent)))
                    (remprop :arg1 '#:llcp:ftype)
                    (remprop :arg1 '#:llcp:fval)
                    (setfn :arg1 :arg2 :PCcurrent))
                (newl :llabels (cons :arg1 (copylist :PCcurrent)))
                (setq :fntname :arg1))
            (LOCAL  ; (LOCAL <name>)
                ; rend le symbole local a` une fonction.
                (newl :llabels (ncons :arg1)))
            (TITLE  ; (TITLE de'finition du nom du module)
                (setq :module :arg1))
            ;
            ; appel de la partie de'pendante des  machines!
            ; :machins  contient le ge'ne'rateur.
            ;
            (t (:machins obj) ) ))))   ;  Un NOP en moins ?!?!?!?

(de :machins (obj)
    ; re'alise le chargement de l'instruction <obj>. Fonctionne dans
    ; le me^me environnement que la fonction pre'ce'dente : obj :codop .....
    (selectq :codop
      ;
      ; A tout seigneur tout honneur : l'instruction la plus utilise'e
      ;
      (MOV	; (MOV source dest)
        (cond
	  ((:accu :arg1) (:store-reg (:a2r :arg1) :arg2))
	  ((:accu :arg2) (:load-reg :arg1 (:a2r :arg2)))
	  (t
	   (:load-reg :arg1 :rgAUX0)
	   (:store-reg :rgAUX0 :arg2))))
      ;
      ; Les instructions de contro^le
      ;
      (BRA      ; (BRA <lab>) == b lab
       (:B :arg1)
       (:NOP))
      (BRI      ; (BRI <op>)
       (if (:accu :arg1)
	   (:JR (:a2r :arg1))
	   (:load-reg :arg1 :rgAUX0)
	   (:JR :rgAUX0))
       (:NOP))
      (BRX	; (BRX (<lab1> <lab2> ... <labn>) <index>)
       (:load-reg :arg2 :rgAUX0)
       (:SLL :rgAUX0 :rgAUX0 2)
       (let ((adr (incradr (copylist :PCcurrent) 28)))
	 (:LUI :rgAUX1 (car adr))
	 (:ORI :rgAUX1 :rgAUX1 (cdr adr)))
       (:ADDU :rgAUX0 :rgAUX0 :rgAUX1)
       (:LW :rgAUX0 0 :rgAUX0)
       (:NOP)
       (:JR :rgAUX0)
       (:NOP)
       (mapc (lambda (etiq) (:1word (:op-adr (cadr etiq) 0))) :arg1))
      (CALL	; (CALL <etiq>)
       (:ADDIU :rgSP :rgSP -4)
       (:BAL :arg1)
       (:SW :rgRA 0 :rgSP))
      (JCALL	; (JCALL <etiq>)
       (let ((adr (:op-symb :arg1)))
	 (if (fixp adr)
	     (:LW :rgAUX0 (add 8 adr) :rgNIL)
	     (:adjust adr)
	     (:LUI :rgAT (car adr))
	     (:LW :rgAUX0 (add 8 (cdr adr)) :rgAT)))
       (:ADDIU :rgSP :rgSP -4)
       (:JALR :rgRA :rgAUX0)
       (:SW :rgRA 0 :rgSP))
      (JMP      ; (JMP <etiq>)
       (let ((adr (:op-symb :arg1)))
	 (if (fixp adr)
	     (:LW :rgAUX0 (add 8 adr) :rgNIL)
	     (:adjust adr)
	     (:LUI :rgAT (car adr))
	     (:LW :rgAUX0 (add 8 (cdr adr)) :rgAT)))
       (:NOP)
       (:JR :rgAUX0)
       (:NOP))
      (RETURN	; (RETURN)
       (:LW :rgRA 0 :rgSP)
       (:NOP)
       (:JR :rgRA)
       (:ADDIU :rgSP :rgSP 4))
      (SOBGEZ	; (SOBGEZ <op> <lab>)
       (:load-fix :arg1 :rgAUX0)
       (:ADDIU :rgAUX0 :rgAUX0 -1)
       (:ANDI :rgAUX1 :rgAUX0 -1)
       (ifn (:accu :arg1) (:store-reg :rgAUX1 :arg1))
       (:BGEZ :rgAUX0 (:op-depl :arg2))
       (if (:accu :arg1) (:MOVE (:a2r :arg1) :rgAUX1) (:NOP)))
      ;
      ; les instructions sur la pile de donne'e
      ;
      (POP	; (POP <op>)
       (if (:accu :arg1)
	   (:LW (:a2r :arg1) 0 :rgSP)
	   (:LW :rgAUX0 0 :rgSP))
       (:ADDIU :rgSP :rgSP 4)
       (ifn (:accu :arg1)
	    (:store-reg :rgAUX0 :arg1)))
      (PUSH	; (PUSH <op>)
       (if (and (consp :arg1) (eq (car :arg1) '&) (fixp (cadr :arg1)))
	   (setq :arg1 `(& ,(add 1 (cadr :arg1)))))
       (:ADDIU :rgSP :rgSP -4)
       (let ((inter (:load-aux :arg1 :rgAUX0)))
	 (:SW inter 0 :rgSP)))
      (SSTACK   ; (SSTACK <op>)
       (:load-reg :arg1 :rgSP))
      (STACK    ; (STACK <op>)
       (:store-reg :rgSP :arg1))
      ;
      ; les tests de type
      ;
      (BTNIL    ; (BTNIL <op> <lab>)
       (let ((inter (:load-aux :arg1 :rgAUX0)))
	 (:BEQ inter :rgNIL (:op-depl :arg2)))
       (:NOP))
      (BFNIL    ; (BFNIL <op> <lab>)
       (let ((inter (:load-aux :arg1 :rgAUX0)))
	 (:BNE inter :rgNIL (:op-depl :arg2)))
       (:NOP))
      (BTCONS	; (BTCONS <op> <lab>)
       (let ((inter (:load-aux :arg1 :rgAUX0)))
	 (:BGE inter :rgBCONS :arg2))
       (:NOP))
      (BFCONS	; (BFCONS <op> <lab>)
       (let ((inter (:load-aux :arg1 :rgAUX0)))
	 (:BLT inter :rgBCONS :arg2))
       (:NOP))
      (BTFIX	; (BTFIX <op> <lab>)
       (let ((inter (:load-aux :arg1 :rgAUX0)))
	 (:BLTU inter :rgBFLOAT :arg2))
       (:NOP))
      (BFFIX	; (BTFIX <op> <lab>)
       (let ((inter (:load-aux :arg1 :rgAUX0)))
	 (:BGEU inter :rgBFLOAT :arg2))
       (:NOP))
      (BTFLOAT  ; (BTFLOAT <op> <lab>)
       (ifn :31BITFLOATS
	    (:brt2 :rgBFLOAT :rgBVECT)
	    (:BLTZ (:load-aux :arg1 :rgAUX0) (:op-depl :arg2))
	    (:NOP)))
      (BFFLOAT  ; (BFFLOAT <op> <lab>)
       (ifn :31BITFLOATS
	    (:brf2 :rgBFLOAT :rgBVECT)
	    (:BGEZ (:load-aux :arg1 :rgAUX0) (:op-depl :arg2))
	    (:NOP)))
      (BTVECT   ; (BTVECT <op> <lab>)
       (:brt2 :rgBVECT :rgBSTRG))
      (BFVECT   ; (BFVECT <op> <lab>)
       (:brf2 :rgBVECT :rgBSTRG))
      (BTSTRG   ; (BTSTRG <op> <lab>)
       (:brt2 :rgBSTRG :rgBSYMB))
      (BFSTRG   ; (BFSTRG <op> <lab>)
       (:brf2 :rgBSTRG :rgBSYMB))
      (BTSYMB   ; (BTSYMB <op> <lab>)
       (:brt2 :rgBSYMB :rgBCONS))
      (BFSYMB   ; (BFSYMB <op> <lab>)
       (:brf2 :rgBSYMB :rgBCONS))
      (BTVAR    ; (BTVAR <op> <lab>)
       (:brt2 :rgBVAR :rgBCONS))
      (BFVAR    ; (BFVAR <op> <lab>)
       (:brf2 :rgBVAR :rgBCONS))
      (CABEQ    ; (CABEQ <op1> <op2> <lab>)
       (:BEQ (:load-aux :arg1 :rgAUX0)
	     (:load-aux :arg2 :rgAUX1)
	     (:op-depl :arg3))
       (:NOP))
      (CABNE    ; (CABNE <op1> <op2> <lab>)
       (:BNE (:load-aux :arg1 :rgAUX0)
	     (:load-aux :arg2 :rgAUX1)
	     (:op-depl :arg3))
       (:NOP))
      ;
      ;  Les autres instructions (par ordre alpha)
      ;
      (ADJSTK	; (ADJSTK 'nb)
       (if (:fixp :arg1)
	   (:ADDIU :rgSP :rgSP (mul 4 (cadr :arg1)))
	   (:load-reg :arg1 :rgAUX0)
	   (:SLL :rgAUX0 :rgAUX0 2)
	   (:ADDU :rgSP :rgSP :rgAUX0)))
      (CAR	; (CAR A1/A2/A3/A4)  ==  MOV 0(Ax),Ax   ?!?!? obsolete
       (:ins `(MOV (CAR ,:arg1) ,:arg1)))
      (CDR	; (CDR A1/A2/A3/A4)  ==  MOV 4(Ax),Ax   ?!?!? obsolete
       (:ins `(MOV (CDR ,:arg1) ,:arg1)))
      (HBMOVX	; (HBMOVX <val> <string> <index>)  val -> string[index]
       (:adrind-aux0 :arg2)
       (let ((src (:load-aux :arg1 :rgAUX2)))
	 (if (and (:fixp :arg3) (lt (cadr :arg3) #$7FF8))
	     (:SB src (add 8 (cadr :arg3)) :rgAUX0)
	     (let ((ind (:load-aux :arg3 :rgAUX1)))
	       (:ADDU :rgAUX0 :rgAUX0 ind)
	       (:SB src 8 :rgAUX0)))))
      (HBXMOV	; (HBXMOV <string> <index> <dest>) string[index] -> dest
       (:adrind-aux0 :arg1)
       (let ((dest (if (:accu :arg3) (:a2r :arg3) :rgAUX2)))
	 (if (and (:fixp :arg2) (lt (cadr :arg2) #$7FF8))
	     (:LBU dest (add 8 (cadr :arg2)) :rgAUX0)
	     (let ((ind (:load-aux :arg2 :rgAUX1)))
	       (:ADDU :rgAUX0 :rgAUX0 ind)
	       (:LBU dest 8 :rgAUX0)))
	 (:NOP)
	 (if (eq dest :rgAUX2) (:store-reg :rgAUX2 :arg3))))
      (HGSIZE	; (HGSIZE <vector/string> <dest>)
       (:adrind-aux0 :arg1)
       (let ((dest (if (:accu :arg2) (:a2r :arg2) :rgAUX0)))
	 (:LW dest 4 :rgAUX0)
	 (:NOP)
	 (if (eq dest :rgAUX0) (:store-reg :rgAUX0 :arg2))))
      (HPMOVX	; (HPMOVX <val> <vector> <index>)  val -> vector[index]
       (:adrind-aux0 :arg2)
       (let ((src (:load-aux :arg1 :rgAUX2)))
	 (if (and (:fixp :arg3) (lt (cadr :arg3) #.(- #$2000 2)))
	     (:SW src (add 8 (mul 4 (cadr :arg3))) :rgAUX0)
	     (:load-reg :arg3 :rgAUX1)
	     (:SLL :rgAUX1 :rgAUX1 2)
	     (:ADDU :rgAUX0 :rgAUX0 :rgAUX1)
	     (:SW src 8 :rgAUX0))))
      (HPXMOV	; (HPXMOV <vector> <index> <dest>) vector[index] -> dest
       (:adrind-aux0 :arg1)
       (let ((dest (if (:accu :arg3) (:a2r :arg3) :rgAUX2)))
	 (if (and (:fixp :arg2) (lt (cadr :arg2) #(- #$2000 2)))
	     (:LW dest (add 8 (mul 4 (cadr :arg2))) :rgAUX0)
	     (:load-reg :arg2 :rgAUX1)
	     (:SLL :rgAUX1 :rgAUX1 2)
	     (:ADDU :rgAUX0 :rgAUX0 :rgAUX1)
	     (:LW dest 8 :rgAUX0))
	 (:NOP)
	 (if (eq dest :rgAUX2) (:store-reg :rgAUX2 :arg3))))
      (MOVXSP	; (MOVXSP <val> <depl>)
       (let ((src (:load-aux :arg1 :rgAUX0)))
	 (if (and (:fixp :arg2) (lt (cadr :arg2) #$2000))
	     (:SW src (mul 4 (cadr :arg2)) :rgSP)
	     (:load-reg :arg2 :rgAUX1)
	     (:SLL :rgAUX1 :rgAUX1 2)
	     (:ADDU :rgAUX1 :rgAUX1 :rgSP)
	     (:SW src 0 :rgAUX1))))
      (XSPMOV	; (XSPMOV <depl> <val>)
       (let ((dest (if (:accu :arg2) (:a2r :arg2) :rgAUX0)))
	 (if (and (:fixp :arg1) (lt (cadr :arg1) #$2000))
	     (:LW dest (mul 4 (cadr :arg1)) :rgSP)
	     (:load-reg :arg1 :rgAUX1)
	     (:SLL :rgAUX1 :rgAUX1 2)
	     (:ADDU :rgAUX1 :rgAUX1 :rgSP)
	     (:LW dest 0 :rgAUX1))
	 (:NOP)
	 (if (eq dest :rgAUX0) (:store-reg :rgAUX0 :arg2))))
      (NOP	; (NOP) ne fait rien mais perd du temps et de la place
       (:NOP))
      (XTOPST	; (XTOPST <op>)
       (:LW :rgAUX0 0 :rgSP)
       (:NOP)
       (:SW (:load-aux :arg1 :rgAUX1) 0 :rgSP)
       (:store-reg :rgAUX0 :arg1))
      ;
      ;  Les comparaisons arithme'tiques entieres.
      ;
      (CNBEQ    ; (CNBEQ <op1> <op2> <lab>)
       (:load-fix :arg1 :rgAUX0)
       (:load-fix :arg2 :rgAUX1)
       (:BEQ :rgAUX0 :rgAUX1 (:op-depl :arg3))
       (:NOP))
      (CNBNE    ; (CNBNE <op1> <op2> <lab>)
       (:load-fix :arg1 :rgAUX0)
       (:load-fix :arg2 :rgAUX1)
       (:BNE :rgAUX0 :rgAUX1 (:op-depl :arg3))
       (:NOP))
      (CNBLE    ; (CNBLE <op1> <op2> <lab>)
       (:load-fix :arg1 :rgAUX0)
       (:load-fix :arg2 :rgAUX1)
       (:BLE :rgAUX0 :rgAUX1 :arg3)
       (:NOP))
      (CNBLT    ; (CNBLT <op1> <op2> <lab>)
       (:load-fix :arg1 :rgAUX0)
       (:load-fix :arg2 :rgAUX1)
       (:BLT :rgAUX0 :rgAUX1 :arg3)
       (:NOP))
      (CNBGE    ; (CNBGE <op1> <op2> <lab>)
       (:load-fix :arg1 :rgAUX0)
       (:load-fix :arg2 :rgAUX1)
       (:BGE :rgAUX0 :rgAUX1 :arg3)
       (:NOP))
      (CNBGT    ; (CNBGT <op1> <op2> <lab>)
       (:load-fix :arg1 :rgAUX0)
       (:load-fix :arg2 :rgAUX1)
       (:BGT :rgAUX0 :rgAUX1 :arg3)
       (:NOP))
      ;
      ;  Les comparaisons arithme'tiques flottantes.
      ;
      (CFBEQ    ; (CFBEQ <op1> <op2> <lab>)
       (:generatecall2subr '#:llcp:feqn :arg3))
      (CFBNE    ; (CFBNE <op1> <op2> <lab>)
       (:generatecall2subr '#:llcp:fneqn :arg3))
      (CFBLE    ; (CFBLE <op1> <op2> <lab>)
       (:generatecall2subr '#:llcp:fle :arg3))
      (CFBLT    ; (CFBLT <op1> <op2> <lab>)
       (:generatecall2subr '#:llcp:flt :arg3))
      (CFBGE    ; (CFBGE <op1> <op2> <lab>)
       (:generatecall2subr '#:llcp:fge :arg3))
      (CFBGT    ; (CFBGT <op1> <op2> <lab>)
       (:generatecall2subr '#:llcp:fgt :arg3))
      ;
      ;  Les instructions arithme'tiques
      ;
      (NEGATE	; (NEGATE <op>)
       (:load-reg :arg1 :rgAUX0)
       (:SUBU :rgAUX0 :rgZ :rgAUX0)
       (:store-fix :rgAUX0 :arg1))
      (DECR	; (DECR <op>)
       (:ADDIU :rgAUX0 (:load-aux :arg1 :rgAUX0) -1)
       (:store-fix :rgAUX0 :arg1))
      (INCR	; (INCR <op>)
       (:ADDIU :rgAUX0 (:load-aux :arg1 :rgAUX0) 1)
       (:store-fix :rgAUX0 :arg1))
      (PLUS	; (PLUS <op1> <op2>)
       (:ADDU :rgAUX0 (:load-aux :arg2 :rgAUX0) (:load-aux :arg1 :rgAUX1))
       (:store-fix :rgAUX0 :arg2))
      (DIFF	; (DIFF <op1> <op2>)
       (:SUBU :rgAUX0 (:load-aux :arg2 :rgAUX0) (:load-aux :arg1 :rgAUX1))
       (:store-fix :rgAUX0 :arg2))
      (TIMES	; (TIMES <op1> <op2>)
       (:MULTU (:load-aux :arg2 :rgAUX0) (:load-aux :arg1 :rgAUX1))
       (:NOP) (:NOP)
       (:MFLO :rgAUX0)
       (:store-fix :rgAUX0 :arg2)
       (:NOP))
      (QUO	; (QUO <op1> <op2>)
       (:load-fix :arg2 :rgAUX0)
       (:load-fix :arg1 :rgAUX1)
       (:DIV :rgAUX0 :rgAUX1)
       (:NOP) (:NOP)
       (:MFLO :rgAUX0)
       (:store-fix :rgAUX0 :arg2)
       (:NOP))
      (REM	; (REM <op1> <op2>)
       (:load-fix :arg2 :rgAUX0)
       (:load-fix :arg1 :rgAUX1)
       (:DIV :rgAUX0 :rgAUX1)
       (:NOP) (:NOP)
       (:MFHI :rgAUX0)
       (:store-fix :rgAUX0 :arg2)
       (:NOP))
      (LAND	; (LAND <op1> <op2>)
       (let ((dest (:load-aux :arg2 :rgAUX0)))
	 (if (:fixp :arg1)
	     (:ANDI dest dest (cadr :arg1))
	     (:AND dest dest (:load-aux :arg1 :rgAUX1)))
	 (if (eq dest :rgAUX0) (:store-reg :rgAUX0 :arg2))))
      (LOR	; (LOR <op1> <op2>)
       (let ((dest (:load-aux :arg2 :rgAUX0)))
	 (if (:fixp :arg1)
	     (:ORI dest dest (cadr :arg1))
	     (:OR dest dest (:load-aux :arg1 :rgAUX1)))
	 (if (eq dest :rgAUX0) (:store-reg :rgAUX0 :arg2))))
      (LXOR	; (LXOR <op1> <op2>)
       (let ((dest (:load-aux :arg2 :rgAUX0)))
	 (if (:fixp :arg1)
	     (:XORI dest dest (cadr :arg1))
	     (:XOR dest dest (:load-aux :arg1 :rgAUX1)))
	 (if (eq dest :rgAUX0) (:store-reg :rgAUX0 :arg2))))
      (LSHIFT	; (LSHIFT <op1> <op2>)
       (:load-reg :arg2 :rgAUX0)
       (cond
	 ((and (:fixp :arg1) (or (gt (cadr :arg1) 15) (lt (cadr :arg1) -15)))
	  (:MOVE :rgAUX0 :rgZ))
	 ((and (:fixp :arg1) (ge (cadr :arg1) 0))
	  (:SLL :rgAUX0 :rgAUX0 (cadr :arg1)))
	 ((:fixp :arg1)
	  (:SRL :rgAUX0 :rgAUX0 (sub 0 (cadr :arg1))))
	 (t
	  (:load-fix :arg1 :rgAUX1)
	  (:BGEZ :rgAUX1 5)
	  (:NOP)
	  (:SUBU :rgAUX1 :rgZ :rgAUX1)
	  (:SRLV :rgAUX0 :rgAUX0 :rgAUX1)
	  (:BEQ :rgZ :rgZ 2)
	  (:NOP)
	  (:SLLV :rgAUX0 :rgAUX0 :rgAUX1)))
       (:store-fix :rgAUX0 :arg2))
      ;
      ;  Les instructions arithme'tiques flottantes
      ;
      (FPLUS  (:generatecall2subr '#:llcp:fadd ()))
      (FDIFF  (:generatecall2subr '#:llcp:fsub ()))
      (FTIMES (:generatecall2subr '#:llcp:fmul ()))
      (FQUO   (:generatecall2subr '#:llcp:fdiv ()))
      ;
      ; c'est donc une erreur
      ;
      (t (if (setq :f (getfn1 'ld-codop (car obj)))
             (apply :f obj)
             (:error "MACHINS" obj)))))

; .Section "Les fonctions auxiliaires de ge'ne'ration"

(dmd :accu (arg) `(memq ,arg '(A1 A2 A3 A4)))

(de :fixp (arg)
    ; Teste si l'ope'rande est un entier (ou pluto^t "(QUOTE entier)")
    ; attention a` la triple e'valuation ...
    (and (consp arg) (eq (car arg) 'QUOTE) (fixp (cadr arg))))

(de :load-aux (src aux)
   ; charge src dans aux s'il le faut
   (selectq src
      (A1 :rgS0) (A2 :rgS1) (A3 :rgS2) (A4 :rgS3)
      (t (:load-reg src aux) aux)))

(de :adrind-aux0 (arg)
    ; charge dans AUX0 l'adresse indirecte de arg
    (let ((inter (:load-aux arg :rgAUX0)))
      (:LW :rgAUX0 0 inter))
    (:NOP))

(de :brt2 (b1 b2)
    ; test true a deux bornes
    (let ((op (:load-aux :arg1 :rgAUX0)))
      (:SLTU :rgAT op b1)
      (:BNE :rgAT :rgZ 2)
      (:BLTU op b2 :arg2))
    (:NOP))

(de :brf2 (b1 b2)
    ; test faux a deux bornes
    (let ((op (:load-aux :arg1 :rgAUX0)))
      (:BLTU op b1 :arg2)
      (:BGEU op b2 :arg2))
    (:NOP))

(de :load-fix (src dest)
    ; charge un entier
    (if (:fixp src)
	(if (ge (cadr src) 0)
	    (:ORI dest :rgZ (cadr src))
	    (:ADDI dest :rgZ (cadr src)))
        (:load-reg src dest)
	(:SLL dest dest 16)
	(:SRA dest dest 16)))

(de :store-fix (src dest)
    ; range un entier
    (if (:accu dest)
	(:ANDI (:a2r dest) src -1)
        (:ANDI src src -1)
	(:store-reg src dest)))

(de :generatecall2subr (fnt lab)
   ; engendre un appel a` la fonction #:llcp:"fnt" avec les arguments
   ; :arg1 :arg2, i.e.  :arg2 op :arg1 -> :arg2.
   ; Avec une pile de la forme suivante : ... / :arg2 / adr-ret / :arg1 //
   ; La valeur de retour remplace :arg2, adr-ret et :arg1 sont de'pile's.
   ; Si <lab> est pre'sent, branchement a` <lab> si la valeur retourne'e
   ; par la fonction est = a` 0, sinon si <lab> = (), chargement de la
   ; valeur de tretour dans :arg2.
   (let ((arg1 (:load-aux :arg1 :rgAUX0))
	 (arg2 (:load-aux :arg2 :rgAUX1))
	 (pc (incradr (copylist :PCcurrent) 40)))
     (:ADDIU :rgSP :rgSP -12)
     (:SW arg2 8 :rgSP)
     (:LUI :rgAT (car pc))
     (:ORI :rgAT :rgAT (cdr pc))
     (:SW :rgAT 4 :rgSP)
     (let ((adr (:op-symb fnt)))
       (cond
	 ((fixp adr)
	  (:LW :rgAUX2 (add 8 adr) :rgNIL)
	  (:NOP))
	 (t
	  (:adjust adr)
	  (:LUI :rgAT (car adr))
	  (:LW :rgAUX2 (add 8 (cdr adr)) :rgAT))))
     (:SW arg1 0 :rgSP)
     (:JR :rgAUX2)
     (:NOP)
     (:LW :rgAUX0 0 :rgSP)
     (:ADDIU :rgSP :rgSP 4)
     (ifn lab
	  (:store-reg :rgAUX0 :arg2)
	  (:BNE :rgAUX0 :rgZ (:op-depl lab))
	  (:NOP))))

; .Section "Load Register"

(de :load-reg (src dest)
   ; charge l'ope'rande source <src> dans le registre dest
   (cond
     ((eq src 'nil)
         ; ope'rande nil (en fait ||)
      (:MOVE dest :rgNIL))
     ((eq src 'A1)
         ; accu Le-Lisp
      (:MOVE dest :rgS0))
     ((eq src 'A2)
         ; accu Le-Lisp
      (:MOVE dest :rgS1))
     ((eq src 'A3)
         ; accu Le-Lisp
      (:MOVE dest :rgS2))
     ((eq src 'A4)
         ; accu Le-Lisp
      (:MOVE dest :rgS3))
     ((memq src '(BP TP LLINK DLINK ITCOUNT))
      (let ((adr (copylist (symeval (symbol 'llcp src)))))
	(:adjust adr)
	(:LUI :rgAT (car adr))
	(:LW dest (cdr adr) :rgAT))
      (:NOP))
     ((memq src '(CBINDN TAG LOCK PROT))
      (let ((adr (symeval (symbol 'llcp src))))
	(:LUI :rgAT (car adr))
	(:ORI dest :rgAT (cdr adr))))
     ((atomp src)
         ; ne doit jamais arriver pour le compilo
         ; sauf en cas de nouvelles de'finitions.
      (if (and (symbolp src)
	       (setq :f (getfn1 'load-reg src)))
	  (funcall :f src dest)
          (:error "LOAD-REG" src)))
     ((eq (car src) 'quote)
         ; une constante lisp imme'diate
      (cond
        ((and (null (cadr src)) (null (cddr src)))
	  ; c'est en fait l'ope'rande nil (ou ||)
	 (:MOVE dest :rgNIL))
	((fixp (cadr src))
	 (:LI dest (cadr src)))
	(t
	 (cond
	    ((stringp (cadr src)) (:add-llitts src))
	    ((and :31BITFLOATS (floatp (cadr src))))
	    (t (:add-llitt (cadr src))))
	 (let ((adr (loc (cadr src))))
	   (:LUI :rgAT (car adr))
	   (:ORI dest :rgAT (cdr adr))))))
     ((eq (car src) '@)
         ; une constante adresse me'moire code machine
         ; <lab> est touours une e'tiquette locale
      (let ((adr (:op-adr (cadr src) 2)))
	(:LUI :rgAT (car adr))
	(:ORI dest :rgAT (cdr adr))))
     ((eq (car src) '&)
      (if (fixp (cadr src))
         ; (& <n>) Le nie`me pointeur de la pile
	  (:LW dest (mul 4 (cadr src)) :rgSP)
         ; (& BP <n>) Index par rapport au Block Pointer
	  (let ((adr (copylist (symeval (symbol 'llcp (cadr src))))))
	    (:adjust adr)
	    (:LUI :rgAT (car adr))
	    (:LW :rgAUX3 (cdr adr) :rgAT)
	    (:NOP)
	    ; les deplacements sont inferieurs a $4000
	    (:LW dest (mul 4 (caddr src)) :rgAUX3)))
      (:NOP))
     ((memq (car src)
	    '(CAR VAL CVAL CDR PLIST FVAL PKGC OVAL ALINK PNAME TYP))
         ; adressage indirect indexe'
      (:LW dest
	   (selectq (car src)
	      ((CAR VAL CVAL) 0)
	      ((CDR TYP PLIST) 4)
	      (FVAL 8)
	      (PKGC 12)
	      (OVAL 16)
	      (ALINK 20)
	      (PNAME 28)
	      (t (:error "LOAD-REG" src)))
	   (:a2r (cadr src)))
      (:NOP))
     ((eq (car src) 'CVALQ)
         ; la C-valeur Lisp d'un symbole
      (let ((symb (cadr src)))
	(ifn (symbolp symb) (:error "LOAD-REG" src))
	(let ((adr (:op-symb symb)))
	  (if (fixp adr)
	      (:LW dest adr :rgNIL)
	      (:adjust adr)
	      (:LUI :rgAT (car adr))
	      (:LW dest (cdr adr) :rgAT))))
      (:NOP))
     ((eq (car src) 'FVALQ)
         ; la F-valeur Lisp d'un symbole
      (let ((symb (cadr src)))
	(ifn (symbolp symb) (:error "LOAD-REG" src))
	(let ((adr (:op-symb symb)))
	  (if (fixp adr)
	      (:LW dest (add 8 adr) :rgNIL)
	      (:adjust adr)
	      (:LUI :rgAT (car adr))
	      (:LW dest (add 8 (cdr adr)) :rgAT))))
      (:NOP))
     ((eq (car src) 'EVAL)
         ; Pour calculer des ope'randes a` load time.
      (or (car (catcherror t (:load-reg (eval (cadr src)) dest)))
	  (:error "LOAD-REG" src)))
     (t (if (and (symbolp (car src))
		 (setq :f (getfn1 'load-reg (car src))))
	    (funcall :f src dest)
	    (:error "LOAD-REG" src)))))

(de :store-reg (src dest)
   ; charge l'ope'rande destination <dest> a partir du registre src
   (cond
     ((eq dest 'A1)
         ; accu Le-Lisp
      (:MOVE :rgS0 src))
     ((eq dest 'A2)
         ; accu Le-Lisp
      (:MOVE :rgS1 src))
     ((eq dest 'A3)
         ; accu Le-Lisp
      (:MOVE :rgS2 src))
     ((eq dest 'A4)
         ; accu Le-Lisp
      (:MOVE :rgS3 src))
     ((memq dest '(BP TP LLINK DLINK ITCOUNT))
      (let ((adr (copylist (symeval (symbol 'llcp dest)))))
	(:adjust adr)
	(:LUI :rgAT (car adr))
	(:SW src (cdr adr) :rgAT)))
     ((atom dest)
         ; ne doit jamais arriver pour le compilo
         ; sauf en cas de nouvelles de'finitions.
      (if (and (symbolp dest)
               (setq :f (getfn1 'store-reg dest)))
          (funcall :f src dest)
          (:error "STORE-REG" dest)))
     ((eq (car dest) '&)
      (if (fixp (cadr dest))
         ; (& <n>) Le nie`me pointeur de la pile
	  (:SW src (mul 4 (cadr dest)) :rgSP)
         ; (& BP <n>) Index par rapport au Block Pointer
	  (let ((adr (copylist (symeval (symbol 'llcp (cadr dest))))))
	    (:adjust adr)
	    (:LUI :rgAT (car adr))
	    (:LW :rgAUX3 (cdr adr) :rgAT)
	    (:NOP)
	    ; les deplacements sont inferieurs a $4000
	    (:SW src (mul 4 (caddr dest)) :rgAUX3))))
     ((memq (car dest)
	    '(CAR VAL CVAL CDR PLIST FVAL PKGC OVAL ALINK PNAME TYP))
         ; adressage indirect indexe'
      (:SW src
	   (selectq (car dest)
	      ((CAR VAL CVAL) 0)
	      ((CDR TYP PLIST) 4)
	      (FVAL 8)
	      (PKGC 12)
	      (OVAL 16)
	      (ALINK 20)
	      (PNAME 28)
	      (t (:error "LOAD-REG" src)))
	   (:a2r (cadr dest))))
     ((eq (car dest) 'CVALQ)
         ; la C-valeur Lisp d'un symbole
      (let ((symb (cadr dest)))
	(ifn (symbolp symb) (:error "LOAD-REG" dest))
	(let ((adr (:op-symb symb)))
	  (if (fixp adr)
	      (:SW src adr :rgNIL)
	      (:adjust adr)
	      (:LUI :rgAT (car adr))
	      (:SW src (cdr adr) :rgAT)))))
     ((eq (car dest) 'FVALQ)
         ; la F-valeur Lisp d'un symbole
      (let ((symb (cadr dest)))
	(ifn (symbolp symb) (:error "LOAD-REG" dest))
	(let ((adr (:op-symb symb)))
	  (if (fixp adr)
	      (:SW src (add 8 adr) :rgNIL)
	      (:adjust adr)
	      (:LUI :rgAT (car adr))
	      (:SW src (add 8 (cdr adr)) :rgAT)))))
     ((eq (car dest) 'EVAL)
         ; Pour calculer des ope'randes a` load time.
      (or (car (catcherror t (:store-reg src (eval (cadr dest)))))
	  (:error "STORE-REG" dest)))
     (t (if (and (symbolp (car dest))
		 (setq :f (getfn1 'store-reg (car dest))))
	    (funcall :f src dest)
            (:error "STORE-REG" dest)))))

; .Section "Gestion des e'tiquettes"

; .SSection "Calcul de la valeur d'une e'tiquette qui existe"

(de :r2shift (adr)
    (let ((high (logshift (car adr) -2))(low (logshift (cdr adr) -2)))
      (rplac adr high
	     (logor low
		    (selectq (logand (car adr) 3)
		       (0 0) (1 #$4000) (2 #$8000) (3 #$C000))))))

(de :valadr (adr)
    ; calcule la valeur d'une adresse, locale a` un module, de type :
    ; symbole, numb ou constante de type (nh . nl)
    ; retourne une adresse (h . l) ou bien () si non de'finie
    (cond
       ((atom adr)
          ; e'tiquette symbolique ou nume'rique
          (cond ((cassq adr :llabels))
                 ; e'tiquette locale re'solue
                ((and (symbolp adr) (getprop adr ':fval)))
                 ; les fonctions ENTRY de'ja` charge'es (avant END!)
                (t ; sinon non de'finie
                   ())))
       (t ; les constantes adresses de type (h . l)
          (if (and (fixp (car adr)) (fixp (cdr adr)))
              adr
              (:error "VALADR" adr)))))

(de :valadrel (adr)
    ; retourne un de'placement par rapport a` PC+4 shifte' ou ()
    (let ((adr (:valadr adr))(pc (copylist :PCcurrent)))
      (when adr
	    (setq adr (copylist adr))
	    (:r2shift adr)
	    (:r2shift pc)
	    (subadr (subadr adr pc) 1))))

; .SSection "Branchement"

(de :op-depl (lab)
    ; renvoie le deplacement vers <lab>
    (setq :valaux (:valadrel lab))
    (cond
      ((fixp :valaux) :valaux)
      ((consp :valaux) (:error "Module top gros" :module))
      (t
       ; en avant
       (if (and (symbolp lab) (null (assq lab :llabels)))
           ; dans les ENTRY
	   (:addentry lab 18)
           ; dans les LOCAL
           (:addlabel lab 18))
       0)))

; .SSection "Immediats 32 bits"

(de :op-adr (lab mode)
    ; renvoie l'adresse de <lab>
    (setq :valaux (:valadr lab))
    (cond
      ((consp :valaux) :valaux)
      ((fixp :valaux) (:error "OP-ADR" lab))
      (t
       ; en avant
       (if (and (symbolp lab) (null (assq lab :llabels)))
	   ; dans les ENTRY
	   (:addentry lab mode)
	   ; dans les LOCAL
	   (:addlabel lab mode))
       '(0 . 0))))

; .SSection "Ope'rande de type adresse de symbole Lisp"

(de :op-symb (symb)
    ; un ope'rande de type "adresse de symbole"
    ; <symb> est toujours de type symbole.
    (:add-llitt symb)
    (let ((sloc (loc symb)))
      (setq :valaux (subadr sloc :locnil))
      (cond
        ((and (fixp :valaux) (ge :valaux 0)) :valaux)
	((consp sloc) sloc)
	(t (cons 0 sloc)))))

; .Section "Le chargement me'moire"

(de :1half (val)
    ; charge les 16 bits de val
    (when :talkp
          (when (gt :nwl 10)
                (setq :nwl 0)
                (terpri)
                (outpos 30)
                (:prinhex :PCcurrent)
                (prin "  "))
          (incr :nwl)
          (prin " ")
          (:prinhex val))
    (memory :PCcurrent val)
    (incradr :PCcurrent 2))

(de :1half-relPC (where)
    ; charge a <where>
    (setq :valaux (:valadrel where))
#+ #:ld:bigendian
    (setq where (incradr (copylist where) 2))
    (memory where (sub -2 :valaux)))

(de :1word (val)
    ; charge 1 mot de 32 bits
#+ #:ld:bigendian
    (cond
      ((fixp val) (:1half 0) (:1half val))
      ((consp val) (:1half (car val)) (:1half (cdr val)))
      (t (:error "1WORD" val)))
#- #:ld:bigendian
    (cond
      ((fixp val) (:1half val) (:1half 0))
      ((consp val) (:1half (cdr val)) (:1half (car val)))
      (t (:error "1WORD" val))))

(de :1word-PC (where)
    ; charge 1 mot de 32 bits a <where>
    (let ((adr (copylist where)))
#+ #:ld:bigendian
      (memory adr (car :PCcurrent))
#- #:ld:bigendian
      (memory adr (cdr :PCcurrent))
      (incradr adr 2)
#+ #:ld:bigendian
      (memory adr (cdr :PCcurrent))
#- #:ld:bigendian
      (memory adr (car :PCcurrent))))

(de :2half-PC (where)
#+ #:ld:bigendian
    ; charge 2 fois 16 bits a <where>+2 et <where>+6
    (let ((adr (copylist where)))
      (incradr adr 2)
      (memory adr (car :PCcurrent))
      (incradr adr 4)
      (memory adr (cdr :PCcurrent)))
#- #:ld:bigendian
    ; charge 2 fois 16 bits a <where> et <where>+4
    (let ((adr (copylist where)))
      (memory adr (car :PCcurrent))
      (incradr adr 4)
      (memory adr (cdr :PCcurrent))))

; .Section "Fonctions de gestion des tables d'e'tiquettes"

(de :addlabel (sym depl)
    ; rajoute le symbole <sym> dans la table des re'fe'rences avants
    ; locales non re'solues a` l'adresse PCcurrent.
    (setq :valaux (assq sym :llabels-nr))
    (setq depl (cons depl (copylist :PCcurrent)))
    (if :valaux
        (rplacd :valaux (cons depl (cdr :valaux)))
        (newl :llabels-nr (list sym depl))))

(de :addentry (sym depl)
    ; rajoute le symbole <sym> une dans la table des re'fe'rences avants
    ; des ENTRY non re'solus a` l'adresse du PCcurrent.
    (setq :valaux (assq sym :entries-not-resolved))
    (setq depl (cons depl (copylist :PCcurrent)))
    (if :valaux
        (rplacd :valaux (cons depl (cdr :valaux)))
        (newl :entries-not-resolved (list sym depl))))

; .Section "Gestion de la table des litte'raux"

(de  :clean-llitt ()
     ; nettoie et sauve la table des litte'raux :saved-by-loader
     ; dans :global-saved-by-loader sous forme d'un vecteur si
     ; si il n'y a pas eu de TITLE dans :module sinon.
     ; ne doit e^tre fait qu'au END.
     (let ((l :saved-by-loader)
           (i -1)
           v)
          (while l
                 (if (and (symbolp (car l))
                          (or (boundp (car l))
                              (typefn (car l))))
                     (setq :saved-by-loader
                           (delq (nextl l) :saved-by-loader))
                    (nextl l)))
         (when (gt (length :saved-by-loader) 0)
                  (setq v (makevector (length :saved-by-loader) ()))
                  (while :saved-by-loader
                         (vset v (setq i (add i 1)) (nextl :saved-by-loader)))
                  (if :module
                      (putprop :module v ':saved-by-loader)
                      (newl :global-saved-by-loader v)))
         (setq :module ()) ))

(de :add-llitt (obj)
    ; rajoute un litte'ral a` la table des litte'raux :saved-by-loader
    (cond ((memq obj :saved-by-loader))
          (t (newl :saved-by-loader obj))))

(de :add-llitts (obj)
    ; rajoute une chai^ne de caracte`res a` la table des litte'raux
    ; en essayant de partager les chai^nes.
    ; ?!?!?! Cette ide'e d'Ascander est toujours en discussion ?!?!?
    (let ((s (and #:ld:shared-strings (member (cadr obj) :saved-by-loader))))
         (ifn s
              (newl :saved-by-loader (cadr obj))
              (rplaca (cdr obj) (car s)))))

; .Section "Fonction d'impression hexa"

(de :prinhex (n)
    ; imprime sur 4 ou 8 chiffres hexa le nb ou l'adresse n
    (cond ((fixp n)
           (:prinhexb (logand (logshift n -8) #$FF))
           (:prinhexb (logand n #$FF)))
          ((consp n)
           (:prinhex (car n))
           (:prinhex (cdr n)))
          (t (error ':prinhex 'errnna n))))

(de :prinhexb (n)
    ; imprime sur 2 chiffres hexa le nb n
    (cond ((not (fixp n)) (error ':prinhexb 'errnna n))
          ((lt n 0) (setq n #$FF))
          ((lt n 16) (princn #/0)))
    (with ((obase 16)) (prin n)))

(de memory-dump (adr n)
    ; dump la memoire en hexa de <adr> sur <n> mots
    (until (<= n 0)
           (:prinhex adr)
           (outpos 10)
           (let ((adr (copylist adr)))
                (repeat 8 (:prinhex (memory adr))
                          (prin " ")
                          (incradr adr 2)))
           (decr n)
           (terpri)))

; .Section "Fonction auxiliaire d'erreur"

(de :error (f a)
    ; erreur dans la fonction <f> arguments defectueux <a>
    (terpri)
    (print "***** LOADER : erreur durant le chargement de : " :fntname)
    (print "      type de l'erreur     : " f)
    (print "      arguments de'fecteux : " a)
    (exit :tagerr))

; .Section "Fonctions principales de chargement"

(de loaderesolve () (loader '((end))))

(de loader (:lobj . :talkp)
    ; <:lobj> est la liste des objets a` charger
    ; <:talkp> = T si on de'sire un listage hexa du chargement
    (when (consp :talkp) ; l'argument est optionnel!
          (setq :talkp (car :talkp)))
    (let ((:PCcurrent (#:system:ccode)) ; le compteur ordinal courant
          (:llabels)            ; AL des e'tiquette locales
          (:llabels-nr)         ; AL des e'tiquettes locales non re'solues
          (:fntname 'loader)    ; fonction ou` on charge les litte'raux
          :codop                ; variable globale   opcode symbolique
          :arg1                 ;    itou
          :arg2                 ;    itou
          :arg3                 ;    itou
          :valaux               ;    itou pour des valeurs locales.
          :f                    ;    itou (pour des getfn1)
          (:nwl 0)              ;    itou pour tabler le code produit.
                                ; CAML (****
          :local-cons-llitt
          :mlconstants          ;    modification pour CAML ****)
          )
      ; le re'cupe'rateur d'erreur syste`me
; CAML (****
;      (catcherror t
;                  ; le re'cupe'rateur des erreurs du chargeur
;                  (tag :tagerr
; CAML)) ****)
                       ; #:system:ccode ne sera actualise'
                       ; que si tout se passe bien sans erreur
                       (while :lobj
                           (when (gtadr :PCcurrent :Ecode)
                                 (with ((outchan ()))
                                       (print ERRFCOD)
                                       (exit #:system:toplevel-tag)))
                           (setq :nwl 0)   ; sert pour tabler le code produit
                           (:ins (nextl :lobj))
                           (when :talkp (terpri)))
                       ; test des re'fe'rences non re'solues
                       (:ins '(ENDL))
; CAML ((****
;)
;  CAML ****)
                       ; flush le cache d'instruction
                       (icacheflush (#:system:ccode) :PCcurrent)
                       ; actualise le nouveau de'but de la zone code
                       (#:system:ccode :PCcurrent)
; CAML ((****
;)
                  ; actualise #:ld:cons-llitt
                  (setq #:ld:cons-llitt
                        (nconc :local-cons-llitt #:ld:cons-llitt))
;  CAML ****)
       ()))

; .Section "Bootstrap"

(when (neq (typefn '#:llcp:nlist) 'subr0)
      ; Les fonctions internes du compilateur
      (loader '(
            (fentry #:llcp:nlist subr0)
            (pop a3)
            (mov nil a1)
            (bra 4)
         3  (pop a2)
            (jcall xcons)
         4  (sobgez a4 3)
            (bri a3)
            (fentry #:llcp:errwna subr2)    ; A1 <- fnt; A2 <- bad-nb-arg
            (mov a2 a3)
            (mov 'errwna a2)
            (jmp error)
	    (end))
	 ()))

(when (neq (typefn 'icacheflush) 'subr2)
      ; le flush du cache du NEWS
      (loader '(
          (fentry icacheflush subr2)
          (entry icacheflush subr2)
          (push a2)
          (push (@ 100))
          (push (eval (kwote (getglobal 'icacheflush))))
          (push '1)
          (jcall vag)
          (push a1)
          (push '0)
          (mov (& 5) a1)
          (jcall vag)
          (push a1)
          (push '0)
          (mov '6 a4)
          (jmp callextern)
      100 (adjstk '1)
          (return)
          (end))
       ()))

;;; After loading the compiled version of the loader, we must remove
;;; the expr definitions of all the internal functions.

;;; However, if special-case-loader is positioned, we must ensure that
;;; the loading of this module is completed first.

(loader '((end)))

(unless (or (eq (typefn 'loaderesolve) 'expr) (get 'loaderesolve 'resetfn))
   (mapc
      (lambda (m)
         (when (typefn m)
            (remfn m)
            (remprop m '#:system:loaded-from-file)))
      (oblist 'ldmips)))
