/* BigNum_internal.h - Types and structures internal to BigNum and BigZ */
 
#ifndef BIGNUM_INTERNAL_H
#define BIGNUM_INTERNAL_H
 
/*
 *	Description des types et constantes internes.
 */
/* Un nombre est un pointeur sur des UnitN a` la suite d'un ente^te de'crivant
 * le type et la taille du tableau.
 *  .------------------------------------------.......----------------------.
 *  |  typeN  | lenN=N  |  Unit0  |  Unit1  |           | UnitN-2 | UnitN-1 |
 *  `------------------------------------------.......----------------------'
 *  ^                   ^
 *  |                   |
 *  BigNumHeader        BigNum
 *                    
 */
 
/* The following declarations are internal to the BigNum package: */
typedef unsigned int 	BigNumProduct;	/* The product of two digits */
struct BigNumHeader { 			/* The header of a BigNum */
   BigNumType 	type;
   int		length;
};
#define BN_TYPE(n)	(((struct BigNumHeader *) n) - 1)->type
#define BN_LENGTH(n)	(((struct BigNumHeader *) n) - 1)->length
 
#endif BIGNUM_INTERNAL_H

