/* BigNum.h - Types and structures for clients of BigNum */
 
#ifndef BIGNUM_H
#define BIGNUM_H
 
#include "bignumtypes.h"
#ifdef C_VERSION

typedef unsigned short	BigNumDigit;	/* A single BigNum digit */
#else
typedef unsigned int 	BigNumDigit;	/* A single BigNum digit */
#endif 

typedef unsigned int 	BigNumType;	/* A BigNum's type */
typedef unsigned int	BigNumCarry;	/* Either 0 or 1 */
typedef BigNumDigit * 	BigNum;		/* The entity seen by the user */

#define BN_BYTE_SIZE	8	/* Number of bits in a byte */

#define BN_DIGIT_SIZE	(sizeof(BigNumDigit) * BN_BYTE_SIZE)
			/* Each word of a BigNum is stored as an 
		    	   unsigned BN_DIGIT_SIZE-bit integer */

#ifdef LL_VERSION
#define BN_WORD_SIZE    15
#else
#define BN_WORD_SIZE	(sizeof(int) * BN_BYTE_SIZE)
			/* BN_WORD_SIZE is the number of bits in an 
			   ordinary "int" in the target language */
#endif

/* Declarations of routines returning non-int's */
BigNum BnAlloc(), BnCreate();
BigNumType BnGetType();
Boolean BnDoesDigitFitInWord(), BnIsDigitZero(), BnIsDigitNormalized();
Boolean BnIsDigitOdd(), BnIsZero();
Sign BnCompareDigits(), BnCompare();
BigNumCarry BnAddCarry(), BnAdd(), BnSubtractBorrow(), BnSubtract();
BigNumCarry BnMultiplyDigit(), BnMultiply();
 
#endif BIGNUM_H
