/* ************************************************************************* */
/*                             FICHIER x11.h                                 */
/* ************************************************************************* */
/* Ce fichier contient la partie C de l'implemenation du Bitmap Virtuel      */
/* pour les stations de travail sous X-Windows version 11.                   */
/* il va de pair avec les fichiers x11.c et x11.ll                           */
/*                                                                           */
/* Auteur: Pierre DUQUESNOY (ILOG)                  Date:  25 Novembre 1988  */
/* ************************************************************************* */

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <X11/cursorfont.h>
#include <lelisp.h>
#include <stdio.h>
#include <sys/ioctl.h>

#define EMPTYSTRING "foo"
#define LELISP "lelisp"
#define MESSAGE1 "Bitprologue: can't open Display"
#define MESSAGE2 "Can't allocate point vector"
#define MESSAGE3 "Can't re-allocate point vector" 
#define MESSAGE4 "Can't associate the lisp window" 
#define BUFFERSIZE 100
#define HOSTSIZE 100
#define TWOPI 23040
#define NBPOINTS 256
#define BORDERWIDTH 1
#define BIGBORDERWIDTH 2
#define DISCARD 1
#define FLUSH 0
#define FUNKEYCODE 36
#define EVENTMASK StructureNotifyMask|ExposureMask
#define SUBWINDOWMASK CWEventMask
#define WINDOWMASK SUBWINDOWMASK|CWBackPixel|CWBorderPixel|CWCursor| \
	CWOverrideRedirect
#define FULLGCMASK GCGraphicsExposures
#define GCMASK FULLGCMASK|GCLineWidth|GCLineStyle|GCTile|GCFont|GCFunction| \
	GCPlaneMask|GCFillStyle|GCSubwindowMode|GCForeground|GCBackground
#define BUTTONS 3
#define BIT(i,mask) ((i & mask) ? 1 : 0)
#define BUTTON(i,j,k) (i ? 1 : (j ? 2 : (k ? 3 : 0)))
#define DETAIL(value,state) (value - 1 + BUTTONS * (BIT (state, ShiftMask) + BIT (state, ControlMask) * 2 + BIT (state, Mod1Mask) * 4 + BIT (state, Mod2Mask) * 8))
	
struct LLEvent {
	int code;
	int *window;
	int detail;
	int gx;
	int gy;
	int x;
	int y;
	int w;
	int h;
};

struct LLColor {
	int red; 
	int green;
	int blue;
};

struct LLDisplay {
	Display *display;
	unsigned long subeventmask;
	unsigned long eventmask;
	int override;
	int ForePixel;
	int BackPixel;
	int depth;
	Window root;
        Colormap colormap;
	XContext lispcontext;
	unsigned nbpoints;
	XPoint *points;
	XImage *setimage;
	XImage *setcolorimage;
	GC fullgc;
	Window currentwindow;
	GC currentgc;
	int offset_x;
	int offset_y;
	int monoplane; /* le plan de restriction pour les modes */
	char *hostname;
};

