; .EnTete "Le-Lisp (c) version 15.2" " " "La date"
; .EnPied " " "%" " "
; .SuperTitre "La date de base"
;
; .Centre "*****************************************************************"
; .Centre " Ce fichier est en lecture seule hors du projet ALE de l'INRIA.  "
; .Centre " Il est maintenu par ILOG SA, 2 Avenue Gallie'ni, 94250 Gentilly "
; .Centre " (c) Le-Lisp est une marque de'pose'e de l'INRIA                 "
; .Centre "*****************************************************************"

; .Centre "$Header: date.ll,v 5.4 89/08/04 23:34:15 kuczynsk Exp $"

(unless (>= (version) 15.2)
        (error 'load 'erricf 'date))

(defvar #:sys-package:colon 'date)

(add-feature 'date)

; Ajout de ces cinq de'finitions re'cupe're'es dans libdate afin d'e'viter 
; d'importer ce dernier module en entier.

; Calcul du nume'ro (1-7) du jour de la semaine (Gre'gorien, year >= 0)

(de week-day-number (date)
    (ifn (datep date) (error 'week-day-number 'errbpa date))
    (let ((year (:year date))(month (:month date))
          (day (:day date))(result 5))
          ; le premier janvier 0 etait un samedi
        (setq result
            (add result 
		 (add year
		      (add (leap-number year)
			   (year-day-number date)))))
        (setq result (modulo result 7))
        (if (eq result 0) 7 result)))

; Calcul du nume'ro du jour dans l'anne'e

(de year-day-number (date)
    (ifn (datep date) (error 'year-day-number 'errbpa date))
    (let ((year (:year date))(month (:month date))(day (:day date)))
        (if (gt month 1)
            (for (i 1 1 (sub1 month))
		 (setq day (add day (month-length i year)))))
        day))

(de month-length (month year)
    (add (cassq month month-lengths)
	 (if (and (eq month 2) (leap-year-p year)) 1 0)))

; Le pre'dicat des anne'es bissextiles

(de leap-year-p (year)
    (if (eq (modulo year 4) 0)
        (if (eq (modulo year 100) 0)
	    (if (eq (modulo year 400) 0) t ())
	    t)
        ()))

; Le nombre d'anne'es bissextiles depuis l'an 0

(de leap-number (year)
    (let ((previous (if (gt year 0) (sub1 year) year)))
         (add (div previous 4)
	      (add (sub 0 (div previous 100))
		   (add (div previous 400)
			(if (gt year 0) 1 0))))))


; .Section "Interface"

; Cette structure est une pseudo-structure qui permet
; d'acce'der au vecteur (standard) repre'sentant une
; date syste`me (retourne'e par la fonction DATE).

; La fonction #:DATE:MAKE n'est donc jamais utilise'e.

(defstruct date
    year month day hour minute second msecond week-day)

(defmessage :ERRYEAR (french  "mauvaise annee")
                     (english "bad year"))
(defmessage :ERRMONTH(french  "mauvais mois")
                     (english "bad month"))
(defmessage :ERRDAY  (french  "mauvais jour")
                     (english "bad day"))
(defmessage :ERRHOUR (french  "mauvaise heure")
                     (english "bad hour"))
(defmessage :ERRMIN  (french  "mauvaise minute")
                     (english "bad minute"))
(defmessage :ERRSEC  (french  "mauvaise seconde")
                     (english "bad second"))
(defmessage :ERRMSEC (french  "mauvaise milli-seconde")
                     (english "bad millisecond"))
(defmessage :ERRWDAY (french  "mauvais jour de semaine")
                     (english "bad day of the week"))
(de create-date ()
    ; cre' une date : ve'rifie la re'ponse du syste`me et
    ; charge les options par de'faut.
    (let ((date (date)))
         (typevector date 'date)
         (unless (fixp (:year date))
                 (error 'date ':ERRYEAR date))
         (when (or (not (fixp (:month date)))
                   (lt (:month date) 1) (gt (:month date) 12))
               (error 'date ':ERRMONTH date))
         (when (or (not (fixp (:day date)))
                   (lt (:day date) 1) (gt (:day date) 31))
               (error 'date ':ERRDAY date))
         (when (or (not (fixp (:hour date)))
                   (lt (:hour date) 0) (gt (:hour date) 23))
               (error 'date ':ERRHOUR date))
         (when (or (not (fixp (:minute date)))
                   (lt (:minute date) 0) (gt (:minute date) 59))
               (error 'date ':ERRMIN date))
         (unless (:second date) (:second date 0))
         (when (or (not (fixp (:second date)))
                   (lt (:second date) 0) (gt (:second date) 59))
               (error 'date ':ERRSEC date))
         (unless (:msecond date) (:msecond date 0))
         (when (or (not (fixp (:msecond date)))
                   (lt (:msecond date) 0) (gt (:msecond date) 999))
               (error 'date ':ERRMSEC date))
         (unless (:week-day date)
                 (:week-day date (week-day-number date)))
         (when (or (not (fixp (:week-day date)))
                   (lt (:week-day date) 1) (gt (:week-day date) 7))
               (error 'date ':ERRWDAY  date))
         date))

(de #:date:prin (date)
    ; impression de la structure "date"
    (if #:system:print-for-read
	(let ((#:system:print-for-read ()))
	  (prin "#:date:#["
		(:year date) " "
		(:month date) " "
		(:day date) " "
		(:hour date) " "
		(:minute date) " "
		(:second date) " "
		(:msecond date) " "
		(:week-day date) "]"))
        (prin (short-string-date date))))

; .Section "Les donne'es"
; 
; De'but de la partie de'pendante du site
; A chaque fois, on a les versions courtes et longues

; Les noms des mois
(defmessage :janv (french "janv")
                  (english "jan"))
(defmessage :fevr (french "fevr")
                  (english "feb"))
(defmessage :mars (french "mars")
                  (english "mar"))
(defmessage :avr (french "avr")
                  (english "apr"))
(defmessage :mai (french "mai")
                  (english "may"))
(defmessage :juin (french "juin")
                  (english "june"))
(defmessage :juil (french "juil")
                  (english "july"))
(defmessage :aout (french "aout")
                  (english "aug"))
(defmessage :sept (french "sept")
                  (english "sept"))
(defmessage :oct (french "oct")
                  (english "oct"))
(defmessage :nov (french "nov")
                  (english "nov"))
(defmessage :dec (french "dec")
                  (english "dec"))

(defvar short-month-names '((1 . :janv)(2 . :fevr)(3 . :mars)
    (4 . :avr)(5 . :mai)(6 . :juin)(7 . :juil)(8 . :aout)
    (9 . :sept)(10 . :oct)(11 . :nov)(12 . :dec)))

; Les noms des jours
(defmessage :lun (french "lun")
                 (english "mon"))
(defmessage :mar (french "mar")
                 (english "tue"))
(defmessage :mer (french "mer")
                 (english "wed"))
(defmessage :jeu (french "jeu")
                 (english "thu"))
(defmessage :ven (french "ven")
                 (english "fri"))
(defmessage :sam (french "sam")
                 (english "sat"))
(defmessage :dim (french "dim")
                 (english "sun"))

(defvar short-day-names '((1 . :lun)(2 . :mar)(3 . :mer)(4 . :jeu)
    (5 . :ven)(6 . :sam)(7 . :dim)))

; Fin des donne'es de'pendantes du site

; La longueur des mois
(defvar month-lengths '((1 . 31)(2 . 28)(3 . 31)(4 . 30)(5 . 31)
    (6 . 30)(7 . 31)(8 . 31)(9 . 30)(10 . 31)(11 . 30)(12 . 31)))

; .Section "Les conversions"
 
; le format court (24 caracte`res)

(de short-string-date (date)
    (ifn (datep date) (error 'short-string-date 'errbpa date))
    (let ((year (modulo (:year date) 100))
          (month-name (get-message (cassq (:month date) short-month-names)))
          (day (:day date))(hour (:hour date))
          (min (:minute date))(sec (:second date))
          (day-name (get-message (cassq (:week-day date) short-day-names)))
          (result (makestring 24 #\sp)))
      (selectq (current-language)
	       (english
		(bltstring result 0 day-name 0)
		(bltstring result (sub 11 (slength day)) day 0)
		(bltstring result 4 month-name 0))
	       (t
		(bltstring result 0 day-name 0)
		(bltstring result (sub 6 (slength day)) day 0)
		(bltstring result 7 month-name 0))
		)
      (bltstring result (sub 14 (slength year)) year 0)
      (bltstring result 15 "00:00:00" 0)
      (bltstring result (sub 17 (slength hour)) hour 0)
      (bltstring result (sub 20 (slength min)) min 0)
      (bltstring result (sub 23 (slength sec)) sec 0)
      result))

; .Section "Les utilitaires"

; Le pre'dicat : est une date

(de datep (date)
    (if (and (vectorp date)
	     (eq (typevector date) 'date))
	t
        ()))


