grammar for programs semant = 
delimitor
  string is "\""
  comment is "%"
  ;
precedences
  right Literal "else";
  left Literal "=" Literal "<" Literal ">";
  left Literal "+" Literal "-";
  left Literal "*";
  nonassoc Literal ":=";

rule entry program = 
    parse "program"; block b; "." -> Program b
        
and block = 
    parse decl d; block_com b -> (d,b)
        
and decl = 
    parse ( * (parse decl_elem_semic d -> d)) dl -> Comp_decl dl
        | escape d -> d

and decl_elem_semic =
    parse decl_elem d ; ";" -> d
        
and decl_elem = 
    parse "var"; Identifier i -> Var_decl i
        | "procedure"; Identifier name;
          "("; Identifier v1; ","; Identifier v2; ")"; ";"; block b
          -> Proc_decl (name,v1,v2,b)
        | "function"; Identifier name; "("; Identifier v; ")"; ";";
             expr e
          -> Fun_decl (name,v,e)

and entry declaration =
    parse decl_elem d -> d
       | escape d -> Comp_decl d

and entry command = 
    parse com c -> c
        | block_com b -> b

and block_com =
    parse "begin";com_list cl; "end" -> cl
        | escape ml -> ml

and com_list = parse
          com c1; ( * (parse ";"; com c -> c)) cl -> Comp_com (c1 :: cl)
        | escape ml -> Comp_com ml
      
and com = 
    parse Identifier v; ":="; expr e -> Ass_com (v,e)
        | Identifier name; "("; Identifier v; ","; expr e; ")"
          -> Proc_com (name,v,e)
        | "if"; expr e; "then"; command c1; "else"; command c2
          -> If_com (e,c1,c2)
        | "while"; expr e; "do"; command c1 -> While_com (e,c1)
        | "write" ; expr e -> Write_com e
        | "read"; Identifier i -> Read_com i
        
and simple_exp = 
    parse Num n -> Num_exp n
        | "-"; Num n ->  Num_exp (- n)
        | Bool b -> Bool_exp b
        | Ident v -> Var_exp v
        | escape_simple_exp c -> c
        
and escape_simple_exp = 
    parse "Num"; escape n -> Num_exp n
        | "-"; "Num"; escape n ->  Num_exp (- n)
        | "Bool"; escape b -> Bool_exp b
        | "Ident"; escape v -> Var_exp v
        
and entry expression = parse expr e; ">>"; {lex_reread ">>"} _ -> e

and expr =
    parse simple_exp c -> c
        | "if"; expr e1; "then"; expr e2; "else"; expr e3 -> If_exp (e1,e2,e3)
        | Identifier name; "("; expr e; ")" -> Fun_exp (name,e)
        | unexp e -> e
        | binexp e -> e
        | escape e -> e

and binexp = 
    parse expr e1; ("+" as op); expr e2 -> Binop_exp (e1,op,e2)
        | expr e1; ("*" as op); expr e2 -> Binop_exp (e1,op,e2)
        | expr e1; ("-" as op); expr e2 -> Binop_exp (e1,op,e2)
        | expr e1; ("=" as op); expr e2 -> Binop_exp (e1,op,e2)
        | expr e1; (">" as op); expr e2 -> Binop_exp (e1,op,e2)
        | expr e1; ("<" as op); expr e2 -> Binop_exp (e1,op,e2)
        | expr e1; escape e; expr e2    -> Binop_exp (e1,e,e2)
        | "("; expr e; ")" -> e


and unexp = parse ("succ" as op); expr e -> Unop_exp (op,e)
                | "Unop"; escape op; expr e -> Unop_exp (op,e)
        
and escape = 
    parse "^"; Ident v; {MLconst_to_MLvar v} s -> s
        | "{^"; {parse_caml_expr ()} e; "^}" -> e

and Identifier =
    parse "^"; Ident v; {MLconst_to_MLvar v} s -> s
        | Ident v -> v
;;
