grammar for programs semant = 
delimitor
  string is "\""
  comment is "%"
  ;
precedences
  right Literal "else";
  left Literal "=" Literal "<" Literal ">";
  left Literal "+" Literal "-";
  left Literal "*";
  nonassoc Literal ":=";

rule entry program = 
    parse "program"; block b; "." -> Program b
        
and block = 
    parse declaration d; "begin"; block_command b; "end" -> (d,b)
        | mlescape e -> e
        
and declaration = 
    parse -> Comp_decl []
        | declarationl dl
          -> (match dl with [d] -> d | _ -> Comp_decl dl)
          
        
and declarationl = 
    parse declelem d -> [d]
        | declelem d; declarationl dl -> d::dl
        
and declelem = 
    parse "var"; IDENT i; ";" -> Var_decl i
        | "procedure"; IDENT name;
          "("; IDENT v1; ","; IDENT v2; ")"; ";"; block b; ";"
          -> Proc_decl (name,v1,v2,b)
        | "function"; IDENT name; "("; IDENT v; ")"; ";"; expression e; ";"
          -> Fun_decl (name,v,e)
        
and command = 
    parse commandelem c -> c
        | "begin"; block_command b; "end" -> b
        
and block_command = 
    parse commandl cl
          -> (match cl with [c] -> c | _ -> Comp_com (rev cl))
          
        
and commandl = 
    parse commandelem c -> [c]
        | commandl cl; ";"; commandelem c -> c::cl
        
and commandelem = 
    parse IDENT v; ":="; expression e -> Ass_com (v,e)
        | IDENT NAME; "("; IDENT v; ","; expression e; ")"
          -> Proc_com (name,v,e)
        | "if"; expression e; "then"; command c1; "else"; command c2
          -> If_com (e,c1,c2)
        | "while"; expression e; "do"; command c1
          -> While_com (e,c1)
        | "write" ; expression e -> Write_com e
        | "read"; IDENT i -> Read_com i
        
and ce = 
    parse NUM n -> n
        | "-"; NUM n -> minus n
        
and expression = 
    parse ce e1 -> Num_exp e1
        | BOOL b -> Bool_exp b
        | IDENT v -> Var_exp v
        | "if"; expression e1; "then"; expression e2; "else"; expression e3
          -> If_exp (e1,e2,e3)
        | IDENT name; "("; expression e; ")" -> Fun_exp (name,e)
        | "suc"; "("; expression e; ")" -> Unop_exp ("suc",e)
        | binexp e -> e
        
and binexp = 
    parse expression e1; Literal ("+" as op); expression e2
          -> Binop_exp (e1,op,e2)
        | expression e1; Literal ("*" as op); expression e2
          -> Binop_exp (e1,op,e2)
        | expression e1; Literal ("-" as op); expression e2
          -> Binop_exp (e1,op,e2)
        | expression e1; Literal ("=" as op); expression e2
          -> Binop_exp (e1,op,e2)
        | expression e1; Literal (">" as op); expression e2
          -> Binop_exp (e1,op,e2)
        | expression e1; Literal ("<" as op); expression e2
          -> Binop_exp (e1,op,e2)
        | "("; expression e; ")" -> e
        
and mlescape = 
    parse "^"; IDENT v; {MLconst_to_MLvar v} s -> s
        | "{^"; {parse_caml_expr ()} e; "^}" -> e
;;
