(*************************************************************************)
(*                                                                       *)
(*                     Projet      Formel                                *)
(*                                                                       *)
(*                            CAML                                       *)
(*                                                                       *)
(*************************************************************************)
(*                                                                       *)
(*                            Inria                                      *)
(*                      Domaine de Voluceau                              *)
(*                      78150  Rocquencourt                              *)
(*                            France                                     *)
(*                                                                       *)
(*************************************************************************)

(* obj_gram The grammar of obj's                                         *)
(*          Michel Mauny (translation from old Yacc interface)           *)
(*          Ascander Suarez                                              *)
(*          (Last edit date : Tue Dec 20 16:37:31 1988)                  *)

#system module Objs_gram;;

let Const_nil =
 MLapply(MLvar "obj_atom",MLconst (mlatom (atom_of_string "")),[]);;
let Const_eq =
 MLapply(MLvar "obj_atom",MLconst (mlatom (atom_of_string "=")),[]);;
let Const_and =
 MLapply(MLvar "obj_atom",MLconst (mlatom (atom_of_string "&")),[]);;
let Const_at =
 MLapply(MLvar "obj_atom",MLconst (mlatom (atom_of_string "@")),[]);;
let Const_quote =
 MLapply(MLvar "obj_atom",MLconst (mlatom (atom_of_string "quote")),[]);;

let Atom_nil =
 MLconst (mlatom (atom_of_string ""));;

let const_of_atom s = MLconst (mlatom (atom_of_string s));;

let quote_of_num (n:obj vect) = MLquote (dynamic(Repr n));;


grammar for values obj =
precedences
    nonassoc ">>"
;


rule entry (Obj : ML) =
    parse OObj obj accept obj

and OObj =
    parse IDENT  x
                -> (<:CAML:Expr<obj_atom {^const_of_atom x^}>>)
        | NUM  n
                -> (match n with
                        Int i -> <:CAML:Expr<obj_int {^MLconst(mlint i)^}>>
                      | Float f -> <:CAML:Expr<obj_float
                                                {^MLconst (mlfloat f)^}>>
                      | Big_num n -> quote_of_num n)
        | STRING  s
                -> <:CAML:Expr<obj_string {^MLconst(mlstring s)^}>>
        | "="   -> Const_eq
        | "&"   -> Const_and
        | Caml_escape  esc -> esc
        | "@"; OObj  obj
                -> <:CAML:Expr<obj_cons({^Const_at^},
                                        obj_cons({^obj^},{^Const_nil^}))>>
        | "'"; OObj  obj
                ->
                <:CAML:Expr<obj_cons({^Const_quote^},
                                     obj_cons({^obj^},{^Const_nil^}))>>
        | "("; Objl  ol; ")" -> ol
        | "#["; Objv  ov; "]"
                -> <:CAML:Expr<obj_vect
                               (vector of {^mklist ov^})>>

and entry Atom =
    parse AAtom atom accept atom

and AAtom =
    parse IDENT  x -> const_of_atom x
        | "("; ")"   -> Atom_nil

and Caml_escape =
    parse "^"; IDENT  x                     -> MLvar x
        | "{^"; {parse_caml_expr()}  e; "^}"  -> e

and Objv =
    parse                        -> []
        | Objv  ov; OObj  obj -> obj::ov

and Objl =
    parse -> Const_nil
        | OObj  obj; Objl  ol        -> <:CAML:Expr<obj_cons({^obj^},{^ol^})>>
        | OObj  obj1; "."; OObj  obj2
            -> <:CAML:Expr<obj_cons({^obj1^},{^obj2^})>>
;;

let parse_obj = (obj "Obj").Parse_raw
and parse_atom = (obj "Atom").Parse_raw;;

#end module with value
    parse_obj
and parse_atom
and obj
;;
