(*************************************************************************)
(*                                                                       *)
(*                     Projet      Formel                                *)
(*                                                                       *)
(*                            CAML                                       *)
(*                                                                       *)
(*************************************************************************)
(*                                                                       *)
(*                            Inria                                      *)
(*                      Domaine de Voluceau                              *)
(*                      78150  Rocquencourt                              *)
(*                            France                                     *)
(*                                                                       *)
(*************************************************************************)

(* CAML_gram The grammar of CAML macros (from grammar of CAML itself)    *)
(*           Michel Mauny (translation from old Yacc interface)          *)

(*           (Last edit date : Wed Dec 21 15:32:45 1988)                 *)

(* This grammar seems to be partly false!
   This is due to the usage of types_declared *)

#system module caml_gram;;

let MLtypes_of_vars = map (fun s -> MLvartyp s);;

let MLpair_to_syntax =
    function MLpair (MLconst (mlstring s1),MLconst (mlstring s2)) -> s1,s2
           | _ -> system_error "wrong \"Syntax\" lexeme"
;;

let ML_to_MML (expr:ML) = MLquote (dynamic expr);;

grammar CAML =

delimitors
    string is "\""
    comment is "%"
;
precedences
    right "->";
    right "or";
    right "&";
    right ",";
    right INFIX;
    right "@" "^";
    right "::";
    left "+" "-";
    left "*" "/";
    precedence uminus;
    left ".";
    right ">>" "^}" "~}"
;

(* Eliminated from caml_gram.ml *)
(* rule entry Caml = *)
(*     parse Caml_top t; Literal ";;" -> t *)
(*  *)
(* and Caml_top = *)
(*     parse Top_decl td -> MLdecl td *)
(*         | Expr e      -> ML e *)
(*         | Directive d -> MLdirective d *)
(*         | Gram g -> g *)
(*         | Macro_decl md  -> MLpragma md *)
(*         (* Directive receive a special treatment by caml_lex *) *)
(*         (* What is done here coesn't work *) *)
(*         | "#" -> parse_directive () *)
(*  *)
(* and entry Pragma = *)
(*     parse Decl d; Literal ";;" -> Pragmadecl d *)
(*         | Expr e; Literal ";;" -> Pragmaexp e *)
(* End eliminated *)

rule entry Expr =
    parse Literal "lazy"; Expr e -> MLeval_mode (Lazy,e)
        | Literal "freeze"; Expr e -> MLeval_mode1 (Lazy,e)
        | Literal "parallel"; Expr e -> MLeval_mode (Parallel,e)
        | Literal "future"; Expr e -> MLeval_mode1 (Parallel,e)
        | Literal "strict"; Expr e -> MLeval_mode (Strict,e)
        | Literal "force"; Expr e -> MLforce e
        | Literal "protect"; Expr e -> MLprotect e
        | Expr17 e1; Literal "?"; Expr e2
            -> MLhandle(e1,[(MLconpat("failure", MLwildpat)),e2])
        | Expr17 e; Literal "where"; Val_binding vb -> MLin(vb, e)
        | Expr17 e; Literal "where"; Literal "rec"; Val_binding vb
            -> MLin(MLrec vb, e)
        | Literal "vector"; Expr e_num; Literal "of"; Expr2 e_init
            -> MLinit_vect (MLmutable true,(e_num,e_init))
        | Literal "vector"; Literal "of"; Expr2 e_list
            -> MLvect_of_list (MLmutable true,e_list)
        | Literal "segment"; Expr e_num; Literal "of"; Expr2 e_init
            -> MLinit_vect (MLmutable false,(e_num,e_init))
        | Literal "segment"; Literal "of"; Expr2 e_init
            -> MLvect_of_list (MLmutable false,e_init)
        | Fnexpr e -> e
        | Expr17 e -> e

(* Added *)
and MLescape =
    parse Literal "{^"; {parse_caml_expr ()} e; Literal "^}" -> e
        | Literal "#("; {parse_caml_expr ()} e; Literal ")" -> e
        | Literal "#"; IDENT mlc; {MLconst_to_MLvar mlc} mlv -> mlv
        | Ol_program e; Literal ">>" -> e

and entry MLnum =
    parse NUM n -> MLconst(mlnum n)
        | MLescape e -> MLconst(mlnum e)

and entry MLstring =
        parse STRING s -> MLconst(mlstring s)
            | MLescape e -> MLconst(mlstring e)

and entry MLbool =
        parse BOOL b -> MLconst(mlbool b)
            | MLescape e -> MLconst(mlbool e)

and entry MLint =
        parse INT i -> MLconst(mlint i)
            | MLescape e -> MLconst(mlint e)

and entry MLfloat =
        parse FLOAT f -> MLconst(mlfloat f)
            | MLescape e -> MLconst(mlfloat e)

and entry MLvar =
    parse MLIdent2 v -> MLvar v
        | MLescape e -> MLvar e
(* End added *)

and Expr0 =
    parse Ce c -> MLconst c
        | MLIdent2 x -> MLvar x
        | MLescape e -> e
(*         | Ol_program ol;Literal ">>" -> ol *)
(*         | Literal "#"; IDENT x *)
(*             -> eval_macro_expr_ML (MLvar x) *)
(*         | Literal "#("; Expr e; Literal ")" *)
(*             -> eval_macro_expr_ML e *)

and Ol_program =
    parse Literal "<<" ; {ML_to_MML(parse_ol_grammar !default_ol_grammar)} e -> e
        | Syntax ms; {ML_to_MML(parse_ol_grammar (MLpair_to_syntax ms))} e -> e

and Exp1 =
    parse Exp1 e; Literal "."; IDENT id -> MLrecord_access (id,e)
        | Exp1 e; Literal "."; NUM n
            -> MLapply(MLvar "vect_item", MLpair(e,MLconst(mlnum n)),[])
        | Expr0 e -> e

and Expr1 =
    parse Literal ("!" as bang); Expr1 e -> MLapply(MLvar bang,e,[])
        | Exp1 e -> e

and Exp2 =
    parse Literal "ref"; Expr1 e -> MLref e
        | Literal "dynamic"; Expr1 e -> MLdynamic e
        | Expr1 e -> e

and Expr2 =
    parse Appexp e -> mkapply e
        | Exp2 e -> e

and Appexp =
    parse Exp2 e; Expr1 e_prime -> e_prime::[e]
       | Appexp e; Expr1 e_prime -> e_prime::e

and Expr8 =
    parse Expr8 e; INFIX i; Expr8 e_prime 
            -> MLapply(MLvar i, MLpair(e,e_prime),[])
        | Expr8 e; Literal ("@" as a); Expr8 e_prime 
            -> MLapply(MLvar a, MLpair(e,e_prime),[])
        | Expr8 e; Literal ("^" as c); Expr8 e_prime 
            -> MLapply(MLvar c, MLpair(e,e_prime),[])
        | Expr8 e; Literal ("::" as dc); Expr8 e_prime 
            -> MLapply(MLvar dc, MLpair(e,e_prime),[])
        | Expr8 e; Literal ("+" as p); Expr8 e_prime 
            -> MLapply(MLvar p, MLpair(e,e_prime),[])
        | Expr8 e; Literal ("-" as m); Expr8 e_prime 
            -> MLapply(MLvar m, MLpair(e,e_prime),[])
        | Expr8 e; Literal ("*" as st); Expr8 e_prime 
            -> MLapply(MLvar st, MLpair(e,e_prime),[])
        | Expr8 e; Literal ("/" as d); Expr8 e_prime 
            -> MLapply(MLvar d, MLpair(e,e_prime),[])
        | "-"; Expr8 e with precedence uminus -> mkuminus e
        | Expr2 e -> e

and Expr9 =
    parse Expr8 e; Literal ("=" as eq); Expr8 e_prime
            -> MLapply(MLvar eq, MLpair(e,e_prime),[])
        | Expr8 e; Literal ("<" as lt); Expr8 e_prime
            -> MLapply(MLvar lt , MLpair(e,e_prime),[])
        | Expr8 e; Literal (">" as gt); Expr8 e_prime
            -> MLapply(MLvar gt , MLpair(e,e_prime),[])
        | Expr8 e; Literal ("<=" as le); Expr8 e_prime
            -> MLapply(MLvar le , MLpair(e,e_prime),[])
        | Expr8 e; Literal (">=" as ge); Expr8 e_prime
            -> MLapply(MLvar ge , MLpair(e,e_prime),[])
        | Expr8 e; Literal ("<>" as diff); Expr8 e_prime
            -> MLapply(MLvar diff , MLpair(e,e_prime),[])
        | Expr8 e -> e

and Expr10 =
    parse Literal ("not" as n); Expr9 e -> MLapply(MLvar n, e,[])
        | Expr9 e -> e

and Expr12 =
    parse Expr12 e; Literal "or"; Expr12 e_prime
            -> MLcond(e, MLconst(mlbool true),e_prime)
        | Expr12 e; Literal "&"; Expr12 e_prime
            -> MLcond(e,e_prime, MLconst(mlbool false))
        | Expr10 e -> e

and Expr13 =
    parse Expr12 e; Literal ","; Fnexpr13 e_prime -> MLpair(e,e_prime)
        | Expr12 e -> e

and Expr14 =
    parse Expr13 e; Literal ":="; Fnexpr13 e_prime
            -> MLass(expr_to_pat e, e_prime)
        | "at"; MLIdent2 id; Literal "<-"; Fnexpr13 e
            -> MLreplace (id,e)
        | Expr13 e -> e

and Expr15 =
    parse Literal "raise"; Rs_expr e -> mkraise e
        | Literal "failwith"; Expr15 e -> mkraise ("failure",e)
        | Expr14 e -> e

and Rs_expr =
    parse Literal "("; Rs_expr e; Literal ")" -> e
        | MLIdent id; Fnexpr15 e -> (id,e)
        | MLIdent id -> (id, MLconst mlnull)

and Expr0 =
    parse Literal "fail" -> mkraise("failure", MLconst(mlstring "fail"))
        | Literal "continue" -> MLcontinue

and Expr0 =
    parse Literal "["; Exprs e; Literal "]" -> mklist e
        | Literal "[|"; Exprs es; Literal "|]" -> mkvect es
        | Literal "[|"; Literal "|]" -> mkvect []
        | Literal "[<"; Exprs es; Literal ">]" -> mkseg es
        | Literal "[<"; Literal ">]" -> mkseg []

and Exprs =
    parse Expr16 e -> [e]
        | Exprs e; Literal ";"; Expr16 e_prime -> e_prime::e

and Expr16 =
    parse Literal "if"; Expr test; Literal "then"; Fnexpr16 e_true; Cond c
            -> MLcond(test , e_true, c)
(*         | Literal "#"; Literal "if"; Expr test; Literal "then"; Expr0 e_true; *)
(*                 Literal "else"; Expr0 e_false *)
(*             -> eval_macro_expr_bool test e_true e_false *)
        | Expr15 e -> e

and Cond =
    parse Literal "if"; Expr test; Literal "then"; Fnexpr16 e_true; Cond c
            -> MLcond(test, e_true, c)
        | Literal "else"; Fnexpr16 e -> e
        |   -> MLconst mlnull

and Seqexpr16 =
    parse Seqexpr16 e ; Literal ";" ; Fnexpr16 f -> f::e
        | Fnexpr16 f -> [f]

and Expr17 =
    parse Expr16 e ; Literal ";" ; Seqexpr16 es -> mkseq (e,es)
        | Expr16 e -> e

and Fnexpr =
    parse Literal "fun"; Match m -> MLmatch m
        | Literal "function"; Umatch um -> MLmatch um
        | Literal "match"; Expr e; Literal "with"; Umatch um
            -> MLapply (MLmatch um, e,[])
        | Literal "case"; Expr e; Literal "of"; Umatch um
            -> MLapply (MLmatch um, e,[])
        | Literal "try"; Expr e; Literal "with"; Trymatch tm
            -> mkhandle (e, tm)
        | Decl d; Literal "in"; Expr e -> MLin (d,e)

and Fnexpr13 = parse Fnexpr e -> e | Expr13 e -> e
and Fnexpr15 = parse Fnexpr e -> e | Expr15 e -> e
and Fnexpr16 = parse Fnexpr e -> e | Expr16 e -> e

and Expr0 =
    parse Literal "("; Expr e; Literal ")" -> e
        | Literal "("; Expr e; E_str str; Literal ")" -> MLstraint(e, str)
        | Literal "while"; Expr e_test;
          Literal "do"; Expr e_loop_step; Literal "done"
            -> MLwhile(e_test, e_loop_step)
        | Literal "begin" ; Literal "do";
          Expr17 e ; Literal "end" ; Literal "do"
            -> e            
        | Literal "begin"; Literal "while"; Expr e_test; Literal "do";
          Expr e_loop_step; Literal "end"; Literal "while"
            -> MLwhile(e_test, e_loop_step)
        | Literal "begin"; Literal "fun"; Match m; Literal "end"; Literal "fun"
            -> MLmatch m
        | Literal "begin"; Literal "function"; Umatch um;
          Literal "end"; Literal "function"
            -> MLmatch um
        | Literal "begin"; Literal "match"; Expr e; Literal "with"; Umatch um;
          Literal "end"; Literal "match"
            -> MLapply(MLmatch um, e,[])
        | Literal "begin"; Literal "case"; Expr e; Literal "of"; Umatch um;
          Literal "end"; Literal "case"
            -> MLapply(MLmatch um, e,[])
        | Literal "begin"; Literal "try"; Expr e; Literal "with"; Trymatch tm;
          Literal "end"; Literal "try"
            -> mkhandle (e, tm)
        | Literal "begin"; Literal "if"; Expr e_test;
          Literal "then"; Expr e_true;
          Literal "else"; Expr e_false; Literal "end"; Literal "if"
            -> MLcond(e_test, e_true, e_false)
        | Literal "begin"; Literal "if"; Expr e_test;
          Literal "then"; Expr e_true; Literal "end"; Literal "if"
            -> MLcond(e_test, e_true, MLconst mlnull)
(*         | Literal "begin"; Literal "#"; Literal "if"; Expr e_test; *)
(*           Literal "then"; Expr0 e_true; *)
(*           Literal "else"; Expr0 e_false; Literal "end"; Literal "if" *)
(*             -> eval_macro_expr_bool e_test e_true e_false *)
        | Literal "{"; Field_list fl; Literal "}" -> MLrecord fl


and Field_list =
    parse Field1 f -> (f,[])
        | Field1 f; Literal ";"; Field_l fl -> (f,rev fl)

and Field_l =
    parse Field1 f -> [f]
        | Field_l fl; Literal ";"; Field1 f -> f::fl

and Field1 =
    parse MLIdent id; Literal "="; Expr16 e -> (id,e)

and E_str =
    parse Literal ":"; Type ty -> ty
(*         | Literal "#:"; Expr e *)
(*             -> eval_macro_expr_MLtype e *)

and entry Match = parse Match1 ml -> rev ml

and Match1 =
    parse Bpat1 p; Match_rule mr -> [(p, mr)]
        | Match1 ml; Literal "|"; Bpat1 p; Match_rule mr -> (p, mr)::ml
(*         | Match1 ml; Literal "#|"; Expr e *)
(*             -> rev_append (eval_macro_expr_MLpat_ML_list e) ml *)

and Match_rule =
    parse Bpat1 p; Match_rule mr -> MLmatch [p,mr]
        | Literal "->"; Expr e -> e

and Try_case =
    parse Pat p; Literal "->"; Literal "reraise" -> mkreraise p
        | Pat p; Literal "->"; Expr e; Literal "reraise" -> mkseqreraise (p,e)
        | Umatch_case umc -> umc

and Umatch_case = parse Pat p; Literal "->"; Expr e -> (p,e)

and entry Umatch = parse Umatch1 uml -> rev uml

and Umatch1 =
    parse Umatch_case umc -> [umc]
        | Umatch1 uml; Literal "|"; Umatch_case umc -> umc::uml
(*         | Umatch1 uml; Literal "#|"; Expr e *)
(*             -> rev_append (eval_macro_expr_MLpat_ML_list e) uml *)

and Trymatch = parse Trymatch1 tml -> rev tml

and Trymatch1 =
    parse Try_case tc -> [tc]
        | Trymatch1 tcl; Literal "|"; Try_case tc -> tc::tcl
(*         | Trymatch1 tcl; Literal "#|"; Expr e *)
(*             -> rev_append (eval_macro_expr_MLpat_ML_list e) tcl *)


(* and Top_decl = *)
(*     parse Literal "overload"; Overload_binding ovbl -> MLoverload (rev ovbl) *)
(*         | Literal "forward"; Forward_binding fbl -> MLforward (rev fbl) *)
(*         | Decl d -> d *)

(* and entry Gram = *)
(*     parse Literal "grammar" -> parse_grammar_decl() *)

and entry Decl =
    parse Literal "let"; Val_binding vb -> vb
        | Literal "let"; Literal "rec"; Val_binding vb -> MLrec vb
        | Literal "value"; Val_binding vb -> vb
        | Literal "value"; Literal "rec"; Val_binding vb -> MLrec vb
        | Literal "type"; Type_binding tb -> MLtype(rev tb)
        | Literal "type"; Literal "rec"; Type_binding tb -> MLtype(rev tb)
(*
        | Literal "abstype"; Type_binding_c tb; Literal "with"; Val_binding vb
            -> MLtype [MLabstract_type (tb,vb)]
        | Literal "abstype"; Type_binding_c tb; Literal "with" Literal "rec";
          Val_binding vb
            -> MLtype [MLabstract_type (tb,vb)]
        | Literal "abstype"; Literal "rec"; Type_binding_c tb; Literal "with";
          Val_binding vb
            -> MLtype [MLabstract_type (tb,vb)]
        | Literal "abstype"; Literal "rec"; Type_binding_c tb;
          Literal "with"; Literal "rec"; Val_binding vb
            -> MLtype [MLabstract_type (tb,vb)]
*)
        | Literal "exception"; Exc_binding ebl -> MLexception(rev ebl)
        | Decl local_decl; Literal "in"; Decl decl -> MLlocal(local_decl,decl)
        | Literal "("; Decl d; Literal ")" -> d

and entry Val_binding =
    parse Val_binding0 vb -> mkdecl vb
        | Val_binding vb1; Literal "and"; Val_binding0 vb2
            -> binarize(vb1, mkdecl vb2)

and Val_binding0 =
    parse Bpat p; Beurk b
    (* s'appelait "b", mais je sais pce que c'est *)
            -> [p,b]
        | Bpat1 p1; Inf i; Bpat1 p2; Literal "="; Expr e
            -> [MLvarpat i, MLmatch[MLpairpat(p1, p2),e]]
        | Val_binding0 vb; Literal "|"; Bpat p; Beurk b -> (p, b)::vb

and Beurk =
    parse Bpat1 p; Beurk n -> MLmatch[p,n]
        | Literal "="; Expr e -> e

(* and Overload_binding = *)
(*     parse Overload_binding0 ov -> [ov] *)
(*         | Overload_binding ovl; Literal "and"; Overload_binding0 ov -> ov::ovl *)
(*  *)
(* and Overload_binding0 = *)
(*     parse MLIdent3 id; Literal "with"; MLIdent3l idl -> id,rev idl *)
(*  *)
(* and Forward_binding = *)
(*     parse Forward_binding0 fb -> [fb] *)
(*         | Forward_binding fbl; Literal "and"; Forward_binding0 fb -> fb::fbl *)
(*  *)
(* and Forward_binding0 = *)
(*     parse MLIdent3 id; Literal ":"; Type ty -> (id,ty) *)
(*         | Literal "("; MLIdent3 id; Literal ":"; Type ty; Literal ")" *)
(*             -> (id,ty) *)

and entry Type_binding =
    parse Type_binding_1 tb
            -> (if !types_declared=[] then [tb]
                else let tbs = !types_declared in
                types_declared:=[];tbs@[tb])
        | Type_binding tbl; Literal "and"; Type_binding_1 tb
            -> (if !types_declared=[] then tb::tbl
                else let tbs = !types_declared in
                types_declared:=[];tbs @ tb::tbl)

and Type_binding_1 =
    parse Type_binding_c tb -> MLconcrete_type tb
        | Type_binding_r tb -> MLrecord_type tb
        | Type_binding_abb tb -> MLabbrev_type tb

and Type_binding_args =
    parse Var_tyargs vta; MLIdent2 id -> (fun x -> id,vta,x)
        | Var_ty vt1; Type_infixes i; Var_ty vt2 -> (fun x -> i,[vt1;vt2],x)

and Type_binding_r =
    parse Type_binding_args tbargs; Literal "="; Labels lbl -> tbargs lbl

and Type_binding_abb =
    parse Type_binding_args tbargs; Literal "=="; Type_in_decl ty
            -> tbargs ty

and Type_binding_c =
    parse Type_binding_args tbargs; Literal "="; Constructors constrs
            -> tbargs constrs

and Labels = parse Labs l -> l
                 | Literal "{"; Labs l; Literal "}" -> l

and Constructors = parse Constr cl -> rev cl
                       | Literal "["; Constr cl; Literal "]" -> rev cl

and Type_in_decl =
    parse Type ty -> ty
        | Type ty; Literal "as"; Var_tyargs vty; MLIdent2 id
            -> (types_declared := MLabbrev_type(id,vty,ty)::!types_declared;
                ty)
        | Literal "{"; Labs lbs; Literal "}";
          Literal "as"; Var_tyargs vty; MLIdent2 id
            -> (types_declared := MLrecord_type(id,vty,lbs)::!types_declared;
                MLconsttyp(id,MLtypes_of_vars vty))
        | Literal "["; Constr c; Literal "]";
          Literal "as"; Var_tyargs vty; MLIdent2 id
            -> (types_declared:=MLconcrete_type(id,vty,rev c)::!types_declared;
                MLconsttyp(id, MLtypes_of_vars vty))

(* and Type_name = parse Var_tyargs vty; MLIdent2 id -> (id,vty) *)

and Var_tyargs =
    parse -> []
        | Var_ty v -> [v]
        | Literal "("; Var_tyl vtl; Var_ty v; Literal ")" -> rev (v::vtl)

and Var_tyl =
    parse -> []
        | Var_tyl vtl; Var_ty v; Literal "," -> v::vtl

and entry Constr =
    parse Constr cl; Literal "|"; Constr1 c -> c::cl
        | Constr1 c -> [c]
(*         | Constr c; Literal "#|"; Expr e *)
(*             -> rev_append (eval_macro_expr_MLconstruct_list e) c *)

and Constr1 =
    parse MLIdent2 id; Literal "of"; Type_in_decl ty -> MLconstruct (id,ty)
        | Literal "mutable"; MLIdent2 id; Literal "of"; Type_in_decl ty
            -> MLqconstruct (id,standard_qlabel_qualificator,ty)
        | Literal "!"; MLIdent2 id; Literal "of"; Type_in_decl ty 
            -> MLqconstruct (id,standard_qlabel_qualificator,ty)
        | Literal "lazy"; MLIdent2 id; Literal "of"; Type_in_decl ty 
            -> MLqconstruct (id,standard_llabel_qualificator,ty)
        | Literal "*"; MLIdent2 id; Literal "of"; Type_in_decl ty 
            -> MLqconstruct (id,standard_llabel_qualificator,ty)
        | MLIdent2 id -> MLconstruct0 id

and Labs =
    parse Lab1 l -> (l,[])
        | Lab1 l; Literal ";"; Labl ll -> (l,rev ll)

and Labl =
    parse Labl ll; Literal ";"; Lab1 l -> l::ll
        | Lab1 l -> [l]
(*         | Labl ll; Literal "#;"; Expr0 e *)
(*             -> rev_append (eval_macro_expr_MLlabel_list e) ll *)

and Lab1 =
    parse MLIdent id; Literal ":"; Type_in_decl ty -> MLlabel (id,ty)
        | Literal "mutable"; MLIdent id; Literal ":"; Type_in_decl ty
            -> MLqlabel (id,standard_qlabel_qualificator,ty)
        | Literal "!"; MLIdent id; Literal ":"; Type_in_decl ty
            -> MLqlabel (id,standard_qlabel_qualificator,ty)
        | Literal "lazy"; MLIdent id; Literal ":"; Type_in_decl ty
            -> MLqlabel (id,standard_llabel_qualificator,ty)
        | Literal "*"; MLIdent id; Literal ":"; Type_in_decl ty
            -> MLqlabel (id,standard_llabel_qualificator,ty)

and entry Exc_binding =
    parse Exc_binding ebl; Literal "and"; Exc_binding1 eb -> eb::ebl
        | Exc_binding1 eb -> [eb]

and Exc_binding1 =
    parse MLIdent id; Literal "of"; Type ty -> (id,ty)
        | MLIdent id -> (id,MLconsttyp("unit",[])) (* Unreasonable!!!! *)

and Pat1 =
    parse MLIdent2 id; Bpat1 p -> MLconpat(id,p)
        | Bpat1 p -> p

and Pat4 =
    parse Pat4 p1; Literal ","; Pat4 p2 -> MLpairpat(p1, p2)
        | Pat4 p1; INFIX i; Pat4 p2 -> MLconpat(i, MLpairpat(p1, p2))
        | Pat4 p1; Literal ("::" as c); Pat4 p2
            -> MLconpat(c, MLpairpat(p1, p2))
        | Pat1 p -> p

and Pat5 =
    parse Or_pat orp -> MLorpat((function prefix :: p -> p) (rev orp))
        | Pat4 p -> p

and Or_pat =
    parse Or_pat orp; Literal "|"; Pat4 p -> p::orp
        | Pat4 p1; Literal "|"; Pat4 p2 -> [p2;p1]
(*         | Or_pat orp; Literal "#|"; Expr e *)
(*             -> eval_macro_expr_MLorpat1 e orp *)
(*         | Pat4 p1; Literal "#|"; Expr e *)
(*             -> eval_macro_expr_MLorpat2 e p1 *)

and entry Pat =
    parse Pat5 p; Literal "as"; MLIdent2 id -> MLsynpat(p,id)
        | Pat5 p; Literal "at"; MLIdent2 occ -> MLoccpat(p,occ)
        | Literal "dynamic"; Literal "of"; Type ty; Literal "with"; Pat p
            -> MLdynpat(ty,p)
        | Pat5 p -> p

and Bpat1 =
    parse Ce c -> MLconstpat c
        | Literal "_" -> MLwildpat
        | Literal "-"; NUM n with precedence uminus -> MLconstpat(mlnum (- n))
        | MLIdent2 id ->  MLvarpat id
        | Literal "strict"; MLIdent2 id -> MLstrictpat (MLvarpat id)
(*         | Ol_program ol_exp; Literal ">>" -> expr_to_pat ol_exp *)
(*         | Literal "#"; IDENT x *)
(*             -> eval_macro_expr_MLpat (MLvar x) *)
(*         | Literal "#("; Expr e; Literal ")" *)
(*             -> eval_macro_expr_MLpat e *)
        | Literal "["; Pats ps; Literal "]" ->  mkpatlist ps
        | Literal "[|"; Pats ps; Literal "|]" -> mkpatvect ps
        | Literal "[<"; Pats ps; Literal ">]" -> mkpatseg ps
        | Literal "{"; Lab_pats ps; Literal "}" -> mkpatrecord ps
        | Literal "("; Pat p1; Literal ".."; Pat p2; Literal ")"
            -> mkmpairpat (p1,p2)
        | Literal "("; Pat p; Literal ")" -> p
        | Literal "(" ; Pat p; P_str str; Literal ")" -> MLstraintpat(p,str)
        | Bpat1 p; Literal "at"; IDENT id -> MLoccpat (p,id)
        | MLescape e -> expr_to_pat e

and Bpat =
    parse Bpat1 p1; Literal ","; Bpat p2 -> MLpairpat(p1,p2)
        | Bpat1 p -> p

and P_str =
    parse Literal ":"; Type ty -> ty
(*         | Literal "#:"; Expr e *)
(*             -> eval_macro_expr_MLtype e *)

and Pats =
    parse Pat p -> [p]
        | Pats ps; Literal ";"; Pat p -> p::ps

and Lab_pat =
    parse IDENT id; Literal "="; Pat p -> MLlabelpat (id,p)
        | IDENT id -> MLlabelpat (id,MLvarpat id)
        | Literal "_" -> MLlabelwildpat
 
and Lab_pats =
    parse Lab_pat lp -> [lp]
        | Lab_pats lps; Literal ";"; Lab_pat lp -> lp::lps

and Ce =
    parse NUM n -> mlnum n
        | INT i -> mlint i
        | FLOAT f -> mlfloat f
        | STRING s -> mlstring s
        | BOOL b -> mlbool b
        | Literal "("; Literal ")" -> mlnull
        | Literal "{"; Literal "}" -> mlnull

and Type1 =
    parse Var_ty vty -> MLvartyp vty
(*         | Esc_ty ety -> MLesctyp ety *)
        | MLescape e -> e
        | MLIdent2 const -> MLconsttyp(const,[])
        | Literal "("; Type ty; Literal ")" -> ty
        | Type1 tyarg; MLIdent2 tyco -> MLconsttyp(tyco,[tyarg])
        | Type1 tyarg; Literal "ref" -> MLconsttyp("ref", [tyarg])
        | Literal "("; Typel args; Type arg; Literal ")"; MLIdent2 ty
            -> MLconsttyp(ty,rev (arg::args))

and Typel =
    parse Typel tyl; Type ty; Literal "," -> ty::tyl
        | Type ty; Literal "," -> [ty]

and Type2 =
    parse Type1 ty1; Type_infixes tyi; Type2 ty2
            -> MLconsttyp(tyi,[ty1;ty2])
        | Type1 ty -> ty

and entry Type =
    parse Type tysrc; Literal ("->" as arrow); Type tygl
            -> MLconsttyp(arrow,[tysrc;tygl])
        | Type2 ty1; Literal ("*" as b_and); Type ty2
            -> MLconsttyp(b_and,[ty1;ty2])
        | Type2 ty -> ty

and Var_ty = parse Literal "'"; MLIdent var -> var

(* and Esc_ty = parse Literal "^"; MLIdent var -> atom_of_string var *)
(*                  | Literal "^"; Literal ("_" as var) -> atom_of_string var *)

and MLIdent = parse IDENT var -> var
                | Literal "["; Literal "]" -> ""
                | MLInfix i -> i

and MLIdent2 =
    parse IDENT var -> var
        | Literal "["; Literal "]" -> ""
        | Literal "prefix"; MLInfix i -> i

(* and MLIdent3 = *)
(*     parse IDENT var -> var *)
(*         | Literal "prefix"; MLInfix i -> i *)

(* En sursis ??
and MLIdent4 =
    parse IDENT var -> var
        | NUM n -> (match var with Int _ -> string_of_num n
                                 | _ -> raise parse "invalid occurence")
*)

and Inf =
    parse INFIX i -> i
        | Literal ("+" as p) -> p  | Literal ("&" as m) -> m
        | Literal ("/" as d) -> d  | Literal ("<=" as l) -> l
        | Literal (">=" as g) -> g | Literal ("<>" as d) -> d
        | Literal ("<" as l) -> l  | Literal (">" as g) -> g
        | Literal ("::" as c) -> c | Literal ("@" as a) -> a
        | Literal ("^" as c) -> c  | Literal ("or" as d) -> d

and Type_infixes =
    parse Inf i -> i | Literal ("-" as m) -> m | Literal (":=" as a) -> a

and MLInfixes = parse Type_infixes i -> i | Literal ("*" as a) -> a

and MLPrefixes = parse Literal ("not" as n) -> n | Literal ("!" as b) -> b

and MLInfix = parse MLInfixes i -> i | MLPrefixes p -> p

(* and Directive = parse Literal "directive"; Expr e -> Pragmaexp e *)
(*  *)
(* and Macro_decl = *)
(*     parse Literal "mlet"; Val_binding vb -> Pragmadecl vb *)
(*         | Literal "mlet"; Literal "rec"; Val_binding vb *)
(*             -> Pragmadecl (MLrec vb) *)

and Syntax =
    parse  Literal "<:"; IDENT sname; Literal ":"; IDENT ext; Literal "<"
            -> (sname,ext)
        | Literal "<:"; IDENT sname; Literal "<" -> (sname, "")

(* and entry Export_list = *)
(*     parse Export1 exp -> [exp] *)
(*         | Export_list expl; Literal ";"; Export1 exp -> exp::expl *)
(*  *)
(* and Export1 = *)
(*     parse Literal "value"; MLIdentl idl -> "value"::idl *)
(*         | Literal "type"; MLIdentl idl -> "type"::idl *)
(*         | Literal "abstype"; MLIdentl idl -> "abstype"::idl *)
(*         | Literal "exception"; MLIdentl idl -> "exception"::idl *)
(*  *)
(* and entry Import_list = *)
(*     parse Import2 imp -> imp,[] *)
(*         | Import2 imp; Literal "from"; File_list fl -> imp, rev fl *)
(*          *)
(* and File_list = parse STRING name -> [name] *)
(*                     | File_list fl; Literal ","; STRING name -> name::fl *)
(*  *)
(* and Import2 = parse Import1 imp -> [imp] *)
(*                   | Import2 impl; Literal ";"; Import1 imp -> imp::impl *)
(*  *)
(* and Import1 = *)
(*     parse Literal "value"; Straint_list strl -> MLlet(strl,MLconst mlnull) *)
(*         | Literal "type"; Type_binding tyl ->  MLtype (rev tyl) *)
(*         | Literal "type"; Type_name tyn -> MLtype [MLunknown_type tyn] *)
(*         | Literal "exception"; Exc_binding eb -> MLexception (rev eb) *)
(*  *)
(* and MLIdentl = parse MLIdent3 id -> [id] *)
(*                  | MLIdentl idl; Literal "and"; MLIdent3 id -> id::idl *)
(*  *)
(* and MLIdent3l = parse MLIdent3 id -> [id] *)
(*                   | MLIdent3l idl; Literal ","; MLIdent3 id -> id::idl *)
(*  *)
(* and Straint = *)
(*     parse MLIdent3 id; Literal ":"; Type ty ->  MLstraintpat(MLvarpat id,ty) *)
(*         | Literal "("; MLIdent3 id; Literal ":"; Type ty; Literal ")" *)
(*             -> MLstraintpat(MLvarpat id,ty) *)
(*  *)
(* and entry Straint_list = *)
(*     parse Straint str -> str *)
(*         | Straint_list strl; Literal "and"; Straint str -> MLpairpat(strl,str) *)
;;

let parse_CAML_Expr = (CAML "Expr").Parse_raw
and parse_CAML_MLnum = (CAML "MLnum").Parse_raw
and parse_CAML_MLstring = (CAML "MLstring").Parse_raw
and parse_CAML_MLbool = (CAML "MLbool").Parse_raw
and parse_CAML_MLint = (CAML "MLint").Parse_raw
and parse_CAML_MLfloat = (CAML "MLfloat").Parse_raw
and parse_CAML_MLvar = (CAML "MLvar").Parse_raw
and parse_CAML_Match = (CAML "Match").Parse_raw
and parse_CAML_Umatch = (CAML "Umatch").Parse_raw
and parse_CAML_Decl = (CAML "Decl").Parse_raw
and parse_CAML_Val_binding = (CAML "Val_binding").Parse_raw
and parse_CAML_Type_binding = (CAML "Type_binding").Parse_raw
and parse_CAML_Constr = (CAML "Constr").Parse_raw
and parse_CAML_Exc_binding = (CAML "Exc_binding").Parse_raw
and parse_CAML_Pat = (CAML "Pat").Parse_raw
and parse_CAML_Type = (CAML "Type").Parse_raw
;;

#end module
 with value parse_CAML_Expr
        and parse_CAML_MLnum
        and parse_CAML_MLstring
        and parse_CAML_MLbool
        and parse_CAML_MLint
        and parse_CAML_MLfloat
        and parse_CAML_MLvar
        and parse_CAML_Match
        and parse_CAML_Umatch
        and parse_CAML_Decl
        and parse_CAML_Val_binding
        and parse_CAML_Type_binding
        and parse_CAML_Constr
        and parse_CAML_Exc_binding
        and parse_CAML_Pat
        and parse_CAML_Type
        and CAML
;;
