(* Information attached to parsetree *)

(*
$File: Common/GrammarInfo.sml $
$Date: 1992/12/18 08:57:30 $
$Revision: 1.19 $
$Locker: birkedal $
*)

(*$GrammarInfo:
	SOURCE_INFO ERROR_INFO TYPE_INFO DF_INFO OVERLOADING_INFO CRASH PRETTYPRINT GRAMMAR_INFO
 *)

functor GrammarInfo(structure SourceInfo: SOURCE_INFO
		    structure ErrorInfo: ERROR_INFO
		    structure TypeInfo: TYPE_INFO
		    structure DFInfo: DF_INFO
		    structure OverloadingInfo: OVERLOADING_INFO

		    structure PP: PRETTYPRINT
		      sharing type SourceInfo.StringTree = TypeInfo.StringTree
				   = DFInfo.StringTree = OverloadingInfo.StringTree = PP.StringTree 

		    structure Crash: CRASH
		   ): GRAMMAR_INFO =
  struct
    type SourceInfo      = SourceInfo.info
     and ErrorInfo       = ErrorInfo.info
     and TypeInfo        = TypeInfo.info
     and DFInfo          = DFInfo.info
     and OverloadingInfo = OverloadingInfo.info

    datatype PreElabGrammarInfo =
      PRE_ELAB_GRAMMAR_INFO of {sourceInfo: SourceInfo Option,
				dfInfo: DFInfo Option
			       }

    datatype PostElabGrammarInfo =
      POST_ELAB_GRAMMAR_INFO of {preElabGrammarInfo: PreElabGrammarInfo,
				 errorInfo: ErrorInfo Option,
				 typeInfo: TypeInfo Option,
				 overloadingInfo: OverloadingInfo Option
				}

    val emptyPreElabGrammarInfo =
      PRE_ELAB_GRAMMAR_INFO{sourceInfo=None, dfInfo=None}

    fun convertGrammarInfo preElabGrammarInfo =
      POST_ELAB_GRAMMAR_INFO{preElabGrammarInfo=preElabGrammarInfo,
			     errorInfo=None, typeInfo=None, overloadingInfo=None
			    }

    val emptyPostElabGrammarInfo =
      convertGrammarInfo emptyPreElabGrammarInfo

    fun addPreElabSourceInfo (PRE_ELAB_GRAMMAR_INFO{sourceInfo=None, dfInfo}) i=
	  PRE_ELAB_GRAMMAR_INFO{sourceInfo=Some i, dfInfo=dfInfo}

      | addPreElabSourceInfo _ _ = Crash.impossible "addPreElabSourceInfo"


    fun addPreElabDFInfo (PRE_ELAB_GRAMMAR_INFO{sourceInfo, dfInfo=None}) i =
	  PRE_ELAB_GRAMMAR_INFO{sourceInfo=sourceInfo, dfInfo=Some i}

      | addPreElabDFInfo _ _ = Crash.impossible "addPreElabDFInfo"


    fun getPreElabSourceInfo(PRE_ELAB_GRAMMAR_INFO{sourceInfo=i, ...}) = i

    fun getPreElabDFInfo(PRE_ELAB_GRAMMAR_INFO{dfInfo=i, ...}) = i


    fun addPostElabErrorInfo (POST_ELAB_GRAMMAR_INFO{preElabGrammarInfo,
						     errorInfo=None, typeInfo, overloadingInfo
						    }) i =
	  POST_ELAB_GRAMMAR_INFO{preElabGrammarInfo=preElabGrammarInfo,
				 errorInfo=Some i, typeInfo=typeInfo, overloadingInfo=overloadingInfo
				}

      | addPostElabErrorInfo _ _ = Crash.impossible "addPostElabErrorInfo"


    fun addPostElabTypeInfo (POST_ELAB_GRAMMAR_INFO{preElabGrammarInfo,
						    errorInfo, typeInfo=None, overloadingInfo
						   }) i =
	  POST_ELAB_GRAMMAR_INFO{preElabGrammarInfo=preElabGrammarInfo,
				 errorInfo=errorInfo, typeInfo=Some i, overloadingInfo=overloadingInfo
				}

      | addPostElabTypeInfo _ _ = Crash.impossible "addPostElabTypeInfo"

    fun addPostElabOverloadingInfo (POST_ELAB_GRAMMAR_INFO{preElabGrammarInfo,
							   errorInfo, typeInfo, overloadingInfo}) i =
          POST_ELAB_GRAMMAR_INFO{preElabGrammarInfo=preElabGrammarInfo,
				 errorInfo=errorInfo, typeInfo=typeInfo, overloadingInfo= Some i}

    fun getPostElabSourceInfo(POST_ELAB_GRAMMAR_INFO{preElabGrammarInfo, ...}) =
      getPreElabSourceInfo preElabGrammarInfo

    fun getPostElabDFInfo(POST_ELAB_GRAMMAR_INFO{preElabGrammarInfo, ...}) =
      getPreElabDFInfo preElabGrammarInfo

    fun getPostElabErrorInfo(POST_ELAB_GRAMMAR_INFO{errorInfo=i, ...}) = i

    fun getPostElabTypeInfo(POST_ELAB_GRAMMAR_INFO{typeInfo=i, ...}) = i

    fun getPostElabOverloadingInfo(POST_ELAB_GRAMMAR_INFO{overloadingInfo=i, ...}) = i

    fun removePostElabOverloadingInfo(POST_ELAB_GRAMMAR_INFO{preElabGrammarInfo, errorInfo, typeInfo, overloadingInfo}) : PostElabGrammarInfo =
      POST_ELAB_GRAMMAR_INFO{preElabGrammarInfo = preElabGrammarInfo,
			     errorInfo = errorInfo,
			     overloadingInfo = None,
			     typeInfo = typeInfo}

    type StringTree = SourceInfo.StringTree
    val layoutSourceInfo = SourceInfo.layoutInfo
    val layoutDFInfo = DFInfo.layoutInfo
    val layoutErrorInfo = fn _ => PP.LEAF "<ErrorInfo>"
    val layoutTypeInfo = TypeInfo.layoutInfo
    val layoutOverloadingInfo = OverloadingInfo.layoutInfo

    fun perhaps layout (Some info) = layout info
      | perhaps _ None = PP.LEAF "NONE"

    fun layoutPreElabGrammarInfo(PRE_ELAB_GRAMMAR_INFO{sourceInfo, dfInfo}) =
      PP.NODE{start="PreElabGrammarInfo{",
	      finish="}",
	      indent=3,
	      children=[perhaps layoutSourceInfo sourceInfo,
			perhaps layoutDFInfo dfInfo
		       ],
	      childsep=PP.RIGHT "; "
	     }

    fun layoutPostElabGrammarInfo(
	  POST_ELAB_GRAMMAR_INFO{preElabGrammarInfo, errorInfo, typeInfo, overloadingInfo}
	) =
      PP.NODE{start="PostElabGrammarInfo{",
	      finish="}",
	      indent=3,
	      children=[layoutPreElabGrammarInfo preElabGrammarInfo,
			perhaps layoutErrorInfo errorInfo,
			perhaps layoutTypeInfo typeInfo,
			perhaps layoutOverloadingInfo overloadingInfo
		       ],
	      childsep=PP.RIGHT "; "
	     }
  end;
