(* Program basis - Definition v3 page 62 *)

(*
$File: Common/Basis.sml $
$Date: 1992/01/29 14:57:27 $
$Revision: 1.16 $
$Locker: birkedal $
*)

(*$Basis: INFIX_BASIS MODULE_ENVIRONMENTS DYNAMIC_BASIS BASIS*)
 
functor Basis(structure InfixBasis: INFIX_BASIS
	      structure ModuleEnvironments: MODULE_ENVIRONMENTS
	      structure DynamicBasis: DYNAMIC_BASIS
	     ): BASIS =
  struct
    type InfixBasis   = InfixBasis.Basis
    type StaticBasis  = ModuleEnvironments.Basis
    type DynamicBasis = DynamicBasis.Basis

    datatype Basis = BASIS of InfixBasis * StaticBasis * DynamicBasis

    val initialB =
      BASIS(InfixBasis.emptyB,
	    ModuleEnvironments.initialB,
	    DynamicBasis.initialBasis
	   )

    fun Inf_in_B IB =
      BASIS(IB, ModuleEnvironments.emptyB, DynamicBasis.emptyBasis)

    fun Stat_in_B SB =
      BASIS(InfixBasis.emptyB, SB, DynamicBasis.emptyBasis)

    fun Dyn_in_B DB =
      BASIS(InfixBasis.emptyB, ModuleEnvironments.emptyB, DB)

    fun Inf_of_B (BASIS(IB, _, _)) = IB
    fun Stat_of_B(BASIS(_, SB, _)) = SB
    fun Dyn_of_B (BASIS(_, _, DB)) = DB

    fun B_plus_B(BASIS(i, s, d), BASIS(i', s', d')) =
      BASIS(InfixBasis.compose(i, i'),
	    ModuleEnvironments.B_plus_B(s, s'),
	    DynamicBasis.B_plus_B(d, d')
	   )
  end;
