#ifndef Texture_hpp
#define Texture_hpp

#include "Bitmap.hpp"

namespace swShader
{
	class Rasterizer;
	class PixelPipeline;
	class PS_2_0Assembler;
	class VS_2_0Assembler;

	class Texture : public Bitmap
	{
		friend Rasterizer;
		friend PixelPipeline;
		friend PS_2_0Assembler;
		friend VS_2_0Assembler;

	public:
		Texture();
		Texture(int width, int height, int bitDepth = 32);
		Texture(const char *fileName);

		~Texture();

	protected:
		void createMipmaps();
		int mipmapsSize();
		void swapRedBlue();   // ABGR <-> ARGB

		unsigned int *mipmap[32];
		__int64 uInt[32];
		__int64 vInt[32];
		__int64 uFrac[32];
		__int64 vFrac[32];
		short uHalf[32][4];
		short vHalf[32][4];

	private:
		void initTables();
		void fillTrail();

		static void halveWidth(unsigned int *source, unsigned int *dest, int sourceWidth, int sourceHeight);
		static void halveHeight(unsigned int *source, unsigned int *dest, int sourceWidth, int sourceHeight);
		static void halveWidthHeight(unsigned int *source, unsigned int *dest, int sourceWidth, int sourceHeight);
	};
}

#endif   // Texture_hpp