#ifndef Rasterizer_hpp
#define Rasterizer_hpp

#include "Context.hpp"

namespace swShader
{
	class RenderTarget;
	struct XVertex;

	class Rasterizer : public Context
	{
	public:
		Rasterizer(const RenderTarget *renderTarget = 0);

		~Rasterizer();

		void renderTriangle(const XVertex *V1, const XVertex *V2, const XVertex *V3, FVFFlags FVF);

		void setRenderTarget(const RenderTarget *renderTarget);
		void setGlobalDetail(float detail);

	private:
		float textureDetail;   // Global mipmap bias
	};
}

#endif   // Rasterizer_hpp