$ verify = 'F$VERIFY(0)'
$!.. USERSEJOBS.COM
$ SET NOON
$ TELL := WRITE SYS$OUTPUT
$ GETUAF := $FERMI$EXE:GETUAF		!To access the UAC
$ job_file = p1 + ".JOB"		!Job procedure file to check for
$ job_type = ""
$ IF p1 .EQS. "EVERYNITE" THEN job_type = "DAILY"
$ IF p1 .EQS. "EVERYWEEK" THEN job_type = "WEEKLY"
$ IF p1 .EQS. "EVERYBOOT" THEN job_type = "ATBOOT"
$ IF p1 .EQS. "EVERYMNTH" THEN job_type = "MONTHLY"
$ IF job_type .EQS. "" THEN $ GOTO UNKNOWN_TYPE
$ OPEN/READ/SHARE=READ  DB  SYS$MANAGER:USERSEJOBS.DAT
$FILE_LOOP:				!Process database file until EOF
$ READ/END_OF_FILE=DONE  DB  record
$ record = F$EDIT( record, "COMPRESS,TRIM")
$ IF F$EXTRACT(0,1,record) .EQS. "!" THEN $ GOTO FILE_LOOP	!Ignore comment
$ user = F$ELEMENT( 0, " ", record)	!Username at start of record
$ enum = 1
$JTQ_LOOP:				!Process JTQ's of the record
$ jtq = F$ELEMENT( enum, " ", record)
$ IF jtq .EQS. " " THEN $ GOTO FILE_LOOP	!Record processing completed
$ jt = F$ELEMENT( 0, "=", jtq)		!Get job type from JTQ
$ IF jt .EQS. job_type THEN $ GOTO SUBMIT_JOB
$ enum = enum + 1			!Next JTQ for this user
$ IF jt .EQS. "DAILY" THEN $ GOTO JTQ_LOOP
$ IF jt .EQS. "WEEKLY" THEN $ GOTO JTQ_LOOP
$ IF jt .EQS. "ATBOOT" THEN $ GOTO JTQ_LOOP
$ IF jt .EQS. "MONTHLY" THEN $ GOTO JTQ_LOOP
$ TELL "%USERSJOBS-E-BADJOBTYP, unknown job type ",jtq," for user ",user
$ GOTO JTQ_LOOP
$SUBMIT_JOB:				!Submit EVERY*.JOB for this user!
$ ON ERROR THEN $ GOTO NO_SUCH_USER
$ GETUAF/DEVICE=disk/UIC=uic/DIRECTORY=dire/ACCOUNT=account  'user'
$ loginarea = disk + dire		!Look here for EVERY*.JOB
$ IF F$SEARCH( loginarea + job_file) .EQS. "" THEN $ GOTO NO_FILE_FOUND
$ qn = F$ELEMENT( 1, "=", jtq)		!Get queue name from JTQ
$ IF qn .EQS. "=" THEN qn = "SYS$BATCH"	!Default queue!
$ IF qn .EQS. "SHORT" THEN qn = "SHORT_JOBS"
$ IF qn .EQS. "LONG" THEN qn = "LONG_JOBS"
$ IF (qn .EQS. "SYSTEM") .AND. (job_type .NES. "ATBOOT") THEN $ GOTO NOT_AT_BOOT
$ IF qn .EQS. "SYSTEM" THEN qn = F$GETSYI( "NODENAME") + "_SYSTEM"
$ IF job_type .EQS. "ATBOOT" THEN qn = qn + " /PRIORITY=64"
$ TELL "%USERSJOBS-I-USERJOB, submitting job for ",user
$ ON ERROR THEN $ GOTO SUBMIT_FAILED
$ SUBMIT /NOPRINT /QUEUE='qn' /LOG_FILE='loginarea' /USER='user' -
	'loginarea''job_file'
$ GOTO FILE_LOOP			!Next user
$DONE:
$ CLOSE  DB
$ EXIT	F$VERIFY(verify).OR.1
$NO_FILE_FOUND:
$ TELL "%USERSJOBS-W-NOFILE, no ",job_file," found for ",user
$ GOTO FILE_LOOP
$SUBMIT_FAILED:
$ TELL "%USERSJOBS-F-SUBFAI, previous SUBMIT failure for user ",user
$ GOTO FILE_LOOP
$NO_SUCH_USER:
$ TELL "%USERSJOBS-F-NOUSER, no uaf entry for user ",user
$ GOTO FILE_LOOP
$NOT_AT_BOOT:
$ TELL "%USERSJOBS-F-NOTATBOOT, non-startup SYSTEM queue request for ",user
$ GOTO FILE_LOOP
$UNKNOWN_TYPE:
$ TELL "%USERSJOBS-F-UNKTYPE, unknown EVERY* job type '",p1,"'"
$ EXIT	F$VERIFY(verify).OR.1
$!============================================================================
$!+ USERSEJOBS
$! Submit user's EVERY* batch jobs by scanning the database in the file
$! SYS$MANAGER:USERSEJOBS.DAT.  The procedure call is:
$!
$!	@SYS$MGR_UTIL:USERSEJOBS  type
$!
$! where P1 indicates the type of job: EVERYNITE for nightly, EVERYWEEK for
$! weekly, EVERYMNTH for monthly jobs and EVERYBOOT for jobs to be executed
$! at system startup.  The EVERYBOOT jobs are commonly used to setup group
$! logical names at startup time at the behest of a group of users.
$!-
$! From P1: parameter setup file name of batch job, also determines which
$! job-type identifier will be searched for in the data file:
$!
$!		EVERYNITE --> EVERYNITE.JOB, "DAILY"
$!		EVERYWEEK --> EVERYWEEK.JOB, "WEEKLY"
$!		EVERYMNTH --> EVERYMNTH.JOB, "MONTHLY"
$!		EVERYBOOT --> EVERYBOOT.JOB, "ATBOOT"
$!
$! The job type/queue code (jtq) from the data file is "type[=queue]" where
$! type is given above and queue defaults to SYS$BATCH with "SHORT", and
$! "LONG" meaning SHORT_JOBS and LONG_JOBS respectively.  The queue type of
$! "ATBOOT=SYSTEM" permits jobs to be submitted into the node_SYSTEM queue
$! of the system just booted.  Each record of the data file starts with
$! the username followed by one or more jtq identifiers separated by spaces.
$!
$! Lines in the data file beginning with "!" are treated as comments and
$! ignored.
$!============================================================================
$! Author:  Frank J. Nagy, Fermilab Accelerator/Controls
$! Modifications:
$!  12-Nov-84	FJN	Created from EVERYNITE.COM
$!  07-Jun-85	FJN	Modified for VMS V4 where batch logs are not
$!			automatically created in the user's login area, and
$!			/USER= on SUBMIT replaces use of SETUSER program
$!  11-Jun-85	FJN	Modified format of data file to be more mnemonic
$!  12-Jun-85	FJN	Renamed to USERSEJOBS and debugged under V4
$!  14-Jul-85	FJN	Added ATBOOT[=queue] to trigger EVERYBOOT jobs
$!  28-Jul-85	FJN	Treat as comments .DAT lines beginning with "!"
