$ verify = 'F$VERIFY(0)'
$!.. MULTISUBMIT.COM			!Submit multiple jobs to all nodes
$!.. Description/history at end of file.
$ SUBMIT_JOB := SUBMIT /NOPRINT /USER=SYSMANAGER
$ which = F$GETSYI( "NODENAME")		!Which system is this?
$ opsys = which .EQS. "OPER"		!Set to TRUE if Operational system
$ dvsys = which .EQS. "DEVL"		!Set to TRUE if Development system
$ acsys = which .EQS. "ADCALC"		!Set to TRUE if Calculational system
$ devl_cluster = dvsys .OR. acsys	!TRUE if known VAXCluster node
$!
$! Remove /ONLINE from queue-type parameter and remember setting.
$!
$ if_online = F$ELEMENT( 1, "/", p1)
$ p1 = p1 - "/" - if_online
$ always = if_online .NES. "ONLINE"
$!
$ IF devl_cluster THEN $ GOTO VAXCLUSTER
$ IF opsys THEN $ SUBMIT_JOB /QUEUE=OPER_'p1'	'p2'
$ EXIT	F$VERIFY(verify).OR.1
$VAXCLUSTER:
$ IF F$GETSYI( "CLUSTER_MEMBER", "DEVL") .OR. always THEN  -
$	SUBMIT_JOB /QUEUE=DEVL_'p1' /LOG_FILE=SYS0_MANAGER:	'p2'
$ IF F$GETSYI( "CLUSTER_MEMBER", "ADCALC") .OR. always THEN  -
$	SUBMIT_JOB /QUEUE=ADCALC_'p1' /LOG_FILE=SYS1_MANAGER:	'p2'
$ EXIT	F$VERIFY(verify).OR.1
$!=============================================================================
$!+ MULTISUBMIT
$! This procedure permits a system batch job to be executed on each node of the
$! cluster and serves to centralize the logic for that.  Jobs are only run
$! under the SYSMANAGER account but provision is made for providing additional
$! SUBMIT arguments (/NOPRINT is also always includes) and for specifying the
$! queue type:
$!
$!	@SYS$MGR_UTIL:MULTISUBMIT  queue-type  "submit-command-part"
$!
$! The queue-type is one of SYSTEM, LONG, BATCH or SHORT to which the node
$! names are tacked on as in "node_type".  The second argument are the
$! qualifiers and parameters for the SUBMIT command (beyond /NOPRINT, /USER
$! and /QUEUE).  If the qualifier /ONLINE is attached to the queue-type
$! parameter, the batch jobs are submitted to only those nodes which are
$! currently online and part of the VAXCluster.  The default is to always
$! submit the jobs to all nodes of the VAXCluster.
$!-
$!=============================================================================
$! Modifications:
$!  18-Oct-85	FJN	Created to simplify some EVERY* codes
$!  21-Oct-85	FJN	Modify to put DEVL/ADCALC .LOG files in their respective
$!			"SYS$MANAGER" areas.
