$ verify = 'F$VERIFY(0)'
$!.. MADDELETR.COM		Batch job to clean up disks...
$!.. Description/history at end of file
$ IF p1 .EQS. "SECONDARY_CALL" THEN $ GOTO SECONDARY_JOB
$ SET PROCESS /PRIORITY=2		!Above LONG_JOB priority!
$!
$! Select current system type (Development or Operational) based on the
$! SYSGEN SCSNODE parameter.
$!
$ which = F$GETSYI( "NODENAME")
$ opsys = which .EQS. "OPER"		!Set to TRUE if Operational system
$ dvsys = which .EQS. "DEVL"		!Set to TRUE if Development system
$ acsys = which .EQS. "ADCALC"		!Set to TRUE if Calculational system
$ IF which .EQS. "" THEN $ EXIT		!If not defined, unknown system...
$ devl_cluster = dvsys .OR. acsys
$ is_cluster = F$GETSYI( "CLUSTER_MEMBER")
$!
$ PURGE *DELETER.LOG			!Purge old version(s) of job .LOG files
$ self = F$ENVIRONMENT( "PROCEDURE")	!Get file spec for self
$ self = "CMN$MGR_UTIL:" + F$PARSE( self,,, "NAME") + F$PARSE( self,,, "TYPE")
$ IF verify THEN SET VERIFY
$ SET MESSAGE/NOFACILITY/NOIDENTIFCATION/NOSEVERITY
$ SET NOON				!Ignore all errors
$ SET PROCESS/PRIVILEGE=(BYPASS,SYSPRV)	!Bypass the file system protections!
$!
$! Setup some shorthand symbols
$!
$ KILL_1DAY := DELETE/MODIFIED/BEFORE=TODAY/LOG
$ KILL_2DAYS := DELETE/MODIFIED/BEFORE=YESTERDAY/LOG
$ KILL_4DAYS := DELETE/MODIFIED/BEFORE="YESTERDAY-3-00:00"/LOG
$ KILL_1WEEK := DELETE/MODIFIED/BEFORE="TODAY-7-00:00"/LOG
$ KILL_4WEEKS := DELETE/MODIFIED/BEFORE="TODAY-28-00:00"/LOG
$ KILL_8WEEKS := DELETE/MODIFIED/BEFORE="TODAY-56-00:00"/LOG
$ KILL_12WEEKS := DELETE/MODIFIED/BEFORE="TODAY-94-00:00"/LOG
$ KILL_EXPIRED := DELETE/BEFORE=TODAY/EXPIRED/LOG
$ KILL_ICE := DELETE/CREATED/BEFORE=YESTERDAY/LOG
$ PURGE := PURGE/LOG
$ GETUAF := $FERMI$EXE:GETUAF		!To access UAF file
$!
$! Make sure certain logical names are defined
$!
$ IF F$LOGICAL("S0") .EQS. "" THEN $ DEFINE  S0  SYS$SYSDEVICE:
$ IF p1 .EQS. "SECONDARY_JOB" THEN $ GOTO SECONDARY_JOB
$!
$!=============================================================================
$!
$! Now purge all the "garbage" files from all the directories (UFD and all
$! subdirectories) on the user disk(s).  Use a temporary procedure to do the
$! work.
$!
$!>>>>>>>>>>>>>>>>>>>>
$ CREATE UX.TMP
$ DECK
$ IF opsys THEN ux = "OP$USR" + F$STRING(p1) + ":"
$ IF devl_cluster THEN ux = "USR$DISK" + F$STRING(p1) + ":"
$ IF F$LOGICAL(ux - ":") .EQS. "" THEN $ EXIT
$ IF is_cluster THEN $ GOTO SUBMIT_UX
$@'self'  SECONDARY_CALL  'ux'
$ EXIT
$SUBMIT_UX:
$ SUBMIT /NOPRINT /QUEUE=LONG_JOBS /LOG_FILE=CMN$MANAGER: /NAME=U'p1'_DELETER -
	'self' /PARAMETER=(SECONDARY_JOB,'ux')
$ EXIT
$ EOD
$!>>>>>>>>>>>>>>>>>>>>
$ UX := @UX.TMP
$!
$ UX  1
$ UX  2
$ UX  3
$ UX  4
$ UX  5
$ UX  6
$ UX  7
$ UX  8
$ UX  9
$ UX  10
$ UX  11
$ UX  12
$!
$ DELETE  UX.TMP;*
$!
$!=============================================================================
$!
$! Now kill all the useless files on the system disk.
$! Also kill all .LOG and .ERR (OPER only) files 3 or more days old.
$!
$ KILL_2DAYS S0:[*...].;*,ATLNK.CMD;*,*.TMP;*,*.CRF;*,*.DIA;*,-
*.TM0;*,*.TM1;*,*.TM2;*,*.TM3;*,*.TM4;*,*.TM5;*,*.TM6;*,*.TM7;*,*.TM8;*,*.TM9;*
$ KILL_4DAYS S0:[*...]*.LOG;*
$ KILL_4DAYS S0:[*...]*.ERR;* /EXCLUDE=SPTBOL.ERR
$ KILL_ICE S0:[*...]%%%%%%%%.ICE;*
$ KILL_1WEEK S0:[*...]*.JOU;*,*.TJL;*
$!
$!=============================================================================
$!
$! Delete OPERATOR.SUM file which hasn't be written into for 8 weeks!
$!
$ KILL_8WEEKS SYS$MANAGER:OPERATOR.SUM;*
$!
$! Delete ACNET$EXE:NETCOMMON.DMP files older than 1 week.
$!
$ IF .NOT.acsys THEN $ KILL_1WEEK ACNET$EXE:NETCOMMON.DMP;*
$!
$!=============================================================================
$!
$! Now cleanup .LIS and .LST files on system disk and in RSX areas.
$!
$ KILL_2DAYS	SYS$SYSROOT:[*...]*.LIS;*,*.LST;*,-
		FERMI$ROOT:[*...]*.LIS;*,*.LST;*
$ IF devl_cluster THEN $ KILL_1WEEK	RSX$LIB_ROOT:[*...]*.LIS;*,*.LST;*,-
					RSX$LIB_ROOT:[*...]*.OBJ;*,-
					SYS$RSXROOT:[*...]*.LIS;*,*.LST;*,*.MAP;*
$!
$! Clean files from temporary subdirectories [.TMP].
$!
$ DELETE  SYS$SYSROOT:[SYSMGR.TMP]*.*;*
$!
$! Clean all files older than 4 days from the default DECNET account
$!
$ KILL_4DAYS  SYS_DECNET:*.*;*
$!
$!=============================================================================
$!
$! Delete any expired .OLD files.
$!
$ xnode = ""
$ IF opsys THEN xnode := "DEVL::"
$@FERMI$UTIL:DELEXPOLD  -
	SYS$SYSDEVICE:[FERMI...],SYS$SYSROOT:[SYSMGR...]	'xnode'NAGY
$!
$!=============================================================================
$!
$! Now purge areas on system disk.
$!
$ PURGE		SYS$MANAGER:*.COM,-
		SYS$SYSROOT:[SYSMGR.*...]*.*,-
		SYS$LIBRARY:,-
		SYS$MESSAGE:,-
		SYS$SYSROOT:[SYSHLP...],-
		[SYSMAINT...],-
		SYS$SYSDEVICE:[FERMI...]
$ IF opsys THEN $ GOTO PURGE_SKIP_DEVL_ONLY
$ IF devl_cluster THEN $ PURGE	SYS$SYSROOT:[SYSTEST...],-
				RSX$LIB_ROOT:[*...],-
				SYS$RSXROOT:[*...]
$PURGE_SKIP_DEVL_ONLY:
$!
$! Now purge ACNET areas: keep 2 versions on Operational system
$!
$ XPURGE = PURGE
$ IF opsys THEN XPURGE = PURGE + "/KEEP=2"
$!
$ IF .NOT.acsys THEN $ XPURGE  SYS$SYSROOT:[ACNET...]
$!=============================================================================
$! Delete real old system backup journals and usage monitoring files
$!
$ KILL_4WEEKS  SYS$SYSDEVICE:[MONITORIN]*.*;*
$ KILL_12WEEKS  SYS$SYSDEVICE:[BACKUPS]*.*;*
$ EXIT
$!
$! Clean files up on user pack.
$!
$SECONDARY_JOB:
$ KILL_2DAYS 'p2'[*...].;*,ATLNK.CMD;*,*.TMP;*,*.CRF;*,*.DIA;*,-
*.TM0;*,*.TM1;*,*.TM2;*,*.TM3;*,*.TM4;*,*.TM5;*,*.TM6;*,*.TM7;*,*.TM8;*,*.TM9;*
$ KILL_4DAYS 'p2'[*...]*.LOG;*,*.ERR;*
$ KILL_ICE 'p2'[*...]%%%%%%%%.ICE;*
$ KILL_1WEEK 'p2'[*...]*.JOU;*,*.TJL;*
$ IF opsys THEN KILL_EXPIRED 'p2'[*...]*.FM;*
$ EXIT
$!=============================================================================
$! MADDELETR.COM
$!
$!+ MADDELETR
$! This procedure is executed as a batch job early every morning (the job
$! is submitted by the EVERYNITE batch job) in order to clean up the system
$! and user disks by deleting selected files (see subtopic "Files").  A single
$! copy of the batch job log file is left in the CMN$MANAGER area.  The
$! procedure will either call itself recursively or re-submit itself as
$! secondary batch jobs to overlap and modularize operations.
$!
$!2 Secondary_Jobs
$! If executing on a VAXCluster, then the individual user disk purges are
$! done by separate sub-jobs which are submitted as if the procedure were
$! called by:
$!
$!	@MADDELETR  SECONDARY_JOB  disk
$!
$! These batch jobs will create log files Ux_MADDELETR.LOG which will be
$! left in SYS$MANAGER:.
$!
$!2 Recursive_Call
$! The procedure will call itself to modularize code.  In particular, the
$! actions performed by Secondary_Jobs on VAXClusters are performed by
$! recursive calls on non-cluster systems.  The call format is:
$!
$!	@MADDELETR  SECONDARY_CALL  disk	!Self-call form of SECONDARY_JOB
$!
$!2 Files
$! The following files older than one day (modification date is older than
$! midnight yesterday) from all directories on all disk packs:
$!
$!	ATLNK.CMD       (left from LINK/RSX11 commands)
$!	.;*             (left from MAC or TKB /CR usage)
$!	*.CRF           (left from MAC /CR usage)
$!	*.DIA		(compiler diagnostics used in LSEDIT)
$!	*.TMP           (general temporary files)
$!	*.TM0-9         (left by SOS commands)
$!
$! These files are deleted if more than 3 days have passed since the last change
$! (modification date again):
$!
$!	*.LOG           (left by BATCH jobs or FORK commands)
$!	*.ERR           (SYS$ERROR outputs of detached processes)
$!
$! These files are deleted if they created before midnight of the previous day:
$!
$!	xxxxxxxx.ICE    (files left by the ICE Editor)
$!
$! The following files are deleted 1 week after the last modification:
$!
$!	*.JOU            (journal files left by the EDT editor)
$!	*.TJL            (journal files left by the TPU editor)
$!
$! The following files are deleted when the file expiration date has been
$! passed:
$!
$!	*.FM             (OPER only, files marked for delete by FileMaster)
$!-
$!=============================================================================
$! Author:	Frank J. Nagy	Fermilab Accelerator/Controls
$! Modification History:
$!  11-Sep-81	FJN	Created
$!  25-Sep-81	FJN	Added MAP.DIF deletes
$!  28-Sep-81	FJN	modify to work with two user disks.
$!  07-Oct-81	FJN	Added system disk (.TMP files) and do 
$!			directory of .LOG files.
$!  08-Oct-81	FJN	Modified to delete files older than 1 day
$!			and include .LOG files (except on SYS$SYSDISK).
$!  22-Oct-81	FJN	Delete .LOG files from SYS$SYSDISK when 3 days
$!			old.
$!  23-Oct-81	FJN	Added deletes of *.TMn where n=0,1-9
$!  12-Jan-82	FJN	Modified to purge and delete all .LIS and .LST
$!			files from [NAGY...] on USR$DISK1:
$!  08-Feb-82	FJN	Add purge of [NETWORK] on system disk.
$!  01-May-82	FJN	Added purging of CNSAPPL/APL directories
$!  08-Jun-82	FJN	Added purging of FERMI* directories on system
$!			disk
$!  14-Jul-82	FJN	Delete files in [NAGY.TMP] after 1 day
$!  28-Jul-82	FJN	Prepared for VMS V3
$!  29-Jul-82	FJN	Added OPSYS definition for single version of procedure
$!			for both Operational and Development systems
$!  13-Aug-82	FJN	Delete all files in [SYSMGR.TMP] immediately?
$!  19-Aug-82	FJN	Moved command procedures into FERMI$EXE
$!  30-Aug-82	FJN	Use VMS V3 features
$!  05-Sep-82	FJN	Delete files from system monitoring area [MONITORIN]
$!			that are older than 4 weeks (28 days)
$!  24-Sep-82	FJN	Get rid of very old .JOU files (1 week).
$!  05-Nov-82	FJN	Add [VAXAPPL.TMP] to regular deletes.
$!  21-Nov-82	FJN	Operational system purges: keep 2 versions for now
$!  13-Mar-83	FJN	Add VAXNET and cleanup stuff
$!  13-Apr-83	FJN	Add deletes of old stuff in [.TMP] areas of the
$!			[V*] UFD's on the operational system.
$!  10-Jul-83	FJN	Delete old *.ERR files; prepare for user disks #2 on
$!			OPER and #3 on DEVL.  Provide for up to 5 user disks!
$!  11-Jul-83	FJN	Remove ":" from user disk logical names!
$!  13-Jul-83	FJN	Put ":" back into symbols, remove in F$LOGICAL call!
$!  23-Sep-83	FJN	Remove APLPURGE into separate batch job started from
$!			EVERYNITE by itself (under CNSAPPL account)
$!  03-Nov-83	FJN	Add purges of OPERATOR.SUM and [GUESTUSER].
$!  15-Nov-83	FJN	Delete expired files from several areas
$!  20-Nov-83	FJN	Fix up reporting of expired file deletion
$!  28-Nov-83	FJN	DBM is username, not DATABASE
$!  29-Nov-83	FJN	Expand .OLD deletes to [FERMI...] and [SYSMGR...]
$!  05-Dec-83	FJN	Fixup .OLD deletion reporting
$!  15-Dec-83	FJN	[.TMP] areas in VAXAPPL/AEOLUS/NAGY on both systems!
$!  01-Jan-84	FJN	Delete old .ICE files
$!  05-Feb-84	FJN	Add VAXAPPL to .OLD scan list
$!  20-Feb-84	FJN	Delete DLREADER.LOG files after 1 day
$!  05-Mar-84	FJN	Delete .ICE files based on creation date, delete old
$!			.LIS files from SPMUSER also
$!  25-Mar-84	FJN	Delete very old ACNET$EXE:NETCOMMON.DMP files
$!  13-Apr-84	FJN	Truncates files in OPER::OP$USR1:[TEVATRON.QPM]
$!  14-Jun-84	FJN	Combine lines to reduce image activations
$!  25-Jun-84	FJN	Delete .LOG and .ERR files before YESTERDAY-3 days,
$!			truncate OPER::[VTEVATRON...] files
$!  04-Jul-84	FJN	Modify user disk cleanups with temporary procedure,
$!			provide for more then 8 user disks
$!  21-Jul-84	FJN	Delete listing files from RSXLIB tree after modest
$!			period
$!  27-Jul-84	FJN	Wipe all SYS_DECNET files after a few days.
$!  19-Sep-84	FJN	Delete expired *.FM files on OPER::
$!  25-Sep-84	FJN	Also pickup in the [.STNDALONE] area under RSX$LIB:
$!  13-Nov-84	FJN	Removed much of the user-specific stuff to individual
$!			EVERYNITE jobs of the users
$!  28-Dec-84	FJN	Add customizations for Temporary ADCALC system
$!  09-Mar-85	FJN	Retain old BACKUP journal files for longer period
$!  14-Aug-85	FJN	If executed on a VAXCluster, run the user disk purges
$!			as separate jobs.
$!  16-Aug-85	FJN	Rewritten to modularize by using slave jobs, secondary
$!			batch jobs and self-calls.
$!  28-Aug-85	FJN	Added .TJL (TPU journals) treated just like .JOU files
$!  18-Oct-85	FJN	Purge all *DELETR.LOG files (MAD... and Ux_...), put
$!			Un_DELETER files in CMN$MANAGER and run those jobs in
$!			the LONG_JOBS batch queue
$!  25-Oct-85	FJN	Added .DIA files to delete lists; these files contain
$!			compilation diagnostics for use in LSE
$!  29-Oct-85	FJN	Fix *.TJL and fix "self" to work properly on OPER
