$!+++ Directory sorted in descending order by file size
$! See comments block at end of file for information about BIGFILE.
$ MUNG :== $SYS$SYSTEM:TECO MUNG
$ spec = p1
$ if "''spec'" .eqs. "" then spec = f$directory()
$ write sys$output "Listing directory BIGFILE.TMP..."
$ directory/out=bigfile.tmp/size 'spec
$ write sys$output "Formatting BIGFILE.TMP..."
$ MUNG SYS$COM:COPYDIR.TEC
$ write sys$output "Sorting BIGFILE.TMP..."
$ sort/key=(position:20,size:6,descending) bigfile.tmp bigfile.tmp
$ purge/nolog bigfile.tmp
$ define/user sys$input sys$command
$ LIST/DELETE BIGFILE.TMP
$ exit
$!
$!+++ BIGFILE.COM produces an output list of a directory (optionally with
$! subdirectories included) listing the files in the directories, sorted
$! in descending order by number of blocks. Output is to the terminal;
$! a file, BIGFILE.TMP, is produced; BIGFILE asks at the end if you want
$! to "Delete?". This refers to the sorted listing of the directory.
$! The LIST utility is used to list the result file. One screen is shown; to
$! see more, hit return; to exit, hit "X".
$!
$! USE: @BIGFILE {directory-spec} -- default lists current directory.
$!
$! AUTHOR: A. Watson
$!
