$ verify = 'F$VERIFY(0)'
$ GOTO L1$
$!
$! CMTCRYOVR.COM
$!
$!+ CMTCRYOVR
$! Carry comments from an old version of a FORTRAN INCLUDE file into
$! a new version of the same file.  This command procedure is designed
$! to work with INCLUDE files generated by the SDIFGENR command
$! procedure.  The command procedure is invoked by:
$!
$!	@FERMI$LIB:CMTCRYOVR  old_file  new_file  [out_file]
$!
$! where old_file is the file specification of the original INCLUDE
$! file (with comments) and new_file is the file specification of the
$! new (uncommented) INCLUDE file.  The command procedure creates a new
$! version of the new_file if an output file specification (out_file)
$! is not given.
$!-
$! Modification History:
$!  06-Aug-82	FJN	Created
$!  08-Aug-82	FJN	Creation completed
$!  08-Sep-82	FJN	Use VMS V3 features, add fixes and Ctrl-Y traps
$!  04-Oct-82	FJN	Keep (also) comments from new file
$!=============================================================================
$L1$:
$ ON CONTROL_Y THEN $ GOTO BREAK_OUT
$!
$! Open both files for input and open new version of "new" file for output.
$!
$ OPEN/READ  OLD:  'p1'
$ OPEN/READ  NEW:  'p2'
$ IF p3.EQS."" THEN p3 = p2
$ OPEN/WRITE  OUT:  'p3'
$!
$! Init to read records from both input files, also mark no EOF's seen.
$!
$ old_read = 1
$ new_read = 1
$ old_eof = 0
$ new_eof = 0
$READ_LOOP:
$!
$! Read records from one or both input files.
$!
$ IF new_read.AND.(.NOT.new_eof) THEN $ READ/END_OF_FILE=NEW_EOF  NEW:  new_rec
$ IF old_read.AND.(.NOT.old_eof) THEN $ READ/END_OF_FILE=OLD_EOF  OLD:  old_rec
$!
$! Ignore comment lines from NEW file and copy OLD file comment lines to OUT.
$! If neither record (OLD or NEW) is a comment line, check for a line that just
$! says "<tab>PARAMETER".
$!
$ IF old_eof THEN $ GOTO SKIP_OLD_READ
$ lor = F$LENGTH(old_rec)
$ IF lor.EQ.0 THEN $ GOTO OLD_COMMENT_LINE	!Treat blank as comment
$ t = F$EXTRACT(0,1,old_rec)
$ IF t.EQS."C" THEN $ GOTO OLD_COMMENT_LINE
$ IF old_rec.EQS."	PARAMETER" THEN $ GOTO OLD_PARAMETER_LINE
$SKIP_OLD_READ:
$ IF new_eof THEN $ GOTO SKIP_NEW_READ
$ lnr = F$LENGTH(new_rec)
$ IF lnr.EQ.0 THEN $ GOTO NEW_COMMENT_LINE	!Treat blank as comment
$ t = F$EXTRACT(0,1,new_rec)
$ IF t.EQS."C" THEN $ GOTO NEW_COMMENT_LINE
$ IF new_rec.EQS."	PARAMETER" THEN $ GOTO NEW_PARAMETER_LINE
$SKIP_NEW_READ:
$!
$ IF new_eof THEN $ GOTO IGNORE_OLD_SYMBOL
$ IF old_eof THEN $ GOTO COPY_NEW_SYMBOL
$!
$! Get symbol name from OLD record
$!
$ t = F$EXTRACT(2,2,old_rec)
$ IF (t.EQS."  ").OR.(t.EQS.", ") THEN old_sym := 'F$EXTRACT(4,lor,old_rec)'
$ IF t.EQS."AR" THEN old_sym := 'F$EXTRACT(11,lor,old_rec)'
$ l = F$LOCATE("=",old_sym)
$ old_sym := 'F$EXTRACT(0,l,old_sym)'
$!
$! Get symbol name from NEW record
$!
$ t = F$EXTRACT(2,2,new_rec)
$ IF (t.EQS."  ").OR.(t.EQS.", ") THEN new_sym := 'F$EXTRACT(4,lnr,new_rec)'
$ IF t.EQS."AR" THEN new_sym := 'F$EXTRACT(11,lnr,new_rec)'
$ l = F$LOCATE("=",new_sym)
$ new_sym := 'F$EXTRACT(0,l,new_sym)'
$!
$! Now do 3-way branch:
$!	old<new:  ignore OLD line and read another
$!	old=new:  add OLD comments to NEW line and write to OUT
$!	new>old:  write NEW line and read another
$!
$ IF old_sym.LTS.new_sym THEN $ GOTO IGNORE_OLD_SYMBOL
$ IF old_sym.GTS.new_sym THEN $ GOTO COPY_NEW_SYMBOL
$!
$! Add OLD comments to NEW, write resultant line to OUT and read records
$! from both input files.
$!
$ l = F$LOCATE("!",old_rec) + 	1	!Locate "!" (assume one in NEW also)
$ IF l.LT.lor THEN old_rec = F$EXTRACT(l,lor,old_rec)
$ IF l.GE.lor THEN old_rec = ""		!No comments
$ WRITE  OUT:  new_rec,old_rec
$ old_read = 1
$ new_read = 1
$ GOTO READ_LOOP
$!
$! Write NEW symbol line which has no OLD counterpart to OUT and read
$! another NEW record.
$!
$COPY_NEW_SYMBOL:
$!
$! Write NEW PARAMETER line to OUT and read another NEW record (only).
$!
$NEW_PARAMETER_LINE:
$!
$! Write NEW comment line to OUT and read another NEW record (only)
$!
$NEW_COMMENT_LINE:
$!
$ WRITE  OUT:  new_rec
$!
$! Read another NEW record, but not another OLD
$!
$ new_read = 1
$ old_read = 0
$ GOTO READ_LOOP
$!
$! Write OLD comment line to OUT and read another OLD record (only).
$!
$OLD_COMMENT_LINE:
$ WRITE  OUT:  old_rec
$!
$! Ignore OLD symbol line that is not in NEW file
$!
$IGNORE_OLD_SYMBOL:
$!
$! Ignore OLD PARAMETER line and read another from OLD
$!
$OLD_PARAMETER_LINE:
$ old_read = 1
$ new_read = 0
$ GOTO READ_LOOP
$!
$! Reached EOF on NEW file, continue with OLD file (gets the end comments)
$! but disable processing of NEW records.
$!
$NEW_EOF:
$ new_eof = 1
$ CLOSE NEW:
$ IF .NOT.old_eof THEN $ GOTO READ_LOOP
$ CLOSE OUT:
$ ASSIGN/USER_MODE  NLA0:  SYS$OUTPUT
$ EDIT/EDT/NOCOMMAND  'p3'
EXIT
$ EXIT	F$VERIFY(verify).OR.1
$!
$! Reached EOF on OLD file, process remainder of NEW file (if any).
$!
$OLD_EOF:
$ old_eof = 1
$ CLOSE OLD:
$ IF .NOT.new_eof THEN $ GOTO READ_LOOP
$ CLOSE OUT:
$ ASSIGN/USER_MODE  NLA0:  SYS$OUTPUT
$ EDIT/EDT/NOCOMMAND  'p3'
EXIT
$ EXIT	F$VERIFY(verify).OR.1
$!
$BREAK_OUT:
$ IF .NOT.old_eof THEN $ CLOSE OLD:
$ IF .NOT.new_eof THEN $ CLOSE NEW:
$ CLOSE OUT:
$ EXIT	F$VERIFY(verify).OR.1
