/*****************************************************************************

	ExeW()

	This function executes a W command.

	W	Scope "WATCH"
	n:W	Return scope characteristics
	m,n:W	Set scope characteristics

	TECO-C implements only the part of the W command relating to the
terminal type.

*****************************************************************************/

#include "zport.h"		/* define portability identifiers */
#include "tecoc.h"		/* define general identifiers */
#include "defext.h"		/* define external global variables */

#if VIDEO

#if USE_PROTOTYPES
static DEFAULT VGetW(void);
static DEFAULT VSetW(void);
static DEFAULT VDoW(void);
#endif

#include "dscren.h"		/* define screen identifiers */
#include <string.h>		/* prototype for strlen() */

static DEFAULT VGetW()		/* execute an n:W command */
{
	DBGFEN(1,"VGetW",NULL);
	DBGFEX(1,DbgFNm,"PushEx()");
	return PushEx(	NArgmt==0 ? CrType :
			NArgmt==1 ? HtSize :
			NArgmt==2 ? VtSize :
			NArgmt==3 ? SeeAll :
			NArgmt==4 ? MrkFlg :
			NArgmt==5 ? HldFlg :
			NArgmt==6 ? TopDot :
			NArgmt==7 ? ScroLn : 0    , OPERAND);
}



static DEFAULT VSetW()		/* execute an m,n:W command */
{
	DBGFEN(1,"VSetW",NULL);

/*
 * Use an if here instead of a "default" case because doing a switch will
 * cast the variable to an "int",  causing Turbo-C to warn about types.
 */

	if ((NArgmt < 0) || (NArgmt > 7)) {
		return ExeNYI();
	}

	switch ((int)NArgmt) {
	    case 0:
		if ((MArgmt < 0) || (MArgmt > 13) ||
		    (MArgmt == 3) ||
		    (MArgmt == 5) ||
		    (MArgmt == 7) ||
		    (MArgmt == 9)) {
			ZDspBf("Illegal terminal type.", 22);
			ZDspBf("  Terminal types are:\r\n", 23);
			ZDspBf("\t0\t= VT52\r\n", 11);
			ZDspBf("\t1\t= VT61\r\n", 11);
			ZDspBf("\t2\t= VT100 in VT52 mode\r\n", 25);
			ZDspBf("\t4\t= VT100 in VT100 mode\r\n", 26);
			ZDspBf("\t6\t= VT05\r\n", 11);
			ZDspBf("\t8\t= VT102\r\n", 12);
			ZDspBf("\t10\t= VK100\r\n", 13);
			ZDspBf("\t11\t= VT200 in VT200 mode\r\n", 27);
			ZDspBf("\t12\t= VT200 in ANSI (VT100) mode\r\n", 34);
			ZDspBf("\t13\t= VT200 in VT52 mode\r\n", 26);
			CrType = (DEFAULT)MArgmt;
			return FAILURE;
		}
		CrType = (DEFAULT)MArgmt;
		break;

	    case 1:	if (ZSetTT(TTWIDTH, (DEFAULT)MArgmt) == FAILURE)
			    return FAILURE;
			HtSize = (DEFAULT)MArgmt; break;
	    case 2:	if (ZSetTT(TTHEIGHT, (DEFAULT)MArgmt) == FAILURE)
			    return FAILURE;
			VtSize = (DEFAULT)MArgmt; break;
	    case 3:	SeeAll = (DEFAULT)MArgmt; break;
	    case 4:	MrkFlg = (DEFAULT)MArgmt; break;
	    case 5:	HldFlg = (DEFAULT)MArgmt; break;
	    case 6:	TopDot = (DEFAULT)MArgmt; break;
	    case 7:	ScroLn = (DEFAULT)MArgmt; break;
	} /* end of switch */

	DBGFEX(1,DbgFNm,"SUCCESS");
	return SUCCESS;
}


static DEFAULT VDoW()		/* execute an nW command */
{
    DBGFEN(1,"VDoW",NULL);

#if DEBUGGING
    if (NArgmt == -1) {
	printf("VDoW: -1W refreshing the screen\r\n");
    } else if (NArgmt == 0) {
	printf("VDoW: 0W Placing default cursor line at 16. Forgetting.\r\n");
    } else if (NArgmt == -1000) {
	printf("VDoW: -1000W Forgetting output was done.\r\n");
    } else if (NArgmt < 0) {
	printf("VDoW: %ldW telling refresher top %ld lines are altered.\r\n",
		NArgmt, -NArgmt-1);
    } else {
	printf("VDoW: %ldW Placing def. cursor at line %ld. Forgetting.\r\n",
		NArgmt, NArgmt);
    }

    DBGFEX(1,DbgFNm,"SUCCESS");
    return SUCCESS;
#else
    return ExeNYI();
#endif
}
#endif /* VIDEO */



DEFAULT ExeW()			/* execute an W command */
{
	DBGFEN(1,"ExeW",NULL);

/*
 * If the terminal is not a scope,  don't do anything.
 */
	if (!(EtFlag & ET_WAT_SCOPE)) {		/* if scope not available */
		DBGFEX(1,DbgFNm,"FAILURE");
		return FAILURE;
	}

#if VIDEO

	if (EStTop == EStBot) {			/* if no numeric argument */
		NArgmt = (CmdMod & COLON) ? 0 : 16;
	} else {
		if (GetNmA() == FAILURE) {	/* get the numeric argument */
			DBGFEX(1,DbgFNm,"FAILURE");
			return FAILURE;
		}
	}

	if (CmdMod & COLON) {			/* if it's :W */
		if (NArgmt < 0) {		/* insert processing? */
			return ExeNYI();
		} else {
			if (CmdMod & MARGIS) {	/* if it's m,n:W */
				if (VSetW() == FAILURE) {
					DBGFEX(1,DbgFNm,"FAILURE");
					return FAILURE;
				}
				EStTop = EStBot;/* clear expression stack */
			} else {		/* else (must be n:W) */
				if (VGetW() == FAILURE) {
					DBGFEX(1,DbgFNm,"FAILURE");
					return FAILURE;
				}
			}
		}
	} else {				/* else there's no colon */
		if (VDoW() == FAILURE) {
			DBGFEX(1,DbgFNm,"FAILURE");
			return FAILURE;
		}
		EStTop = EStBot;		/* clear expression stack */
		CmdMod &= ~COLON;		/* clear colon modifier */
	}

	DBGFEX(1,DbgFNm,"SUCCESS");
	return SUCCESS;

#else /* not VIDEO */

	DBGFEX(1,DbgFNm,"ExeNYI()");
	return ExeNYI();

#endif /* VIDEO */
}
