#ifndef LINT
/* @(#) prterror.c 2.8 88/01/31 18:48:17 */
static char sccsid[]="@(#) prterror.c 2.8 88/01/31 18:48:17";
#endif /* LINT */

/*
The contents of this file are hereby released to the public domain.

                                 -- Rahul Dhesi 1986/11/14

*/
#include "options.h"
#ifndef	OK_STDIO
#include <stdio.h>
#define	OK_STDIO
#endif
#include "various.h"
/* General error handler.  Input format:

   parameter 1:  'w', 'e', or 'f'.

      'm':  message
      'M':  message without preceding identification
      'w':  WARNING
      'e':  ERROR
      'f':  FATAL
      'F':  FATAL but program doesn't exist immediately

   All text printed is preceded by "Zoo:  " or "Ooz:  "  depending
   upon conditional compilation, except in the case of 'M' messages
   which are printed without any text being added.

   For messages, the text supplied is printed if and only if the global
   variable "quiet" is zero.  Control then returns to the caller.

   For warnings, errors, and fatal errors, the variable "quiet" is used
	as follows.  Warning messages are suppressed if quiet > 1;  error
	messages are suppressed if quiet > 2.  Fatal error messages are 
	never suppressed--doing so would be a bit risky.

   For warnings and errors, the error message is preceded by the "WARNING:"
   or "ERROR".  The error message is printed and control returns to the
   caller.

   For fatal errors, the error message is preceded by "FATAL:" and an
   error message is printed.  If the option was 'f', the program exits with 
   a status of 1.  If the option was 'F', control returns to the caller and 
   it is assumed that the caller will do any cleaning up necessary and then 
   exit with an error status.

   parameter 2:  The format control string for printf.   
   parameters 3 and 4 are passed along to printf.

	NOTE
   (a) printf() is always supplied parameters 3 through 6, even if they 
	were not on the parameter list passed to prterror().  It is assumed 
	that printf() will only use as many as are specified by the format 
	string.  There is a small chance that on some machines, this will cause 
	some kind of stack exception (e.g. if the hardware maintains tag 
	bits in each word on the stack and doesn't allow certain types of 
	data to be arbitrarily accessed).  This is just a theory so far.

	(b) Parameter passing relies on consecutive small parameters being
	properly interpreted as a single larger parameter when needed.
	Eventually var_args should be used, but not all systems probably
	have it at the moment.

	(c) All messages, whether informative or error, are sent to standard
	output via printf.  It might be a good idea to eventually send 'e' and
	'f' class messages to the standard error stream.  Best would be
	some way of telling if standard output and standard error are not
	the same device, so that we could always send error messages to
	standard error, and also duplicate them to standard output if 
	different from standard error.  There seems to be no way
	of doing this in the general case.
*/

extern int quiet;

/* These declarations must be equivalent to those in errors.i */
char no_match[] = "No files matched.\n";
char failed_consistency[] = "Archive header failed consistency check.\n";
char invalid_header[] = "Invalid or corrupted archive.\n";
char internal_error[]="Internal error.\n";
char disk_full[]      = "I/O error or disk full.\n";
char bad_directory[]  = "Directory entry in archive is invalid.\n";
char no_memory[] = "Ran out of memory.\n";
char too_many_files[] = "Some filenames ignored -- can only handle %d.\n";
char packfirst[] = "Old format archive -- please pack first with P command.\n";
char garbled[] = "Command is garbled.\n";
char start_ofs[] = "Starting at %ld (offset %ld)\n";

#ifndef OOZ
char wrong_version[]=
   "Zoo %d.%d or later is needed to fully manipulate this archive.\n";
char cant_process[] =
   "The rest of the archive (%lu bytes) cannot be processed.\n";
char option_ignored[] = "Ignoring option %c.\n";
char inv_option[] = "Option %c is invalid.\n";
char bad_crc[] = "\007Bad CRC, %s probably corrupted\n";
#endif

#ifdef OOZ
char could_not_open[] = "Could not open ";
#else
char could_not_open[] = "Could not open %s.\n";
#endif

#ifdef LINT_ARGS
/* defined in zoofns.h but we don't want to include that and waste time */
void prterror (int, char *, MORE);
void zooexit (int);
#endif


/*VARARGS2*/
void prterror(level, format, a, b, c, d)
register int level;
char *format, *a, *b, *c, *d;

{
   char string[120];       /* local format string */
   *string = '\0';         /* get a null string to begin with */

#ifdef OOZ
   strcpy (string, "Ooz:  ");
#else
   strcpy (string, "Zoo:  ");
#endif

   switch (level) {
      case 'M': *string = '\0';                    /* fall through to 'm' */
      case 'm': if (quiet) return; break;
      case 'w': 
			if (quiet > 1) return;
			strcat (string, "WARNING:  "); break;
      case 'e': 
			if (quiet > 2) return;
			strcat (string, "ERROR:  ");   break;
      case 'F':
      case 'f': strcat (string, "FATAL:  ");   break;
      default: prterror ('f', internal_error);  /* slick recursive call */
   }

   strcat (string, format);      /* just append supplied message */

   printf (string, a, b, c, d);   /* and print the whole thing */
	fflush (stdout);

   if (level == 'f')       /* and abort on fatal error 'f' but not 'F' */
      zooexit (1);
}
