#include "/sys/ins/base.ins.c"
#include "/sys/ins/ios.ins.c"
#include "/sys/ins/rws.ins.c"

#include "v2.h"
#include "v2d.h"

v2_$export(hpp, bp, sizep, lenp, stp)
v2_handle_t **hpp;
char *bp;
short *sizep, *lenp;
status_$t *stp;
{
	v2_handle_t *hp;

	v2_$pre_fork(hpp, stp);
	if (stp->all != status_$ok)
		return;

	*lenp = sizeof (v2_handle_t);
	if (*lenp > *sizep)
		return;

	hp = *hpp;

	bcopy(hp, bp, sizeof (v2_handle_t));
	v2_$post_fork(hpp, stp);
}

v2_$import(bp, hpp, stp)
char *bp;
v2_handle_t **hpp;
status_$t *stp;
{
	v2_handle_t *hp;
	int n;

	hp = (v2_handle_t *) rws_$alloc_heap_pool(rws_$stream_tm_pool, (long) sizeof (v2_handle_t));
	if (hp == NULL) {
		stp->all = ios_$insuff_memory;
		return;
	}
	bcopy(bp, hp, sizeof (v2_handle_t));

	hp->sock_fd = v2_sconnect(&(hp->xoid), stp);
	if (stp->all != status_$ok)
		return;

	putlong(C_OPEN);
	n = strlen(hp->name);
	putlong(n);
	putbytes(hp->name, n);
	putlong(hp->read_only ? 0 : 2);
	if ((n = getlong()) < 0) {
		v2_sclose(hp);
		stp->all = v2_tr_errno(n);
		return;
	}
	*hpp = hp;
	stp->all = status_$ok;
}

v2_$pre_fork(hpp, stp)
v2_handle_t **hpp;
status_$t *stp;
{
	/* no seek keys yet */
	stp->all = status_$ok;
}

v2_$post_fork(hpp, stp)
v2_handle_t **hpp;
status_$t *stp;
{
	/* no ref counts yet */
	stp->all = status_$ok;
}
