#include <sys/types.h>
#include <sys/stat.h>

#include "/sys/ins/base.ins.c"
#include "/sys/ins/ios.ins.c"

#include "v2.h"
#include "v2d.h"

v2_$inq_byte_pos(hpp, pos_optp, stp)
v2_handle_t **hpp;
ios_$pos_opt_t *pos_optp;
status_$t *stp;
{
	struct attr atb;
	long key;

	stp->all = status_$ok;

	if (*pos_optp == ios_$bof)
		return 0;

	if (*pos_optp == ios_$current)
		return v2_$i_seek(*hpp, ios_$relative, 0L, stp);

	if (*pos_optp == ios_$eof) {
		if (v2_$stat(*hpp, &atb) < 0) {
			stp->all = v2_tr_errno(-1);
			return -1;
		}
		return atb.size;
	}

	stp->all = ios_$illegal_param_comb;
	return -1;
}

v2_$seek(hpp, abs_relp, typep, keyp, stp)
v2_handle_t **hpp;
ios_$abs_rel_t *abs_relp;
ios_$seek_type_t *typep;
long *keyp;
status_$t *stp;
{
	if (*typep != ios_$byte_seek) {
		stp->all = ios_$illegal_param_comb;
		return;
	}
	v2_$i_seek(*hpp, *abs_relp, *keyp, stp);
}

v2_$i_seek(hp, abs_rel, key, stp)
v2_handle_t *hp;
ios_$abs_rel_t abs_rel;
long key;
status_$t *stp;
{
	int how;
	long ret;

	stp->all = status_$ok;

	if (abs_rel == ios_$relative)
		hp->seek_key += key;
	else
		hp->seek_key = key;
	hp->seek_key_valid = false;
	return hp->seek_key;
}

long
v2_$real_seek(hp)
v2_handle_t *hp;
{
	long ret;

	if (hp->seek_key_valid)
		return hp->seek_key;

	putlong(C_SEEK);
	putlong(hp->seek_key);
	putlong(0);
	if ((ret = getlong()) < 0)
		ret = -1;
	else {
		hp->seek_key = ret;
		hp->seek_key_valid = true;
	}
	return ret;
}

v2_$inq_short_key(hpp, pos_optp, stp)
v2_handle_t **hpp;
ios_$pos_opt_t *pos_optp;
status_$t *stp;
{
	return v2_$inq_byte_pos(hpp, pos_optp, stp) + 1;
}

v2_$inq_full_key(hpp, pos_optp, keyp, stp)
v2_handle_t **hpp;
ios_$pos_opt_t *pos_optp;
ios_$seek_key_t *keyp;
status_$t *stp;
{
	keyp->rec_adr = v2_$inq_byte_pos(hpp, pos_optp, stp) + 1;
	keyp->byte_adr = 0;
}

v2_$seek_full_key(hpp, keyp, stp)
v2_handle_t **hpp;
ios_$seek_key_t *keyp;
status_$t *stp;
{
	v2_$i_seek(*hpp, ios_$absolute, keyp->rec_adr - 1, stp);
}

v2_$seek_short_key(hpp, keyp, stp)
v2_handle_t **hpp;
long *keyp;
status_$t *stp;
{
	v2_$i_seek(*hpp, ios_$absolute, *keyp - 1, stp);
}

v2_$seek_to_bof(hpp, stp)
v2_handle_t **hpp;
status_$t *stp;
{
	v2_$i_seek(*hpp, ios_$absolute, 0L, stp);
}

v2_$seek_to_eof(hpp, stp)
v2_handle_t **hpp;
status_$t *stp;
{
	v2_handle_t *hp;
	int n;

	stp->all = status_$ok;
	hp = *hpp;

	putlong(C_SEEK);
	putlong(0);
	putlong(2);
	if ((n = getlong()) < 0)
		stp->all = v2_tr_errno(-1);
	else {
		hp->seek_key = n;
		hp->seek_key_valid = true;
	}
}
