#include "/sys/ins/base.ins.c"
#include "/sys/ins/ios.ins.c"

#include "v2.h"
#include "v2d.h"

ios_$mgr_flag_set
v2_$inq_mgr_flags(hpp, stp)
v2_handle_t **hpp;
status_$t *stp;
{
	stp->all = status_$ok;

	return (ios_$mgr_flag_set)
	    ( (int) ios_$mf_create_mask
	    | (int) ios_$mf_create_bak_mask
	    | (int) ios_$mf_imex_mask
	    | (int) ios_$mf_fork_mask
	    | (int) ios_$mf_write_mask
	    | (int) ios_$mf_seek_abs_mask
	    | (int) ios_$mf_seek_short_mask
	    | (int) ios_$mf_seek_full_mask
	    | (int) ios_$mf_seek_byte_mask
	    | (int) ios_$mf_seek_rec_mask
	    | (int) ios_$mf_seek_bof_mask
	    | (int) ios_$mf_rec_type_mask
	    | (int) ios_$mf_truncate_mask
	    | (int) ios_$mf_unregulated_mask
	    | (int) ios_$mf_sparse_mask
	    | (int) ios_$mf_read_intend_write_mask);
}

ios_$conn_flag_set
v2_$inq_conn_flags(hpp, stp)
v2_handle_t **hpp;
status_$t *stp;
{
	v2_handle_t *hp;
	ios_$conn_flag_set flags;

	hp = *hpp;
	flags = 0;

	if (hp->unreg)
		flags |= ios_$cf_unregulated_mask;
	if (hp->append_mode)
		flags |= ios_$cf_append_mask;
	if (!hp->read_only)
		flags |= ios_$cf_write_mask;

	stp->all = status_$ok;
	return flags;
}

v2_$set_conn_flag(hpp, fp, boolp, stp)
v2_handle_t **hpp;
ios_$conn_flag_t *fp;
boolean *boolp;
status_$t *stp;
{
	v2_handle_t *hp;

	hp = *hpp;

	if (hp->inq_only) {
		stp->all = ios_$inq_only_error;
		return;
	}
	stp->all = status_$ok;

	switch (*fp) {

	case ios_$cf_append:
		hp->append_mode = *boolp;
		break;

	case ios_$cf_read_intend_write:
	case ios_$cf_write:
		if (*boolp && hp->cant_write)
			stp->all = ios_$insufficient_rights;
		else
			hp->read_only = *boolp ? false : true;
		break;

	case ios_$cf_unregulated:
		hp->unreg = *boolp;
		break;

	default:
		stp->all = ios_$illegal_operation;
		break;
	}
}

ios_$obj_flag_set
v2_$inq_obj_flags(hpp, stp)
v2_handle_t **hpp;
status_$t *stp;
{
	v2_handle_t *hp;
	ios_$obj_flag_set flags;

	hp = *hpp;
	flags = ios_$of_sparse_ok_mask;

	if (hp->delete)
		flags |= ios_$of_delete_on_close_mask;

	if (hp->type == v2f_$uid)
		flags |= ios_$of_ascii_mask;

	stp->all = status_$ok;
	return flags;
}

v2_$set_obj_flag(hpp, fp, boolp, stp)
v2_handle_t **hpp;
ios_$obj_flag_t *fp;
boolean *boolp;
status_$t *stp;
{
	v2_handle_t *hp;

	hp = *hpp;

	if (hp->inq_only) {
		stp->all = ios_$inq_only_error;
		return;
	}
	stp->all = status_$ok;

	switch (*fp) {

	case ios_$of_delete_on_close:
		hp->delete = *boolp;
		break;

	case ios_$of_ascii:
		/* /bin/ld depends on this */
		stp->all = status_$ok;
		break;

	case ios_$of_sparse_ok:
		if (!(*boolp))
			stp->all = ios_$illegal_operation;
		break;

	case ios_$of_ftncc:
		if (*boolp)
			stp->all = ios_$illegal_operation;
		break;

	default:
		stp->all = ios_$illegal_operation;
		break;
	}
}
