#include <stdio.h>
#include <ctype.h>

#define COMMENT '#'
#define ENTERSHELL '!'
#define EXTRACT	"/bin/sh"

main(argc,argv)

int	argc;
char	*argv[];
{
	FILE	*shstream, *popen();
	FILE	*input;
	int	header, ifile = 1;
	char	*getfline(), *line;

	do {
		if ((input = (argc == 1) ? stdin : fopen( argv[ifile],"r")) == NULL) {
			perror( "unshar" );
			exit( 1 );
		}

		header = 1;
	
		while ((line = getfline(input)) != NULL && !is_start(line)) {
			if (header) {
				printf( "Skipping...\n");
				header = 0;
			}
			fprintf( stdout,"%s\n",line );
		}

		shstream = popen( "/bin/sh","w" );

		fprintf( stdout,"Begin extraction...\n" );
		while ((line = getfline(input)) != NULL)
			fprintf( shstream,"%s\n",line );

		(void)pclose( shstream );
		if (input != stdin) (void)fclose( input );

	} while (++ifile < argc);
}

int
is_start( line )

char	*line;
{

	if (*line == '\0') return(0);
	while (isspace(*line)) line++;

	if (*line != '\0' && *line++ != COMMENT) return(0);

	while (isspace(*line)) line++;

	if (*line != '\0' && *line++ != ENTERSHELL) return(0);

	while (isspace(*line)) line++;

	if (*line == '\0') return(0);
	if (strncmp( line,EXTRACT,strlen(EXTRACT) ) != 0) return(0);

	return( 1 );
}
