
# line 35 "ftpcmd.y"

#ifndef lint
static char sccsid[] = "@(#)ftpcmd.y	5.13 (Berkeley) 11/30/88";
#endif /* not lint */

#include <sys/types.h>
#include <sys/socket.h>

#include <netinet/in.h>

#include <arpa/ftp.h>

#include <stdio.h>
#include <signal.h>
#include <ctype.h>
#include <pwd.h>
#include <setjmp.h>
#include <syslog.h>

extern	struct sockaddr_in data_dest;
extern	int logged_in;
extern	struct passwd *pw;
extern	int guest;
extern	int logging;
extern	int commandtrace;
extern	int type;
extern	int form;
extern	int debug;
extern	int timeout;
extern  int pdata;
extern	char hostname[];
extern	char *globerr;
extern	int usedefault;
extern	int unique;
extern  int transflag;
extern  char tmpline[];
char	**glob();

static	int cmd_type;
static	int cmd_form;
static	int cmd_bytesz;
char cbuf[512];
char *fromname;

char	*index();
# define A 257
# define B 258
# define C 259
# define E 260
# define F 261
# define I 262
# define L 263
# define N 264
# define P 265
# define R 266
# define S 267
# define T 268
# define SP 269
# define CRLF 270
# define COMMA 271
# define STRING 272
# define NUMBER 273
# define USER 274
# define PASS 275
# define ACCT 276
# define REIN 277
# define QUIT 278
# define PORT 279
# define PASV 280
# define TYPE 281
# define STRU 282
# define MODE 283
# define RETR 284
# define STOR 285
# define APPE 286
# define MLFL 287
# define MAIL 288
# define MSND 289
# define MSOM 290
# define MSAM 291
# define MRSQ 292
# define MRCP 293
# define ALLO 294
# define REST 295
# define RNFR 296
# define RNTO 297
# define ABOR 298
# define DELE 299
# define CWD 300
# define LIST 301
# define NLST 302
# define SITE 303
# define STAT 304
# define HELP 305
# define NOOP 306
# define XMKD 307
# define XRMD 308
# define XPWD 309
# define XCUP 310
# define STOU 311
# define LEXERR 312
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern int yyerrflag;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
#ifndef YYSTYPE
#define YYSTYPE int
#endif
YYSTYPE yylval, yyval;
typedef int yytabelem;
# define YYERRCODE 256

# line 515 "ftpcmd.y"


extern jmp_buf errcatch;

#define	CMD	0	/* beginning of command */
#define	ARGS	1	/* expect miscellaneous arguments */
#define	STR1	2	/* expect SP followed by STRING */
#define	STR2	3	/* expect STRING */
#define	OSTR	4	/* optional STRING */

struct tab {
	char	*name;
	short	token;
	short	state;
	short	implemented;	/* 1 if command is implemented */
	char	*help;
};

struct tab cmdtab[] = {		/* In order defined in RFC 765 */
	{ "USER", USER, STR1, 1,	"<sp> username" },
	{ "PASS", PASS, STR1, 1,	"<sp> password" },
	{ "ACCT", ACCT, STR1, 0,	"(specify account)" },
	{ "REIN", REIN, ARGS, 0,	"(reinitialize server state)" },
	{ "QUIT", QUIT, ARGS, 1,	"(terminate service)", },
	{ "PORT", PORT, ARGS, 1,	"<sp> b0, b1, b2, b3, b4" },
	{ "PASV", PASV, ARGS, 1,	"(set server in passive mode)" },
	{ "TYPE", TYPE, ARGS, 1,	"<sp> [ A | E | I | L ]" },
	{ "STRU", STRU, ARGS, 1,	"(specify file structure)" },
	{ "MODE", MODE, ARGS, 1,	"(specify transfer mode)" },
	{ "RETR", RETR, STR1, 1,	"<sp> file-name" },
	{ "STOR", STOR, STR1, 1,	"<sp> file-name" },
	{ "APPE", APPE, STR1, 1,	"<sp> file-name" },
	{ "MLFL", MLFL, OSTR, 0,	"(mail file)" },
	{ "MAIL", MAIL, OSTR, 0,	"(mail to user)" },
	{ "MSND", MSND, OSTR, 0,	"(mail send to terminal)" },
	{ "MSOM", MSOM, OSTR, 0,	"(mail send to terminal or mailbox)" },
	{ "MSAM", MSAM, OSTR, 0,	"(mail send to terminal and mailbox)" },
	{ "MRSQ", MRSQ, OSTR, 0,	"(mail recipient scheme question)" },
	{ "MRCP", MRCP, STR1, 0,	"(mail recipient)" },
	{ "ALLO", ALLO, ARGS, 1,	"allocate storage (vacuously)" },
	{ "REST", REST, STR1, 0,	"(restart command)" },
	{ "RNFR", RNFR, STR1, 1,	"<sp> file-name" },
	{ "RNTO", RNTO, STR1, 1,	"<sp> file-name" },
	{ "ABOR", ABOR, ARGS, 1,	"(abort operation)" },
	{ "DELE", DELE, STR1, 1,	"<sp> file-name" },
	{ "CWD",  CWD,  OSTR, 1,	"[ <sp> directory-name]" },
	{ "XCWD", CWD,	OSTR, 1,	"[ <sp> directory-name ]" },
	{ "LIST", LIST, OSTR, 1,	"[ <sp> path-name ]" },
	{ "NLST", NLST, OSTR, 1,	"[ <sp> path-name ]" },
	{ "SITE", SITE, STR1, 0,	"(get site parameters)" },
	{ "STAT", STAT, OSTR, 0,	"(get server status)" },
	{ "HELP", HELP, OSTR, 1,	"[ <sp> <string> ]" },
	{ "NOOP", NOOP, ARGS, 1,	"" },
	{ "MKD",  XMKD, STR1, 1,	"<sp> path-name" },
	{ "XMKD", XMKD, STR1, 1,	"<sp> path-name" },
	{ "RMD",  XRMD, STR1, 1,	"<sp> path-name" },
	{ "XRMD", XRMD, STR1, 1,	"<sp> path-name" },
	{ "PWD",  XPWD, ARGS, 1,	"(return current directory)" },
	{ "XPWD", XPWD, ARGS, 1,	"(return current directory)" },
	{ "CDUP", XCUP, ARGS, 1,	"(change to parent directory)" },
	{ "XCUP", XCUP, ARGS, 1,	"(change to parent directory)" },
	{ "STOU", STOU, STR1, 1,	"<sp> file-name" },
	{ NULL,   0,    0,    0,	0 }
};

struct tab *
lookup(cmd)
	char *cmd;
{
	register struct tab *p;

	for (p = cmdtab; p->name != NULL; p++)
		if (strcmp(cmd, p->name) == 0)
			return (p);
	return (0);
}

#include <arpa/telnet.h>

/* 
 * Determine whether s2 is a substring of s1.
 * If this is the case return a pointer to the first character
 *   of the first match occurance.
 * If there's no such substring then return NULL
 */
char *
strindex(s1, s2)
	 char *s1, *s2;
{
	/* first search for a character in s1 which matches a char in s2 */
	while ( (s1=index(s1,s2[0])) != NULL) {
		/* now check for a complete match of the string in s2 
		 * using *tmp makes it possible to restart where we   
		 * previously left off				      
		 */
		char *tmp=s1;
		while ((*tmp!='\0')&&(*s2!='\0')&&(*tmp==*s2)) {
			tmp++;
			s2++;
		}
		/* Now check if the substring was found */
		if ((*tmp=='\0')&&(*s2=='\0')) 
			return s1;
		/* Set s1 for the next search */
		s1++;
	}
	/* there are no more matches */
	return NULL;
}
/*
 * getline - a hacked up version of fgets to ignore TELNET escape codes.
 */

#define GUESTTRACE(s) (guest && commandtrace \
			&& strindex(s, "PASS")==NULL \
			&& strindex(s, "PORT")==NULL \
			)


char *
getline(s, n, iop)
	char *s;
	register FILE *iop;
{
	register c;
	register char *cs;

	cs = s;
/* tmpline may contain saved command from urgent mode interruption */
	for (c = 0; tmpline[c] != '\0' && --n > 0; ++c) {
		*cs++ = tmpline[c];
		if (tmpline[c] == '\n') {
			*cs++ = '\0';
			if (debug|| GUESTTRACE(s)) {
				/* do not log passwords */
				syslog(LOG_DEBUG, "FTPD: command: %s", s);
			}
			tmpline[0] = '\0';
			return(s);
		}
		if (c == 0) {
			tmpline[0] = '\0';
		}
	}
	while (--n > 0 && (c = getc(iop)) != EOF) {
		while ((0377&c) == IAC) {
			switch (0377&(c = getc(iop))) {
			case WILL:
			case WONT:
				c = getc(iop);
				printf("%c%c%c", IAC, WONT, 0377&c);
				(void) fflush(stdout);
				break;
			case DO:
			case DONT:
				c = getc(iop);
				printf("%c%c%c", IAC, DONT, 0377&c);
				(void) fflush(stdout);
				break;
			default:
				break;
			}
			c = getc(iop); /* try next character */
		}
		*cs++ = 0377&c;
		if ((0377&c) == '\n')
			break;
	}
	if (c == EOF && cs == s)
		return (NULL);
	*cs++ = '\0';
	if (debug|| GUESTTRACE(s) ) {
		/* Do not log passwords */
		syslog(LOG_DEBUG, "FTPD: command: %s", s);
	}
	return (s);
}

static int
toolong()
{
	time_t now;
	extern char *ctime();
	extern time_t time();

	reply(421,
	  "Timeout (%d seconds): closing control connection.", timeout);
	(void) time(&now);
	if (logging) {
		syslog(LOG_INFO,
			"FTPD: User %s timed out after %d seconds at %s",
			(pw ? pw -> pw_name : "unknown"), timeout, ctime(&now));
	}
	dologout(1);
}

yylex()
{
	static int cpos, state;
	register char *cp;
	register struct tab *p;
	int n;
	char c, *strpbrk();

	for (;;) {
		switch (state) {

		case CMD:
			(void) signal(SIGALRM, toolong);
			(void) alarm((unsigned) timeout);
			if (getline(cbuf, sizeof(cbuf)-1, stdin) == NULL) {
				reply(221, "You could at least say goodbye.");
				dologout(0);
			}
			(void) alarm(0);
			if ((cp = index(cbuf, '\r'))) {
				*cp++ = '\n'; *cp = '\0';
			}
			if ((cp = strpbrk(cbuf, " \n")))
				cpos = cp - cbuf;
			if (cpos == 0) {
				cpos = 4;
			}
			c = cbuf[cpos];
			cbuf[cpos] = '\0';
			upper(cbuf);
			p = lookup(cbuf);
			cbuf[cpos] = c;
			if (p != 0) {
				if (p->implemented == 0) {
					nack(p->name);
					longjmp(errcatch,0);
					/* NOTREACHED */
				}
				state = p->state;
				yylval = (int) p->name;
				return (p->token);
			}
			break;

		case OSTR:
			if (cbuf[cpos] == '\n') {
				state = CMD;
				return (CRLF);
			}
			/* FALL THRU */

		case STR1:
			if (cbuf[cpos] == ' ') {
				cpos++;
				state = STR2;
				return (SP);
			}
			break;

		case STR2:
			cp = &cbuf[cpos];
			n = strlen(cp);
			cpos += n - 1;
			/*
			 * Make sure the string is nonempty and \n terminated.
			 */
			if (n > 1 && cbuf[cpos] == '\n') {
				cbuf[cpos] = '\0';
				yylval = copy(cp);
				cbuf[cpos] = '\n';
				state = ARGS;
				return (STRING);
			}
			break;

		case ARGS:
			if (isdigit(cbuf[cpos])) {
				cp = &cbuf[cpos];
				while (isdigit(cbuf[++cpos]))
					;
				c = cbuf[cpos];
				cbuf[cpos] = '\0';
				yylval = atoi(cp);
				cbuf[cpos] = c;
				return (NUMBER);
			}
			switch (cbuf[cpos++]) {

			case '\n':
				state = CMD;
				return (CRLF);

			case ' ':
				return (SP);

			case ',':
				return (COMMA);

			case 'A':
			case 'a':
				return (A);

			case 'B':
			case 'b':
				return (B);

			case 'C':
			case 'c':
				return (C);

			case 'E':
			case 'e':
				return (E);

			case 'F':
			case 'f':
				return (F);

			case 'I':
			case 'i':
				return (I);

			case 'L':
			case 'l':
				return (L);

			case 'N':
			case 'n':
				return (N);

			case 'P':
			case 'p':
				return (P);

			case 'R':
			case 'r':
				return (R);

			case 'S':
			case 's':
				return (S);

			case 'T':
			case 't':
				return (T);

			}
			break;

		default:
			fatal("Unknown state in scanner.");
		}
		yyerror((char *) 0);
		state = CMD;
		longjmp(errcatch,0);
	}
}

upper(s)
	register char *s;
{
	while (*s != '\0') {
		if (islower(*s))
			*s = toupper(*s);
		s++;
	}
}

copy(s)
	char *s;
{
	char *p;
	extern char *malloc(), *strcpy();

	p = malloc((unsigned) strlen(s) + 1);
	if (p == NULL)
		fatal("Ran out of memory.");
	(void) strcpy(p, s);
	return ((int)p);
}

help(s)
	char *s;
{
	register struct tab *c;
	register int width, NCMDS;

	width = 0, NCMDS = 0;
	for (c = cmdtab; c->name != NULL; c++) {
		int len = strlen(c->name) + 1;

		if (len > width)
			width = len;
		NCMDS++;
	}
	width = (width + 8) &~ 7;
	if (s == 0) {
		register int i, j, w;
		int columns, lines;

		lreply(214,
	  "The following commands are recognized (* =>'s unimplemented).");
		columns = 76 / width;
		if (columns == 0)
			columns = 1;
		lines = (NCMDS + columns - 1) / columns;
		for (i = 0; i < lines; i++) {
			printf("   ");
			for (j = 0; j < columns; j++) {
				c = cmdtab + j * lines + i;
				printf("%s%c", c->name,
					c->implemented ? ' ' : '*');
				if (c + lines >= &cmdtab[NCMDS])
					break;
				w = strlen(c->name) + 1;
				while (w < width) {
					putchar(' ');
					w++;
				}
			}
			printf("\r\n");
		}
		(void) fflush(stdout);
		reply(214, "Direct comments to wjw@eb.ele.tue.nl.");
		return;
	}
	upper(s);
	c = lookup(s);
	if (c == (struct tab *)0) {
		reply(502, "Unknown command %s.", s);
		return;
	}
	if (c->implemented)
		reply(214, "Syntax: %s %s", c->name, c->help);
	else
		reply(214, "%-*s\t%s; unimplemented.", width, c->name, c->help);
}

yytabelem yyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
	};
# define YYNPROD 59
# define YYLAST 215
yytabelem yyact[]={

    29,   106,   150,   148,   146,   108,   144,   108,   125,    78,
    64,    89,    92,    62,    60,   107,   149,   147,     4,     5,
   145,   143,    28,     6,     7,     8,     9,    10,    12,    13,
    14,   102,    91,    90,    85,    84,    83,    82,    11,   142,
    30,    18,    19,    17,    20,    16,    15,    49,    48,    21,
    22,    23,    24,    25,    26,    27,   141,   140,   139,   138,
   137,   136,   135,   134,   133,   132,   129,   120,   118,   111,
   110,   127,   109,   103,   101,   128,   100,    87,    99,    96,
    95,    57,    56,    50,    46,    34,   105,   104,    98,    97,
    94,    93,    86,    81,    80,    79,    76,    77,    45,    38,
    37,    36,    35,    33,    32,    75,    31,    71,   126,    39,
    66,    73,    72,    67,    88,    68,    69,    74,    70,    65,
    63,    61,   131,    40,    41,    42,    43,    44,    59,     3,
    47,     2,     1,    51,    52,    53,    54,    55,     0,     0,
    58,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,   112,   113,   114,
     0,   115,     0,   116,   117,     0,     0,     0,     0,   119,
     0,   121,   122,     0,     0,   123,   124,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,   130 };
yytabelem yypact[]={

 -1000,  -256, -1000, -1000,  -163,  -165,  -166,  -185,  -167,  -168,
  -169,  -170, -1000, -1000, -1000, -1000, -1000, -1000,  -171,  -186,
 -1000,  -222,  -187, -1000, -1000, -1000, -1000, -1000,  -188,  -189,
 -1000,  -258,  -259,  -263, -1000,  -147,  -154,  -162,  -264,  -174,
  -175,  -176,  -233,  -235,  -177,  -261, -1000,  -237, -1000,  -260,
 -1000,  -178,  -179,  -190,  -191,  -180, -1000, -1000,  -181,  -192,
 -1000,  -194, -1000,  -196,  -240,  -197,  -182,  -183, -1000,  -268,
  -198, -1000, -1000, -1000,  -200, -1000, -1000, -1000,  -201,  -261,
  -261,  -261, -1000,  -261, -1000,  -261,  -261,  -202, -1000, -1000,
 -1000,  -261,  -203,  -261,  -261, -1000, -1000,  -261,  -261, -1000,
 -1000, -1000,  -265, -1000,  -193,  -193,  -266, -1000, -1000, -1000,
 -1000, -1000,  -205,  -206,  -207,  -208,  -209,  -210, -1000,  -211,
 -1000,  -212,  -213,  -214,  -231,  -250, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000,  -267,  -251,  -269,  -254,  -270,  -255,  -271,
 -1000 };
yytabelem yypgo[]={

     0,   132,   131,   129,   128,   121,   120,   119,   118,   117,
   109,    77,    15,   108,   114 };
yytabelem yyr1[]={

     0,     1,     1,     1,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     3,     4,     5,    12,     6,    13,
    13,    13,     7,     7,     7,     7,     7,     7,     7,     7,
     8,     8,     8,     9,     9,     9,    11,    14,    10 };
yytabelem yyr2[]={

     0,     0,     5,     4,     9,     9,     9,     5,     9,     9,
     9,     9,    11,    11,    11,     7,    11,     7,    11,    11,
     9,     5,     7,    11,     5,     9,     5,    11,    11,     7,
     7,    11,     5,     5,    11,     2,     2,     2,    23,     3,
     3,     3,     3,     7,     3,     7,     3,     3,     7,     5,
     3,     3,     3,     3,     3,     3,     3,     2,     1 };
yytabelem yychk[]={

 -1000,    -1,    -2,    -3,   274,   275,   279,   280,   281,   282,
   283,   294,   284,   285,   286,   302,   301,   299,   297,   298,
   300,   305,   306,   307,   308,   309,   310,   311,   278,   256,
   296,   269,   269,   269,   270,   269,   269,   269,   269,   -10,
   -10,   -10,   -10,   -10,   -10,   269,   270,   -10,   270,   269,
   270,   -10,   -10,   -10,   -10,   -10,   270,   270,   -10,    -4,
   272,    -5,   272,    -6,   273,    -7,   257,   260,   262,   263,
    -8,   261,   266,   265,    -9,   267,   258,   259,   273,   269,
   269,   269,   270,   269,   270,   269,   269,   -11,   -14,   272,
   270,   269,   272,   269,   269,   270,   270,   269,   269,   270,
   270,   270,   271,   270,   269,   269,   269,   -12,   273,   270,
   270,   270,   -11,   -11,   -11,   -11,   -11,   -11,   270,   -11,
   270,   -11,   -11,   -11,   -11,   273,   -13,   264,   268,   259,
   -13,   -12,   270,   270,   270,   270,   270,   270,   270,   270,
   270,   270,   270,   271,   273,   271,   273,   271,   273,   271,
   273 };
yytabelem yydef[]={

     1,    -2,     2,     3,     0,     0,     0,     0,     0,     0,
     0,     0,    58,    58,    58,    58,    58,    58,     0,     0,
    58,     0,     0,    58,    58,    58,    58,    58,     0,     0,
    58,     0,     0,     0,     7,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,    21,     0,    24,     0,
    26,     0,     0,     0,     0,     0,    32,    33,     0,     0,
    35,     0,    36,     0,     0,     0,    42,    44,    46,    47,
     0,    50,    51,    52,     0,    53,    54,    55,     0,     0,
     0,     0,    15,     0,    17,     0,     0,     0,    56,    57,
    22,     0,     0,     0,     0,    29,    30,     0,     0,     4,
     5,     6,     0,     8,     0,     0,     0,    49,    37,     9,
    10,    11,     0,     0,     0,     0,     0,     0,    20,     0,
    25,     0,     0,     0,     0,     0,    43,    39,    40,    41,
    45,    48,    12,    13,    14,    16,    18,    19,    23,    27,
    28,    31,    34,     0,     0,     0,     0,     0,     0,     0,
    38 };
typedef struct { char *t_name; int t_val; } yytoktype;
#ifndef YYDEBUG
#	define YYDEBUG	0	/* don't allow debugging */
#endif

#if YYDEBUG

yytoktype yytoks[] =
{
	"A",	257,
	"B",	258,
	"C",	259,
	"E",	260,
	"F",	261,
	"I",	262,
	"L",	263,
	"N",	264,
	"P",	265,
	"R",	266,
	"S",	267,
	"T",	268,
	"SP",	269,
	"CRLF",	270,
	"COMMA",	271,
	"STRING",	272,
	"NUMBER",	273,
	"USER",	274,
	"PASS",	275,
	"ACCT",	276,
	"REIN",	277,
	"QUIT",	278,
	"PORT",	279,
	"PASV",	280,
	"TYPE",	281,
	"STRU",	282,
	"MODE",	283,
	"RETR",	284,
	"STOR",	285,
	"APPE",	286,
	"MLFL",	287,
	"MAIL",	288,
	"MSND",	289,
	"MSOM",	290,
	"MSAM",	291,
	"MRSQ",	292,
	"MRCP",	293,
	"ALLO",	294,
	"REST",	295,
	"RNFR",	296,
	"RNTO",	297,
	"ABOR",	298,
	"DELE",	299,
	"CWD",	300,
	"LIST",	301,
	"NLST",	302,
	"SITE",	303,
	"STAT",	304,
	"HELP",	305,
	"NOOP",	306,
	"XMKD",	307,
	"XRMD",	308,
	"XPWD",	309,
	"XCUP",	310,
	"STOU",	311,
	"LEXERR",	312,
	"-unknown-",	-1	/* ends search */
};

char * yyreds[] =
{
	"-no such reduction-",
	"cmd_list : /* empty */",
	"cmd_list : cmd_list cmd",
	"cmd_list : cmd_list rcmd",
	"cmd : USER SP username CRLF",
	"cmd : PASS SP password CRLF",
	"cmd : PORT SP host_port CRLF",
	"cmd : PASV CRLF",
	"cmd : TYPE SP type_code CRLF",
	"cmd : STRU SP struct_code CRLF",
	"cmd : MODE SP mode_code CRLF",
	"cmd : ALLO SP NUMBER CRLF",
	"cmd : RETR check_login SP pathname CRLF",
	"cmd : STOR check_login SP pathname CRLF",
	"cmd : APPE check_login SP pathname CRLF",
	"cmd : NLST check_login CRLF",
	"cmd : NLST check_login SP pathname CRLF",
	"cmd : LIST check_login CRLF",
	"cmd : LIST check_login SP pathname CRLF",
	"cmd : DELE check_login SP pathname CRLF",
	"cmd : RNTO SP pathname CRLF",
	"cmd : ABOR CRLF",
	"cmd : CWD check_login CRLF",
	"cmd : CWD check_login SP pathname CRLF",
	"cmd : HELP CRLF",
	"cmd : HELP SP STRING CRLF",
	"cmd : NOOP CRLF",
	"cmd : XMKD check_login SP pathname CRLF",
	"cmd : XRMD check_login SP pathname CRLF",
	"cmd : XPWD check_login CRLF",
	"cmd : XCUP check_login CRLF",
	"cmd : STOU check_login SP pathname CRLF",
	"cmd : QUIT CRLF",
	"cmd : error CRLF",
	"rcmd : RNFR check_login SP pathname CRLF",
	"username : STRING",
	"password : STRING",
	"byte_size : NUMBER",
	"host_port : NUMBER COMMA NUMBER COMMA NUMBER COMMA NUMBER COMMA NUMBER COMMA NUMBER",
	"form_code : N",
	"form_code : T",
	"form_code : C",
	"type_code : A",
	"type_code : A SP form_code",
	"type_code : E",
	"type_code : E SP form_code",
	"type_code : I",
	"type_code : L",
	"type_code : L SP byte_size",
	"type_code : L byte_size",
	"struct_code : F",
	"struct_code : R",
	"struct_code : P",
	"mode_code : S",
	"mode_code : B",
	"mode_code : C",
	"pathname : pathstring",
	"pathstring : STRING",
	"check_login : /* empty */",
};
#endif /* YYDEBUG */
#ident	"@(#)yacc:yaccpar	1.10"
/* @(#)yaccpar	4.1  - 88/11/17 */

/*
** Skeleton parser driver for yacc output
*/

/*
** yacc user known macros and defines
*/
#define YYERROR		goto yyerrlab
#define YYACCEPT	return(0)
#define YYABORT		return(1)
#define YYBACKUP( newtoken, newvalue )\
{\
	if ( yychar >= 0 || ( yyr2[ yytmp ] >> 1 ) != 1 )\
	{\
		yyerror( "syntax error - cannot backup" );\
		goto yyerrlab;\
	}\
	yychar = newtoken;\
	yystate = *yyps;\
	yylval = newvalue;\
	goto yynewstate;\
}
#define YYRECOVERING()	(!!yyerrflag)
#ifndef YYDEBUG
#	define YYDEBUG	1	/* make debugging available */
#endif

/*
** user known globals
*/
int yydebug;			/* set to 1 to get debugging */

/*
** driver internal defines
*/
#define YYFLAG		(-1000)

/*
** global variables used by the parser
*/
YYSTYPE yyv[ YYMAXDEPTH ];	/* value stack */
int yys[ YYMAXDEPTH ];		/* state stack */

YYSTYPE *yypv;			/* top of value stack */
int *yyps;			/* top of state stack */

int yystate;			/* current state */
int yytmp;			/* extra var (lasts between blocks) */

int yynerrs;			/* number of errors */
int yyerrflag;			/* error recovery flag */
int yychar;			/* current input token number */



/*
** yyparse - return 0 if worked, 1 if syntax error not recovered from
*/
int
yyparse()
{
	register YYSTYPE *yypvt;	/* top of value stack for $vars */

	/*
	** Initialize externals - yyparse may be called more than once
	*/
	yypv = &yyv[-1];
	yyps = &yys[-1];
	yystate = 0;
	yytmp = 0;
	yynerrs = 0;
	yyerrflag = 0;
	yychar = -1;

	goto yystack;
	{
		register YYSTYPE *yy_pv;	/* top of value stack */
		register int *yy_ps;		/* top of state stack */
		register int yy_state;		/* current state */
		register int  yy_n;		/* internal state number info */

		/*
		** get globals into registers.
		** branch to here only if YYBACKUP was called.
		*/
	yynewstate:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;
		goto yy_newstate;

		/*
		** get globals into registers.
		** either we just started, or we just finished a reduction
		*/
	yystack:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;

		/*
		** top of for (;;) loop while no reductions done
		*/
	yy_stack:
		/*
		** put a state and value onto the stacks
		*/
#if YYDEBUG
		/*
		** if debugging, look up token value in list of value vs.
		** name pairs.  0 and negative (-1) are special values.
		** Note: linear search is used since time is not a real
		** consideration while debugging.
		*/
		if ( yydebug )
		{
			register int yy_i;

			printf( "State %d, token ", yy_state );
			if ( yychar == 0 )
				printf( "end-of-file\n" );
			else if ( yychar < 0 )
				printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ++yy_ps >= &yys[ YYMAXDEPTH ] )	/* room on stack? */
		{
			yyerror( "yacc stack overflow" );
			YYABORT;
		}
		*yy_ps = yy_state;
		*++yy_pv = yyval;

		/*
		** we have a new state - find out what to do
		*/
	yy_newstate:
		if ( ( yy_n = yypact[ yy_state ] ) <= YYFLAG )
			goto yydefault;		/* simple state */
#if YYDEBUG
		/*
		** if debugging, need to mark whether new token grabbed
		*/
		yytmp = yychar < 0;
#endif
		if ( ( yychar < 0 ) && ( ( yychar = yylex() ) < 0 ) )
			yychar = 0;		/* reached EOF */
#if YYDEBUG
		if ( yydebug && yytmp )
		{
			register int yy_i;

			printf( "Received token " );
			if ( yychar == 0 )
				printf( "end-of-file\n" );
			else if ( yychar < 0 )
				printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ( ( yy_n += yychar ) < 0 ) || ( yy_n >= YYLAST ) )
			goto yydefault;
		if ( yychk[ yy_n = yyact[ yy_n ] ] == yychar )	/*valid shift*/
		{
			yychar = -1;
			yyval = yylval;
			yy_state = yy_n;
			if ( yyerrflag > 0 )
				yyerrflag--;
			goto yy_stack;
		}

	yydefault:
		if ( ( yy_n = yydef[ yy_state ] ) == -2 )
		{
#if YYDEBUG
			yytmp = yychar < 0;
#endif
			if ( ( yychar < 0 ) && ( ( yychar = yylex() ) < 0 ) )
				yychar = 0;		/* reached EOF */
#if YYDEBUG
			if ( yydebug && yytmp )
			{
				register int yy_i;

				printf( "Received token " );
				if ( yychar == 0 )
					printf( "end-of-file\n" );
				else if ( yychar < 0 )
					printf( "-none-\n" );
				else
				{
					for ( yy_i = 0;
						yytoks[yy_i].t_val >= 0;
						yy_i++ )
					{
						if ( yytoks[yy_i].t_val
							== yychar )
						{
							break;
						}
					}
					printf( "%s\n", yytoks[yy_i].t_name );
				}
			}
#endif /* YYDEBUG */
			/*
			** look through exception table
			*/
			{
				register int *yyxi = yyexca;

				while ( ( *yyxi != -1 ) ||
					( yyxi[1] != yy_state ) )
				{
					yyxi += 2;
				}
				while ( ( *(yyxi += 2) >= 0 ) &&
					( *yyxi != yychar ) )
					;
				if ( ( yy_n = yyxi[1] ) < 0 )
					YYACCEPT;
			}
		}

		/*
		** check for syntax error
		*/
		if ( yy_n == 0 )	/* have an error */
		{
			/* no worry about speed here! */
			switch ( yyerrflag )
			{
			case 0:		/* new error */
				yyerror( "syntax error" );
				goto skip_init;
			yyerrlab:
				/*
				** get globals into registers.
				** we have a user generated syntax type error
				*/
				yy_pv = yypv;
				yy_ps = yyps;
				yy_state = yystate;
				yynerrs++;
			skip_init:
			case 1:
			case 2:		/* incompletely recovered error */
					/* try again... */
				yyerrflag = 3;
				/*
				** find state where "error" is a legal
				** shift action
				*/
				while ( yy_ps >= yys )
				{
					yy_n = yypact[ *yy_ps ] + YYERRCODE;
					if ( yy_n >= 0 && yy_n < YYLAST &&
						yychk[yyact[yy_n]] == YYERRCODE)					{
						/*
						** simulate shift of "error"
						*/
						yy_state = yyact[ yy_n ];
						goto yy_stack;
					}
					/*
					** current state has no shift on
					** "error", pop stack
					*/
#if YYDEBUG
#	define _POP_ "Error recovery pops state %d, uncovers state %d\n"
					if ( yydebug )
						printf( _POP_, *yy_ps,
							yy_ps[-1] );
#	undef _POP_
#endif
					yy_ps--;
					yy_pv--;
				}
				/*
				** there is no state on stack with "error" as
				** a valid shift.  give up.
				*/
				YYABORT;
			case 3:		/* no shift yet; eat a token */
#if YYDEBUG
				/*
				** if debugging, look up token in list of
				** pairs.  0 and negative shouldn't occur,
				** but since timing doesn't matter when
				** debugging, it doesn't hurt to leave the
				** tests here.
				*/
				if ( yydebug )
				{
					register int yy_i;

					printf( "Error recovery discards " );
					if ( yychar == 0 )
						printf( "token end-of-file\n" );
					else if ( yychar < 0 )
						printf( "token -none-\n" );
					else
					{
						for ( yy_i = 0;
							yytoks[yy_i].t_val >= 0;
							yy_i++ )
						{
							if ( yytoks[yy_i].t_val
								== yychar )
							{
								break;
							}
						}
						printf( "token %s\n",
							yytoks[yy_i].t_name );
					}
				}
#endif /* YYDEBUG */
				if ( yychar == 0 )	/* reached EOF. quit */
					YYABORT;
				yychar = -1;
				goto yy_newstate;
			}
		}/* end if ( yy_n == 0 ) */
		/*
		** reduction by production yy_n
		** put stack tops, etc. so things right after switch
		*/
#if YYDEBUG
		/*
		** if debugging, print the string that is the user's
		** specification of the reduction which is just about
		** to be done.
		*/
		if ( yydebug )
			printf( "Reduce by (%d) \"%s\"\n",
				yy_n, yyreds[ yy_n ] );
#endif
		yytmp = yy_n;			/* value to switch over */
		yypvt = yy_pv;			/* $vars top of value stack */
		/*
		** Look in goto table for next state
		** Sorry about using yy_state here as temporary
		** register variable, but why not, if it works...
		** If yyr2[ yy_n ] doesn't have the low order bit
		** set, then there is no action to be done for
		** this reduction.  So, no saving & unsaving of
		** registers done.  The only difference between the
		** code just after the if and the body of the if is
		** the goto yy_stack in the body.  This way the test
		** can be made before the choice of what to do is needed.
		*/
		{
			/* length of production doubled with extra bit */
			register int yy_len = yyr2[ yy_n ];

			if ( !( yy_len & 01 ) )
			{
				yy_len >>= 1;
				yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
				yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
					*( yy_ps -= yy_len ) + 1;
				if ( yy_state >= YYLAST ||
					yychk[ yy_state =
					yyact[ yy_state ] ] != -yy_n )
				{
					yy_state = yyact[ yypgo[ yy_n ] ];
				}
				goto yy_stack;
			}
			yy_len >>= 1;
			yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
			yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
				*( yy_ps -= yy_len ) + 1;
			if ( yy_state >= YYLAST ||
				yychk[ yy_state = yyact[ yy_state ] ] != -yy_n )
			{
				yy_state = yyact[ yypgo[ yy_n ] ];
			}
		}
					/* save until reenter driver code */
		yystate = yy_state;
		yyps = yy_ps;
		yypv = yy_pv;
	}
	/*
	** code supplied by user is placed in this switch
	*/
	switch( yytmp )
	{
		
case 2:
# line 104 "ftpcmd.y"
 {
			fromname = (char *) 0;
		} break;
case 4:
# line 111 "ftpcmd.y"
 {
			extern struct passwd *sgetpwnam();
		/* wjw fixed, anonymous user is not allowed to change
		 * to a different user
		 */
		if (logged_in) {
			if (guest) {
				reply(530, "Can't change user from guest login.");
				return;
			}
		}
		else  {

			logged_in = 0;
			if (strcmp((char *) yypvt[-1], "ftp") == 0 ||
			  strcmp((char *) yypvt[-1], "anonymous") == 0) {
				if ((pw = sgetpwnam("ftp")) != NULL) {
					guest = 1;
					reply(331,
				  "Guest login ok, send E-mail address as password.");
				}
				else {
					reply(530, "User %s unknown.", yypvt[-1]);
				}
			} else if (checkuser((char *) yypvt[-1])) {
				guest = 0;
				pw = sgetpwnam((char *) yypvt[-1]);
				if (pw == NULL) {
					reply(530, "User %s unknown.", yypvt[-1]);
				}
				else {
				    reply(331, "Password required for %s.", yypvt[-1]);
				}
			} else {
				reply(530, "User %s access denied.", yypvt[-1]);
			}
		}
		free((char *) yypvt[-1]);
		} break;
case 5:
# line 151 "ftpcmd.y"
 {
			pass((char *) yypvt[-1]);
			free((char *) yypvt[-1]);
		} break;
case 6:
# line 156 "ftpcmd.y"
 {
			usedefault = 0;
			if (pdata > 0) {
				(void) close(pdata);
			}
			pdata = -1;
			reply(200, "PORT command successful.");
		} break;
case 7:
# line 165 "ftpcmd.y"
 {
			passive();
		} break;
case 8:
# line 169 "ftpcmd.y"
 {
			switch (cmd_type) {

			case TYPE_A:
				if (cmd_form == FORM_N) {
					reply(200, "Type set to A.");
					type = cmd_type;
					form = cmd_form;
				} else
					reply(504, "Form must be N.");
				break;

			case TYPE_E:
				reply(504, "Type E not implemented.");
				break;

			case TYPE_I:
				reply(200, "Type set to I.");
				type = cmd_type;
				break;

			case TYPE_L:
				if (cmd_bytesz == 8) {
					reply(200,
					    "Type set to L (byte size 8).");
					type = cmd_type;
				} else
					reply(504, "Byte size must be 8.");
			}
		} break;
case 9:
# line 200 "ftpcmd.y"
 {
			switch (yypvt[-1]) {

			case STRU_F:
				reply(200, "STRU F ok.");
				break;

			default:
				reply(504, "Unimplemented STRU type.");
			}
		} break;
case 10:
# line 212 "ftpcmd.y"
 {
			switch (yypvt[-1]) {

			case MODE_S:
				reply(200, "MODE S ok.");
				break;

			default:
				reply(502, "Unimplemented MODE type.");
			}
		} break;
case 11:
# line 224 "ftpcmd.y"
 {
			reply(202, "ALLO command ignored.");
		} break;
case 12:
# line 228 "ftpcmd.y"
 {
			if (yypvt[-3] && yypvt[-1] != NULL)
				retrieve((char *) 0, (char *) yypvt[-1]);
			if (yypvt[-1] != NULL)
				free((char *) yypvt[-1]);
		} break;
case 13:
# line 235 "ftpcmd.y"
 {
			if (yypvt[-3] && yypvt[-1] != NULL)
				store((char *) yypvt[-1], "w");
			if (yypvt[-1] != NULL)
				free((char *) yypvt[-1]);
		} break;
case 14:
# line 242 "ftpcmd.y"
 {
			if (yypvt[-3] && yypvt[-1] != NULL)
				store((char *) yypvt[-1], "a");
			if (yypvt[-1] != NULL)
				free((char *) yypvt[-1]);
		} break;
case 15:
# line 249 "ftpcmd.y"
 {
			if (yypvt[-1])
				retrieve("/bin/ls", "");
		} break;
case 16:
# line 254 "ftpcmd.y"
 {
			if (yypvt[-3] && yypvt[-1] != NULL)
				retrieve("/bin/ls %s", (char *) yypvt[-1]);
			if (yypvt[-1] != NULL)
				free((char *) yypvt[-1]);
		} break;
case 17:
# line 261 "ftpcmd.y"
 {
			if (yypvt[-1])
				retrieve("/bin/ls -lgL", "");
		} break;
case 18:
# line 266 "ftpcmd.y"
 {
			if (yypvt[-3] && yypvt[-1] != NULL)
				retrieve("/bin/ls -lg %s", (char *) yypvt[-1]);
			if (yypvt[-1] != NULL)
				free((char *) yypvt[-1]);
		} break;
case 19:
# line 273 "ftpcmd.y"
 {
			if (yypvt[-3] && yypvt[-1] != NULL)
				delete((char *) yypvt[-1]);
			if (yypvt[-1] != NULL)
				free((char *) yypvt[-1]);
		} break;
case 20:
# line 280 "ftpcmd.y"
 {
			if (fromname) {
				renamecmd(fromname, (char *) yypvt[-1]);
				free(fromname);
				fromname = (char *) 0;
			} else {
				reply(503, "Bad sequence of commands.");
			}
			free((char *) yypvt[-1]);
		} break;
case 21:
# line 291 "ftpcmd.y"
 {
			reply(225, "ABOR command successful.");
		} break;
case 22:
# line 295 "ftpcmd.y"
 {
			if (yypvt[-1])
				cwd(pw->pw_dir);
		} break;
case 23:
# line 300 "ftpcmd.y"
 {
			if (yypvt[-3] && yypvt[-1] != NULL)
				cwd((char *) yypvt[-1]);
			if (yypvt[-1] != NULL)
				free((char *) yypvt[-1]);
		} break;
case 24:
# line 307 "ftpcmd.y"
 {
			help((char *) 0);
		} break;
case 25:
# line 311 "ftpcmd.y"
 {
			help((char *) yypvt[-1]);
		} break;
case 26:
# line 315 "ftpcmd.y"
 {
			reply(200, "NOOP command successful.");
		} break;
case 27:
# line 319 "ftpcmd.y"
 {
			if (yypvt[-3] && yypvt[-1] != NULL)
				makedir((char *) yypvt[-1]);
			if (yypvt[-1] != NULL)
				free((char *) yypvt[-1]);
		} break;
case 28:
# line 326 "ftpcmd.y"
 {
			if (yypvt[-3] && yypvt[-1] != NULL)
				removedir((char *) yypvt[-1]);
			if (yypvt[-1] != NULL)
				free((char *) yypvt[-1]);
		} break;
case 29:
# line 333 "ftpcmd.y"
 {
			if (yypvt[-1])
				pwd();
		} break;
case 30:
# line 338 "ftpcmd.y"
 {
			if (yypvt[-1])
				cwd("..");
		} break;
case 31:
# line 343 "ftpcmd.y"
 {
			if (yypvt[-3] && yypvt[-1] != NULL) {
				unique++;
				store((char *) yypvt[-1], "w");
				unique = 0;
			}
			if (yypvt[-1] != NULL)
				free((char *) yypvt[-1]);
		} break;
case 32:
# line 353 "ftpcmd.y"
 {
			reply(221, "Goodbye.");
			dologout(0);
		} break;
case 33:
# line 358 "ftpcmd.y"
 {
			yyerrok;
		} break;
case 34:
# line 364 "ftpcmd.y"
 {
			char *renamefrom();

			if (yypvt[-3] && yypvt[-1]) {
				fromname = renamefrom((char *) yypvt[-1]);
				if (fromname == (char *) 0 && yypvt[-1]) {
					free((char *) yypvt[-1]);
				}
			}
		} break;
case 38:
# line 387 "ftpcmd.y"
 {
			register char *a, *p;

			a = (char *)&data_dest.sin_addr;
			a[0] = yypvt[-10]; a[1] = yypvt[-8]; a[2] = yypvt[-6]; a[3] = yypvt[-4];
			p = (char *)&data_dest.sin_port;
			p[0] = yypvt[-2]; p[1] = yypvt[-0];
			data_dest.sin_family = AF_INET;
		} break;
case 39:
# line 399 "ftpcmd.y"
 {
		yyval = FORM_N;
	} break;
case 40:
# line 403 "ftpcmd.y"
 {
		yyval = FORM_T;
	} break;
case 41:
# line 407 "ftpcmd.y"
 {
		yyval = FORM_C;
	} break;
case 42:
# line 413 "ftpcmd.y"
 {
		cmd_type = TYPE_A;
		cmd_form = FORM_N;
	} break;
case 43:
# line 418 "ftpcmd.y"
 {
		cmd_type = TYPE_A;
		cmd_form = yypvt[-0];
	} break;
case 44:
# line 423 "ftpcmd.y"
 {
		cmd_type = TYPE_E;
		cmd_form = FORM_N;
	} break;
case 45:
# line 428 "ftpcmd.y"
 {
		cmd_type = TYPE_E;
		cmd_form = yypvt[-0];
	} break;
case 46:
# line 433 "ftpcmd.y"
 {
		cmd_type = TYPE_I;
	} break;
case 47:
# line 437 "ftpcmd.y"
 {
		cmd_type = TYPE_L;
		cmd_bytesz = 8;
	} break;
case 48:
# line 442 "ftpcmd.y"
 {
		cmd_type = TYPE_L;
		cmd_bytesz = yypvt[-0];
	} break;
case 49:
# line 448 "ftpcmd.y"
 {
		cmd_type = TYPE_L;
		cmd_bytesz = yypvt[-0];
	} break;
case 50:
# line 455 "ftpcmd.y"
 {
		yyval = STRU_F;
	} break;
case 51:
# line 459 "ftpcmd.y"
 {
		yyval = STRU_R;
	} break;
case 52:
# line 463 "ftpcmd.y"
 {
		yyval = STRU_P;
	} break;
case 53:
# line 469 "ftpcmd.y"
 {
		yyval = MODE_S;
	} break;
case 54:
# line 473 "ftpcmd.y"
 {
		yyval = MODE_B;
	} break;
case 55:
# line 477 "ftpcmd.y"
 {
		yyval = MODE_C;
	} break;
case 56:
# line 483 "ftpcmd.y"
 {
		/*
		 * Problem: this production is used for all pathname
		 * processing, but only gives a 550 error reply.
		 * This is a valid reply in some cases but not in others.
		 */
		if (yypvt[-0] && strncmp((char *) yypvt[-0], "~", 1) == 0) {
			yyval = (int)*glob((char *) yypvt[-0]);
			if (globerr != NULL) {
				reply(550, globerr);
				yyval = NULL;
			}
			free((char *) yypvt[-0]);
		} else
			yyval = yypvt[-0];
	} break;
case 58:
# line 505 "ftpcmd.y"
 {
		if (logged_in)
			yyval = 1;
		else {
			reply(530, "Please login with USER and PASS.");
			yyval = 0;
		}
	} break;
	}
	goto yystack;		/* reset registers in driver code */
}
