/*
 * Fixes for ftpd for systems without chroot system call.
 *
 * Sam Shen (sls@ocf.berkeley.edu)
 *
 * Bugs pointed out and fixes kindly donated by
 * Richard Walker (walrmath@fac5.anu.edu.au)
 * Corey Geheim (cg377170@eng.clemson.edu)
 */
#include <string.h>
#undef NULL
#include <sys/param.h>

static char * root;
extern int guest;

int chroot(char * s)
{   /* 
     *	Keep what is defined to be the root for this FTP
     *  session.
     */          
    char actualpath[MAXPATHLEN];

    /*  First we really go there 
     */
    if (chdir(s))
	return -1;              
    /* Then get the pathname
     */
    getwd(actualpath);
    root = (char *) malloc(strlen(actualpath)+2);
    if (!root)
	return -1;
    strcpy(root,actualpath);
    strcat(root,"/");
    return 0;
}

char * next_component(char ** pp)
{   /* 
     *	Scan for a new element of the filename
     */
    static char buf[MAXPATHLEN];
    int i;
    char * c, * component;
    component = buf;
    c = *pp;
    i = 0;
    /* scan a complete new component */
    while (*c) {
	component[i++] = *c;
	if (*c == '/') break;
	c++;
    }     

    /* *c might still point at the '/' */
    if (!*c) {
	c++;        
        /* Copy all possible trailing '/''s */
        while (*c) {
	    if (*c != '/') break;
	    component[i++] = *c;
	    c++;
	}
	if (*c) c--;
    }
    component[i] = '\0';	/* terminate the part */
    if (*c) *pp = c + 1;	/* and update the input name string */
    else *pp = c;		/* but keep the terminator */
    return component;
}

int dotdot(char * p)
{   /* 
     * Does *p equal ../------> ? 
     */
    if (*p++ == '.')
	if (*p++ == '.')
	    if (!*p || *p == '/')
		return 1;
    return 0;
}

int singledot(char * p)
{   /* 
     * Does *p equal ./------> ? 
     */
    if (*p++ == '.')
	if (!*p || *p == '/')
	    return 1;
    return 0;
}

int no_slashes(char * p)
{   /*
     * Is this a reference in the current directory ?
     */
    while (*p && *p != '/')
	p++;
    return *p == '/' ? 0 : 1;
}

char * _fixpath(char * p)
{
    static char buf[MAXPATHLEN];
    static char newpath[MAXPATHLEN];
    char * rt,* path, * rt_comp, * path_comp;
    int depth;
    int i;

    /* non-anon ftp has regular access to everything they would
     * like to access
     */
    if (!guest) 
	return p;

    /*
     * is it a regular path with noting strange in it
     */
    if (no_slashes(p) && !dotdot(p)) 
	return p;

    if (*p == '/') { 
	/* prepend the result of the "chroot" call */
	strcpy(buf,root);
	p++;
    } else { 
        /* get the current directory as start of the path */
	if (getwd(buf) == 0) 
	    return NULL;
	strcat(buf,"/");
    }
    strcat(buf,p);
    path = buf;
    rt = root;
    newpath[0] = '\0';
    while (1) {
	rt_comp = next_component(&rt);
	if (!*rt_comp) break;
	path_comp = next_component(&path);
	if (strcmp(rt_comp,path_comp)) return NULL;
	strcat(newpath,path_comp);
    }
    depth = 0;
    while (*path_comp) {
	path_comp = next_component(&path);
	if (dotdot(path_comp)) {
	    if (depth != 0) {
		strcat(newpath,path_comp);
		depth--;
	    }
	} else {
	    strcat(newpath,path_comp);
	    if (!singledot(path_comp))
		depth++;
	}
    }
    return newpath;
}

