/* gpr2gif.c - convert an apollo GPR bitmap to a GIF file
 *
 *                 Version 1.0   12/13/1989
 *
 *  This file contains system-specific graphics routines.
 *  These routines use Apollo Graphics Primitive Resource (GPR) calls.
 *
 *  Authors:   Roque D. Oliveira      oliveria@caen.engin.umich.edu
 *             Amadi Nwankpa             amadi@caen.engin.umich.edu
 *
 *  If you make any improvements/bug fixes to this program, please send
 *  them to the authors.
 */

/*
 * Copyright (C) 1990 by the author(s).
 * All rights reserved.
 *
 * Permission is granted to copy, modify and distribute this program
 * for any purpose and without charge, provided this copyright notice
 * is included in the copy.
 * This program is distributed on an as-is basis. There will be
 * ABSOLUTELY NO WARRANTY for any part of this software to work
 * correctly. In no case will the author(s) be liable to you for any
 * lost revenue or profits or other special, indirect and consequential
 * damages caused by the usage of this program.
 */

#include <stdio.h>
#include <string.h>

#include <apollo/base.h>
#include <apollo/gpr.h>
#include <apollo/pfm.h>
#include <apollo/error.h>

#define MAXLINE  4096            /* max width of a line */

char       *progname;		
status_$t  status;

void usage()
{
    fprintf(stderr,"usage: %s [ -o gif_file_name ] gpr_bitmap_file_name  \n",progname);
    exit(-1);
}

void check(messagex)
char *messagex;
{
   if (status.all != status_$ok)
     {
/*         error_$print (status); */
         fprintf(stderr,"Error occurred while %s. \n", messagex); 
         pfm_$error_trap(status);
     }    
}


int GetPixel();

main(argc,argv)
int     argc;
char    *argv[];
{
   gpr_$attribute_desc_t           attribs;
   short int                       groups = (short) 1;
   gpr_$version_t                  version;
   gpr_$offset_t                   disk_bm_size;
   gpr_$window_t                   scanline;
   gpr_$bmf_group_header_array_t   header;
   gpr_$pixel_value_t              pixel_32_array[MAXLINE];      
   gpr_$color_vector_t             color_map;
   gpr_$bitmap_desc_t              junk_desc , disk_bitmap_desc;
   boolean                         created;

   int  red[256] , grn[256] , blu[256] ; 
   int  pix , num_colors ;
   extern unsigned char get_pixel(); 
                                   
/* getopt stuff */
	extern int	optind;     /* index of which argument is next */
	extern char	*optarg;    /* pointer to argument of this option */ 
    int  c ;
                 
  char *outname;		
  char *output_file_name = NULL;
  char *input_file_name;

   progname = strrchr(argv[0], '/');
   if (progname)
       progname++;
    else
       progname = argv[0];

while ((c=getopt(argc,argv,"o:"))!=EOF) 
 {
	switch (c)
     {
		case 'o':
                     output_file_name = optarg; 
                     break;      
		case '?':
		default :
                     usage();
     }
 }
                    
if (argc == optind)
 {
   usage();
 }
else
 { 
  input_file_name = argv[optind];

  if(output_file_name == NULL)
   {
    outname = strrchr(argv[optind], '/');
    if (outname)
        outname++;
     else
        outname = argv[optind];

    output_file_name =(char *)  malloc(256);
    strcpy(output_file_name,outname);
    strcat(output_file_name,".gif");
   }
  optind++;
 }

if ( optind != argc ) usage();

fprintf(stdout,"input  file = %s \n",input_file_name);
fprintf(stdout,"output file = %s \n",output_file_name);


/*  Initialize the GPR library with a 1x1 dummy bitmap in main memory */
    disk_bm_size.x_size = (short) 1;
    disk_bm_size.y_size = (short) 1;
    gpr_$init(gpr_$no_display, (stream_$id_t) 0, disk_bm_size, (gpr_$plane_t) 0, &junk_desc, &status);
    check("in main, after calling gpr_$init");

    gpr_$allocate_attribute_block(&attribs, &status);
    check("in main, after calling gpr_$allocate_attribute_block");
    gpr_$open_bitmap_file(gpr_$readonly, input_file_name, (short)strlen(input_file_name), &version,
        &disk_bm_size, &groups, header, attribs, &disk_bitmap_desc, &created, &status);
    check("in main, after calling gpr_$open_bitmap_file");

fprintf(stderr,"Image Characteristics    \n");
fprintf(stderr,"  Image Size        : %d  %d \n",disk_bm_size.x_size,disk_bm_size.y_size);
fprintf(stderr,"  Number of groups  : %d \n",groups);
fprintf(stderr,"  Number of planes  : %d \n",header[0].n_sects);
fprintf(stderr,"  Pixel size        : %d \n",header[0].pixel_size);
fprintf(stderr,"  Allocated Size    : %d \n",header[0].allocated_size);
fprintf(stderr,"  Bytes per line    : %d \n",header[0].bytes_per_line);
fprintf(stderr,"  Bytes per section : %d \n",header[0].bytes_per_sect);

   if(header[0].n_sects == 1) 
     { 
      color_map[0] =  gpr_$black ;
      color_map[1] =  gpr_$white ; 
      num_colors   = 2 ;
      fprintf(stderr,"  Internal Colormap : false . Using Black and White. \n");
     }
   else
     {
       num_colors   = 256 ;
       gpr_$inq_bitmap_file_color_map(disk_bitmap_desc, (short) 0,(short) 256, color_map, &status);   
       if((status.all == gpr_$no_color_map_in_file) || (status.all == gpr_$invalid_color_map) )
              {        
                error_$print (status);
                gpr_$inq_color_map((gpr_$pixel_value_t) 0, (short) 256, color_map, &status); 
                check("in main, after calling gpr_$inq_color_map"); 
                fprintf(stderr,"  Internal Colormap : false . Using this workstation's color map. \n");
              }
       else  
              {
               check("in main, after calling gpr_$inq_bitmap_file_color_map");
               fprintf(stderr,"  Internal Colormap : true \n");
              }
     }

/* Set the current bitmap to be the GPR bitmap file */
   gpr_$set_bitmap(disk_bitmap_desc, &status);
   check("in main, after calling gpr_$set_bitmap");

                                  
   for(pix=0;pix<num_colors;pix++)
   { 
     red[pix] = (color_map[pix] / 65536) & 0xFF;
     grn[pix] = (color_map[pix] / 256  ) & 0xFF;
     blu[pix] = (color_map[pix]        ) & 0xFF;
    }          
                                       
 GIFEncode(output_file_name,disk_bm_size.x_size,disk_bm_size.y_size,1L,0,header[0].n_sects,red,grn,blu,GetPixel); 

}

GetPixel(xp,yp)
int xp,yp;
{
 int pik;
    
	pik = (int)get_pixel(xp,yp); 
    return(pik);
}


/****************************************************************************
 *    read one pixel of bitmap
 ****************************************************************************/

unsigned char get_pixel(x,y)
int x, y;
    {
    gpr_$window_t           scanline;
    gpr_$pixel_value_t      pixel_32_array[1];

    scanline.window_base.x_coord = x;
    scanline.window_base.y_coord = y;
    scanline.window_size.x_size  = 1;
    scanline.window_size.y_size  = 1;

    gpr_$read_pixels(scanline, pixel_32_array, &status);
    check("in get_pixel, after calling gpr_$read_pixels");
    return(pixel_32_array[0]);
    }

